/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import com.sun.java.swing.plaf.windows.DesktopProperty;
import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.UIResource;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

public class WindowsTitledBorderPatch
implements LookAndFeelPatch {
    public boolean isApplicable(Environment env) {
        return env.isWindowsLookAndFeel() && (env.isJavaVersionLessThan(Environment.JAVA_1_5_0) || !env.isWindowsXPThemed());
    }

    public void patch(Environment env) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        DesktopProperty highLight = new DesktopProperty("win.3d.highlightColor", (Object)UIManager.getColor("controlLtHighlight"), toolkit);
        DesktopProperty shadow = new DesktopProperty("win.3d.shadowColor", (Object)UIManager.getColor("controlShadow"), toolkit);
        UIManager.put("TitledBorder.border", new WindowsTitleBorder(highLight, shadow));
    }

    public void unpatch() {
    }

    private class WindowsTitleBorder
    extends EtchedBorder
    implements UIResource {
        private DesktopProperty _highLight;
        private DesktopProperty _shadow;

        public WindowsTitleBorder(DesktopProperty highLight, DesktopProperty shadow) {
            super(1);
            this._highLight = highLight;
            this._shadow = shadow;
        }

        public Color getHighlightColor() {
            return (Color)this._highLight.createValue(UIManager.getDefaults());
        }

        public Color getShadowColor() {
            return (Color)this._shadow.createValue(UIManager.getDefaults());
        }
    }
}

