/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.List;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfRow;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class RtfCell
extends Cell
implements RtfExtendedElement {
    private static final int MERGE_NONE = 0;
    private static final int MERGE_VERT_PARENT = 1;
    private static final int MERGE_VERT_CHILD = 2;
    private RtfRow parentRow = null;
    private ArrayList content = null;
    private int cellRight = 0;
    private int cellWidth = 0;
    private RtfBorderGroup borders = null;
    private RtfColor backgroundColor = null;
    private int cellPadding = 0;
    private int mergeType = 0;
    private RtfDocument document = null;
    private boolean inHeader = false;
    private boolean deleted = false;

    public RtfCell() {
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    public RtfCell(String string) {
        super(string);
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    public RtfCell(Element element) throws BadElementException {
        super(element);
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    public RtfCell(Properties properties) {
        super(properties);
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    protected RtfCell(boolean bl) {
        this.deleted = bl;
        this.verticalAlignment = 5;
    }

    protected RtfCell(RtfDocument rtfDocument, RtfRow rtfRow, Cell cell) {
        this.document = rtfDocument;
        this.parentRow = rtfRow;
        this.importCell(cell);
    }

    private void importCell(Cell cell) {
        Object object;
        this.content = new ArrayList();
        if (cell == null) {
            this.borders = new RtfBorderGroup(this.document, 2, this.parentRow.getParentTable().getBorders());
            return;
        }
        this.colspan = cell.getColspan();
        this.rowspan = cell.getRowspan();
        if (cell.getRowspan() > 1) {
            this.mergeType = 1;
        }
        this.borders = cell instanceof RtfCell ? new RtfBorderGroup(this.document, 2, ((RtfCell)cell).getBorders()) : new RtfBorderGroup(this.document, 2, cell.getBorder(), cell.getBorderWidth(), cell.getBorderColor());
        this.verticalAlignment = cell.getVerticalAlignment();
        this.backgroundColor = cell.getBackgroundColor() == null ? new RtfColor(this.document, 255, 255, 255) : new RtfColor(this.document, cell.getBackgroundColor());
        this.cellPadding = (int)this.parentRow.getParentTable().getCellPadding();
        Iterator iterator = cell.getElements();
        Paragraph paragraph = null;
        while (iterator.hasNext()) {
            try {
                RtfBasicElement rtfBasicElement;
                object = (Element)iterator.next();
                if (!(object instanceof Paragraph) && !(object instanceof List)) {
                    if (paragraph != null) {
                        paragraph.add(object);
                        continue;
                    }
                    paragraph = new Paragraph();
                    paragraph.setAlignment(cell.getHorizontalAlignment());
                    paragraph.add(object);
                    continue;
                }
                if (paragraph != null) {
                    rtfBasicElement = this.document.getMapper().mapElement(paragraph);
                    rtfBasicElement.setInTable(true);
                    this.content.add(rtfBasicElement);
                    paragraph = null;
                }
                if (object instanceof Paragraph && ((Paragraph)object).getAlignment() == -1) {
                    ((Paragraph)object).setAlignment(cell.getHorizontalAlignment());
                }
                rtfBasicElement = this.document.getMapper().mapElement((Element)object);
                rtfBasicElement.setInTable(true);
                this.content.add(rtfBasicElement);
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
        if (paragraph != null) {
            try {
                object = this.document.getMapper().mapElement(paragraph);
                object.setInTable(true);
                this.content.add(object);
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeDefinition(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        if (this.mergeType == 1) {
            outputStream.write("\\clvmgf".getBytes());
        } else if (this.mergeType == 2) {
            outputStream.write("\\clvmrg".getBytes());
        }
        switch (this.verticalAlignment) {
            case 6: {
                outputStream.write("\\clvertalb".getBytes());
                break;
            }
            case 1: 
            case 5: {
                outputStream.write("\\clvertalc".getBytes());
                break;
            }
            case 4: {
                outputStream.write("\\clvertalt".getBytes());
            }
        }
        this.borders.writeContent(outputStream);
        if (this.backgroundColor != null) {
            outputStream.write("\\clcbpat".getBytes());
            outputStream.write(this.intToByteArray(this.backgroundColor.getColorNumber()));
        }
        outputStream.write(10);
        outputStream.write("\\clftsWidth3".getBytes());
        outputStream.write(10);
        outputStream.write("\\clwWidth".getBytes());
        outputStream.write(this.intToByteArray(this.cellWidth));
        outputStream.write(10);
        if (this.cellPadding > 0) {
            outputStream.write("\\clpadl".getBytes());
            outputStream.write(this.intToByteArray(this.cellPadding / 2));
            outputStream.write("\\clpadt".getBytes());
            outputStream.write(this.intToByteArray(this.cellPadding / 2));
            outputStream.write("\\clpadr".getBytes());
            outputStream.write(this.intToByteArray(this.cellPadding / 2));
            outputStream.write("\\clpadb".getBytes());
            outputStream.write(this.intToByteArray(this.cellPadding / 2));
            outputStream.write("\\clpadfl3".getBytes());
            outputStream.write("\\clpadft3".getBytes());
            outputStream.write("\\clpadfr3".getBytes());
            outputStream.write("\\clpadfb3".getBytes());
        }
        outputStream.write("\\cellx".getBytes());
        outputStream.write(this.intToByteArray(this.cellRight));
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeContent(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        if (this.content.size() == 0) {
            outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            if (this.parentRow.getParentTable().getTableFitToPage()) {
                outputStream.write(RtfParagraphStyle.KEEP_TOGETHER_WITH_NEXT);
            }
            outputStream.write(RtfParagraph.IN_TABLE);
        } else {
            for (int i = 0; i < this.content.size(); ++i) {
                RtfBasicElement rtfBasicElement = (RtfBasicElement)this.content.get(i);
                if (rtfBasicElement instanceof RtfParagraph) {
                    ((RtfParagraph)rtfBasicElement).setKeepTogetherWithNext(this.parentRow.getParentTable().getTableFitToPage());
                }
                rtfBasicElement.writeContent(outputStream);
                if (!(rtfBasicElement instanceof RtfParagraph) || i >= this.content.size() - 1) continue;
                outputStream.write(RtfParagraph.PARAGRAPH);
            }
        }
        outputStream.write("\\cell".getBytes());
    }

    protected void setCellRight(int n) {
        this.cellRight = n;
    }

    protected int getCellRight() {
        return this.cellRight;
    }

    protected void setCellWidth(int n) {
        this.cellWidth = n;
    }

    protected int getCellWidth() {
        return this.cellWidth;
    }

    protected int getCellpadding() {
        return this.cellPadding;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    public void setBorders(RtfBorderGroup rtfBorderGroup) {
        this.borders = new RtfBorderGroup(this.document, 2, rtfBorderGroup);
    }

    protected RtfColor getRtfBackgroundColor() {
        return this.backgroundColor;
    }

    protected void setCellMergeChild(RtfCell rtfCell) {
        this.mergeType = 2;
        this.cellWidth = rtfCell.getCellWidth();
        this.cellRight = rtfCell.getCellRight();
        this.cellPadding = rtfCell.getCellpadding();
        this.borders = rtfCell.getBorders();
        this.verticalAlignment = rtfCell.getVerticalAlignment();
        this.backgroundColor = rtfCell.getRtfBackgroundColor();
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
    }

    public void setInTable(boolean bl) {
    }

    public void setInHeader(boolean bl) {
        this.inHeader = bl;
        for (int i = 0; i < this.content.size(); ++i) {
            ((RtfBasicElement)this.content.get(i)).setInHeader(bl);
        }
    }

    private byte[] intToByteArray(int n) {
        return Integer.toString(n).getBytes();
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

