/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import java.io.Serializable;
import javax.realtime.MemoryArea;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.context.Realtime;
import javolution.context.RealtimeObject;
import javolution.lang.Immutable;
import javolution.text.CharArray;
import javolution.text.CharSet;
import javolution.text.TypeFormat;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public abstract class Text
extends RealtimeObject
implements CharSequence,
Comparable,
Serializable,
Immutable {
    private static final FastMap INTERN_INSTANCES = new FastMap().setKeyComparator(FastComparator.LEXICAL);
    private static String _tmpString;
    private static final Runnable INTERN_STRING;
    public static final Text EMPTY;
    public static final Text NULL;
    protected static final XMLFormat<Text> XML;
    int _count;
    int _hashCode;
    private static final Text TRUE;
    private static final Text FALSE;
    private static final Text[] ASCII;

    private Text() {
    }

    public static Text valueOf(Object object) {
        if (object instanceof String) {
            return StringWrapper.newInstance((String)object);
        }
        if (object instanceof Realtime) {
            return ((Realtime)object).toText();
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return Text.valueOf(charSequence, 0, charSequence.length());
        }
        if (object != null) {
            return StringWrapper.newInstance(object.toString());
        }
        return NULL;
    }

    public static Text valueOf(CharSequence charSequence, int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > charSequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 <= 32) {
            Primitive primitive = Primitive.newInstance(n3);
            int n4 = 0;
            while (n4 < n3) {
                ((Primitive)primitive)._data[n4] = charSequence.charAt(n + n4++);
            }
            return primitive;
        }
        int n5 = n + (n3 >> 1);
        Composite composite = Composite.newInstance(Text.valueOf(charSequence, n, n5), Text.valueOf(charSequence, n5, n2));
        return composite;
    }

    public static Text valueOf(char[] cArray) {
        return Text.valueOf(cArray, 0, cArray.length);
    }

    public static Text valueOf(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 <= 32) {
            Primitive primitive = Primitive.newInstance(n2);
            int n3 = 0;
            while (n3 < n2) {
                ((Primitive)primitive)._data[n3] = cArray[n + n3++];
            }
            return primitive;
        }
        int n4 = n + (n2 >> 1);
        Composite composite = Composite.newInstance(Text.valueOf(cArray, n, n4 - n), Text.valueOf(cArray, n4, n + n2 - n4));
        return composite;
    }

    public static Text valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static Text valueOf(char c) {
        if (c < '\u0080' && ASCII[c] != null) {
            return ASCII[c];
        }
        Primitive primitive = Primitive.newInstance(1);
        ((Primitive)primitive)._data[0] = c;
        Text text = Text.intern(primitive);
        if (c < '\u0080') {
            Text.ASCII[c] = text;
        }
        return text;
    }

    public static Text valueOf(int n) {
        try {
            Primitive primitive = Primitive.newInstance(0);
            TypeFormat.format(n, (Appendable)primitive);
            return primitive;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public static Text valueOf(int n, int n2) {
        try {
            Primitive primitive = Primitive.newInstance(0);
            TypeFormat.format(n, n2, (Appendable)primitive);
            return primitive;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public static Text valueOf(long l) {
        try {
            Primitive primitive = Primitive.newInstance(0);
            TypeFormat.format(l, (Appendable)primitive);
            return primitive;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public static Text valueOf(long l, int n) {
        try {
            Primitive primitive = Primitive.newInstance(0);
            TypeFormat.format(l, n, (Appendable)primitive);
            return primitive;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public static Text valueOf(float f) {
        try {
            Primitive primitive = Primitive.newInstance(0);
            TypeFormat.format(f, (Appendable)primitive);
            return primitive;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public static Text valueOf(double d) {
        try {
            Primitive primitive = Primitive.newInstance(0);
            TypeFormat.format(d, (Appendable)primitive);
            return primitive;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public static Text valueOf(double d, int n, boolean bl, boolean bl2) {
        try {
            Primitive primitive = Primitive.newInstance(0);
            TypeFormat.format(d, n, bl, bl2, primitive);
            return primitive;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final int length() {
        return this._count;
    }

    public final Text plus(Object object) {
        return this.concat(Text.valueOf(object));
    }

    public final Text concat(Text text) {
        if (this._count == 0) {
            return text;
        }
        if (text._count == 0) {
            return this;
        }
        if (text._count << 1 < this._count && this instanceof Composite) {
            Composite composite = (Composite)this;
            if (((Composite)composite)._head._count > ((Composite)composite)._tail._count) {
                return Composite.newInstance(composite._head, composite._tail.concat(text));
            }
            return Composite.newInstance(this, text);
        }
        if (this._count << 1 < text._count && text instanceof Composite) {
            Composite composite = (Composite)text;
            if (((Composite)composite)._head._count < ((Composite)composite)._tail._count) {
                return Composite.newInstance(this.concat(composite._head), composite._tail);
            }
            return Composite.newInstance(this, text);
        }
        return Composite.newInstance(this, text);
    }

    public final Text subtext(int n) {
        return this.subtext(n, this.length());
    }

    public final Text insert(int n, Text text) {
        return n << 1 < this._count ? this.subtext(0, n).concat(text).concat(this.subtext(n)) : this.subtext(0, n).concat(text.concat(this.subtext(n)));
    }

    public final Text delete(int n, int n2) {
        return this.subtext(0, n).concat(this.subtext(n2));
    }

    public final Text replace(CharSequence charSequence, CharSequence charSequence2) {
        int n = this.indexOf(charSequence);
        return n < 0 ? this : this.subtext(0, n).concat(Text.valueOf(charSequence2)).concat(this.subtext(n + charSequence.length()).replace(charSequence, charSequence2));
    }

    public final Text replace(CharSet charSet, CharSequence charSequence) {
        int n = this.indexOfAny(charSet);
        return n < 0 ? this : this.subtext(0, n).concat(Text.valueOf(charSequence)).concat(this.subtext(n + 1).replace(charSet, charSequence));
    }

    public final CharSequence subSequence(int n, int n2) {
        return this.subtext(n, n2);
    }

    public final int indexOf(CharSequence charSequence) {
        return this.indexOf(charSequence, 0);
    }

    public final int indexOf(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = Math.max(0, n);
        int n4 = this._count - n2;
        if (n2 == 0) {
            return n3 > n4 ? -1 : n3;
        }
        char c = charSequence.charAt(0);
        int n5 = this.indexOf(c, n3);
        while (n5 >= 0 && n5 <= n4) {
            boolean bl = true;
            for (int i = 1; i < n2; ++i) {
                if (this.charAt(n5 + i) == charSequence.charAt(i)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return n5;
            }
            ++n5;
            n5 = this.indexOf(c, n5);
        }
        return -1;
    }

    public final int lastIndexOf(CharSequence charSequence) {
        return this.lastIndexOf(charSequence, this._count);
    }

    public final int lastIndexOf(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = Math.min(n, this._count - n2);
        if (n2 == 0) {
            return 0 > n3 ? -1 : n3;
        }
        char c = charSequence.charAt(0);
        int n4 = this.lastIndexOf(c, n3);
        while (n4 >= 0) {
            boolean bl = true;
            for (int i = 1; i < n2; ++i) {
                if (this.charAt(n4 + i) == charSequence.charAt(i)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return n4;
            }
            --n4;
            n4 = this.lastIndexOf(c, n4);
        }
        return -1;
    }

    public final boolean startsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, 0);
    }

    public final boolean endsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, this.length() - charSequence.length());
    }

    public final boolean startsWith(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        if (n >= 0 && n <= this.length() - n2) {
            int n3 = 0;
            int n4 = n;
            while (n3 < n2) {
                if (charSequence.charAt(n3++) == this.charAt(n4++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final Text trim() {
        int n;
        int n2 = this.length() - 1;
        for (n = 0; n <= n2 && this.charAt(n) <= ' '; ++n) {
        }
        while (n2 >= n && this.charAt(n2) <= ' ') {
            --n2;
        }
        return this.subtext(n, n2 + 1);
    }

    public static Text intern(CharSequence charSequence) {
        Text text = (Text)INTERN_INSTANCES.get(charSequence);
        if (text != null) {
            return text;
        }
        return Text.intern(((Object)charSequence).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Text intern(String string) {
        Text text = (Text)INTERN_INSTANCES.get(string);
        if (text != null) {
            return text;
        }
        FastMap fastMap = INTERN_INSTANCES;
        synchronized (fastMap) {
            text = (Text)INTERN_INSTANCES.get(string);
            if (text != null) {
                return text;
            }
            _tmpString = string;
            MemoryArea.getMemoryArea(INTERN_INSTANCES).executeInArea(INTERN_STRING);
        }
        return (Text)INTERN_INSTANCES.get(string);
    }

    public final boolean contentEquals(CharSequence charSequence) {
        if (charSequence.length() != this._count) {
            return false;
        }
        int n = 0;
        while (n < this._count) {
            if (this.charAt(n) == charSequence.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    public final boolean contentEqualsIgnoreCase(CharSequence charSequence) {
        if (this._count != charSequence.length()) {
            return false;
        }
        int n = 0;
        while (n < this._count) {
            char c;
            char c2 = this.charAt(n);
            if (c2 == (c = charSequence.charAt(n++)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Text)) {
            return false;
        }
        Text text = (Text)object;
        if (this._count != text._count) {
            return false;
        }
        int n = 0;
        while (n < this._count) {
            if (this.charAt(n) == text.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        int n = this._hashCode;
        int n2 = this.length();
        int n3 = 0;
        while (n3 < n2) {
            n = 31 * n + this.charAt(n3++);
        }
        this._hashCode = n;
        return this._hashCode;
    }

    public final int compareTo(Object object) {
        return FastComparator.LEXICAL.compare(this, object);
    }

    public final Text toText() {
        return this;
    }

    public final Text copy() {
        return Text.valueOf(this, 0, this._count);
    }

    public abstract int depth();

    public abstract char charAt(int var1);

    public abstract int indexOf(char var1, int var2);

    public abstract int lastIndexOf(char var1, int var2);

    public abstract Text subtext(int var1, int var2);

    public abstract void getChars(int var1, int var2, char[] var3, int var4);

    public abstract Text toLowerCase();

    public abstract Text toUpperCase();

    public abstract String stringValue();

    public static Text valueOf(char c, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= 32) {
            Primitive primitive = Primitive.newInstance(n);
            int n2 = 0;
            while (n2 < n) {
                ((Primitive)primitive)._data[n2++] = c;
            }
            return primitive;
        }
        int n3 = n >> 1;
        return Composite.newInstance(Text.valueOf(c, n3), Text.valueOf(c, n - n3));
    }

    public final boolean isBlank() {
        return this.isBlank(0, this.length());
    }

    public final boolean isBlank(int n, int n2) {
        while (n < n2) {
            if (this.charAt(n) > ' ') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final Text trimStart() {
        int n;
        int n2 = this.length() - 1;
        for (n = 0; n <= n2 && this.charAt(n) <= ' '; ++n) {
        }
        return this.subtext(n, n2 + 1);
    }

    public final Text trimEnd() {
        int n;
        int n2 = 0;
        for (n = this.length() - 1; n >= n2 && this.charAt(n) <= ' '; --n) {
        }
        return this.subtext(n2, n + 1);
    }

    public final Text padLeft(int n) {
        return this.padLeft(n, ' ');
    }

    public final Text padLeft(int n, char c) {
        int n2 = n <= this.length() ? 0 : n - this.length();
        return this.insert(0, Text.valueOf(c, n2));
    }

    public final Text padRight(int n) {
        return this.padRight(n, ' ');
    }

    public final Text padRight(int n, char c) {
        int n2 = n <= this.length() ? 0 : n - this.length();
        return this.concat(Text.valueOf(c, n2));
    }

    public final int indexOfAny(CharSet charSet) {
        return this.indexOfAny(charSet, 0, this.length());
    }

    public final int indexOfAny(CharSet charSet, int n) {
        return this.indexOfAny(charSet, n, this.length() - n);
    }

    public final int indexOfAny(CharSet charSet, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (!charSet.contains(this.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOfAny(CharSet charSet) {
        return this.lastIndexOfAny(charSet, 0, this.length());
    }

    public final int lastIndexOfAny(CharSet charSet, int n) {
        return this.lastIndexOfAny(charSet, n, this.length() - n);
    }

    public final int lastIndexOfAny(CharSet charSet, int n, int n2) {
        int n3 = n + n2;
        while (--n3 >= n) {
            if (!charSet.contains(this.charAt(n3))) continue;
            return n3;
        }
        return -1;
    }

    static {
        INTERN_STRING = new Runnable(){

            public void run() {
                StringWrapper stringWrapper = new StringWrapper();
                stringWrapper._count = _tmpString.length();
                stringWrapper._string = _tmpString;
                INTERN_INSTANCES.put(_tmpString, stringWrapper);
            }
        };
        EMPTY = Text.intern("");
        NULL = Text.intern("null");
        XML = new XMLFormat(Javolution.j2meGetClass("javolution.text.Text")){

            public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
                CharArray charArray = inputElement.getAttribute("value");
                return charArray != null ? Text.valueOf(charArray) : EMPTY;
            }

            public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            }

            public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
                outputElement.setAttribute("value", (Text)object);
            }
        };
        TRUE = Text.intern("true");
        FALSE = Text.intern("false");
        ASCII = new Text[128];
    }

    private static final class StringWrapper
    extends Text {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new StringWrapper();
            }
        };
        private String _string;
        private int _offset;

        private StringWrapper() {
        }

        private static StringWrapper newInstance(String string) {
            StringWrapper stringWrapper = (StringWrapper)FACTORY.object();
            stringWrapper._count = string.length();
            stringWrapper._hashCode = 0;
            stringWrapper._string = string;
            stringWrapper._offset = 0;
            return stringWrapper;
        }

        public int depth() {
            return 0;
        }

        public char charAt(int n) {
            if (n >= this._count || n < 0) {
                throw new IndexOutOfBoundsException();
            }
            return this._string.charAt(this._offset + n);
        }

        public int indexOf(char c, int n) {
            for (int i = Math.max(n, 0); i < this._count; ++i) {
                if (this._string.charAt(this._offset + i) != c) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(char c, int n) {
            for (int i = Math.min(n, this._count - 1); i >= 0; --i) {
                if (this._string.charAt(this._offset + i) != c) continue;
                return i;
            }
            return -1;
        }

        public Text subtext(int n, int n2) {
            if (n == 0 && n2 == this._count) {
                return this;
            }
            if (n < 0 || n > n2 || n2 > this._count) {
                throw new IndexOutOfBoundsException();
            }
            if (n == n2) {
                return EMPTY;
            }
            StringWrapper stringWrapper = (StringWrapper)FACTORY.object();
            stringWrapper._count = n2 - n;
            stringWrapper._hashCode = 0;
            stringWrapper._string = this._string;
            stringWrapper._offset = this._offset + n;
            return stringWrapper;
        }

        public void getChars(int n, int n2, char[] cArray, int n3) {
            if (n2 > this._count || n2 < n || n < 0) {
                throw new IndexOutOfBoundsException();
            }
            this._string.getChars(n + this._offset, n2 + this._offset, cArray, n3);
        }

        public Text toLowerCase() {
            return this.copy().toLowerCase();
        }

        public Text toUpperCase() {
            return this.copy().toUpperCase();
        }

        public String stringValue() {
            if (this._offset == 0 && this._count == this._string.length()) {
                return this._string;
            }
            return this._string.substring(this._offset, this._offset + this._count);
        }
    }

    private static final class Composite
    extends Text {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new Composite();
            }
        };
        private Text _head;
        private Text _tail;

        private Composite() {
        }

        private static Composite newInstance(Text text, Text text2) {
            Composite composite = (Composite)FACTORY.object();
            composite._hashCode = 0;
            composite._count = text._count + text2._count;
            composite._head = text;
            composite._tail = text2;
            return composite;
        }

        public int depth() {
            return Math.max(this._head.depth(), this._tail.depth()) + 1;
        }

        public char charAt(int n) {
            return n < this._head._count ? this._head.charAt(n) : this._tail.charAt(n - this._head._count);
        }

        public int indexOf(char c, int n) {
            int n2;
            int n3 = this._head._count;
            if (n < n3 && (n2 = this._head.indexOf(c, n)) >= 0) {
                return n2;
            }
            n2 = this._tail.indexOf(c, n - n3);
            return n2 >= 0 ? n2 + n3 : -1;
        }

        public int lastIndexOf(char c, int n) {
            int n2;
            int n3 = this._head._count;
            if (n >= n3 && (n2 = this._tail.lastIndexOf(c, n - n3)) >= 0) {
                return n2 + n3;
            }
            return this._head.lastIndexOf(c, n);
        }

        public Text subtext(int n, int n2) {
            int n3 = this._head._count;
            if (n2 <= n3) {
                return this._head.subtext(n, n2);
            }
            if (n >= n3) {
                return this._tail.subtext(n - n3, n2 - n3);
            }
            if (n == 0 && n2 == this._count) {
                return this;
            }
            return this._head.subtext(n, n3).concat(this._tail.subtext(0, n2 - n3));
        }

        public void getChars(int n, int n2, char[] cArray, int n3) {
            int n4 = this._head._count;
            if (n2 <= n4) {
                this._head.getChars(n, n2, cArray, n3);
            } else if (n >= n4) {
                this._tail.getChars(n - n4, n2 - n4, cArray, n3);
            } else {
                this._head.getChars(n, n4, cArray, n3);
                this._tail.getChars(0, n2 - n4, cArray, n3 + n4 - n);
            }
        }

        public Text toLowerCase() {
            return Composite.newInstance(this._head.toLowerCase(), this._tail.toLowerCase());
        }

        public Text toUpperCase() {
            return Composite.newInstance(this._head.toUpperCase(), this._tail.toUpperCase());
        }

        public String stringValue() {
            char[] cArray = new char[this._count];
            this.getChars(0, this._count, cArray, 0);
            return new String(cArray, 0, this._count);
        }

        public boolean move(Realtime.ObjectSpace objectSpace) {
            if (super.move(objectSpace)) {
                this._head.move(objectSpace);
                this._tail.move(objectSpace);
                return true;
            }
            return false;
        }
    }

    private static final class Primitive
    extends Text
    implements Appendable {
        private static final int BLOCK_SIZE = 32;
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new Primitive();
            }
        };
        private final char[] _data = new char[32];

        private Primitive() {
        }

        private static Primitive newInstance(int n) {
            Primitive primitive = (Primitive)FACTORY.object();
            primitive._count = n;
            primitive._hashCode = 0;
            return primitive;
        }

        public int depth() {
            return 0;
        }

        public char charAt(int n) {
            if (n >= this._count) {
                throw new IndexOutOfBoundsException();
            }
            return this._data[n];
        }

        public int indexOf(char c, int n) {
            for (int i = Math.max(n, 0); i < this._count; ++i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(char c, int n) {
            for (int i = Math.min(n, this._count - 1); i >= 0; --i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }

        public Text subtext(int n, int n2) {
            if (n == 0 && n2 == this._count) {
                return this;
            }
            if (n < 0 || n > n2 || n2 > this._count) {
                throw new IndexOutOfBoundsException();
            }
            if (n == n2) {
                return EMPTY;
            }
            Primitive primitive = Primitive.newInstance(n2 - n);
            int n3 = n;
            int n4 = 0;
            while (n3 < n2) {
                primitive._data[n4++] = this._data[n3++];
            }
            return primitive;
        }

        public void getChars(int n, int n2, char[] cArray, int n3) {
            if (n2 > this._count || n2 < n) {
                throw new IndexOutOfBoundsException();
            }
            int n4 = n;
            int n5 = n3;
            while (n4 < n2) {
                cArray[n5++] = this._data[n4++];
            }
        }

        public Text toLowerCase() {
            Primitive primitive = Primitive.newInstance(this._count);
            int n = 0;
            while (n < this._count) {
                primitive._data[n] = Character.toLowerCase(this._data[n++]);
            }
            return primitive;
        }

        public Text toUpperCase() {
            Primitive primitive = Primitive.newInstance(this._count);
            int n = 0;
            while (n < this._count) {
                primitive._data[n] = Character.toUpperCase(this._data[n++]);
            }
            return primitive;
        }

        public String stringValue() {
            return new String(this._data, 0, this._count);
        }

        public Appendable append(char c) throws IOException {
            this._data[this._count++] = c;
            return this;
        }

        public Appendable append(CharSequence charSequence) throws IOException {
            return this.append(charSequence, 0, charSequence.length());
        }

        public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
            int n3 = n;
            while (n3 < n2) {
                this._data[this._count++] = charSequence.charAt(n3++);
            }
            return this;
        }
    }
}

