/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.sqlobject.SQLCheckConstraint;
import ca.sqlpower.sqlobject.SQLCheckConstraintContainer;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import javax.annotation.Nonnull;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class CheckConstraintTableModelListener
implements TableModelListener {
    private final SQLCheckConstraintContainer container;
    private final UserDefinedSQLType udt;
    private final String platform;
    private boolean removalAfterInsert = false;

    public CheckConstraintTableModelListener(@Nonnull SQLCheckConstraintContainer container) {
        this.container = container;
        this.udt = null;
        this.platform = null;
    }

    public CheckConstraintTableModelListener(@Nonnull UserDefinedSQLType udt, @Nonnull String platform) {
        this.udt = udt;
        this.platform = platform;
        this.container = null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        DefaultTableModel model = (DefaultTableModel)e.getSource();
        int row = e.getFirstRow();
        switch (e.getType()) {
            case 1: {
                String name = (String)model.getValueAt(row, 0);
                String constraint = (String)model.getValueAt(row, 1);
                int firstIndex = ASUtils.findFirstRow(model, 0, name);
                int lastIndex = ASUtils.findLastRow(model, 0, name);
                if (name.trim().equals("") || constraint.trim().equals("") || firstIndex != -1 && firstIndex != lastIndex) {
                    this.removalAfterInsert = true;
                    model.removeRow(row);
                    this.removalAfterInsert = false;
                    break;
                }
                SQLCheckConstraint checkConstraint = new SQLCheckConstraint(name, constraint);
                if (this.udt == null) {
                    this.container.addCheckConstraint(checkConstraint, row);
                    break;
                }
                this.udt.addCheckConstraint(this.platform, checkConstraint, row);
                break;
            }
            case -1: {
                if (this.removalAfterInsert) break;
                if (this.udt == null) {
                    SQLCheckConstraint checkConstraint = (SQLCheckConstraint)this.container.getCheckConstraints().get(row);
                    this.container.removeCheckConstraint(checkConstraint);
                    break;
                }
                SQLCheckConstraint checkConstraint = (SQLCheckConstraint)this.udt.getCheckConstraints(this.platform).get(row);
                this.udt.removeCheckConstraint(this.platform, checkConstraint);
                break;
            }
            case 0: {
                int column = e.getColumn();
                String newName = (String)model.getValueAt(row, 0);
                String newConstraint = (String)model.getValueAt(row, 1);
                SQLCheckConstraint checkConstraint = this.udt == null ? (SQLCheckConstraint)this.container.getCheckConstraints().get(row) : (SQLCheckConstraint)this.udt.getCheckConstraints(this.platform).get(row);
                if (column != 1) {
                    if (newName.trim().equals("")) {
                        model.setValueAt(checkConstraint.getName(), row, 0);
                    } else {
                        int lastIndex;
                        int firstIndex = ASUtils.findFirstRow(model, 0, newName);
                        if (firstIndex == (lastIndex = ASUtils.findLastRow(model, 0, newName))) {
                            checkConstraint.setName(newName);
                        } else {
                            model.setValueAt(checkConstraint.getName(), row, 0);
                        }
                    }
                }
                if (column == 0) break;
                if (newConstraint.trim().equals("")) {
                    model.setValueAt(checkConstraint.getConstraint(), row, 1);
                    break;
                }
                checkConstraint.setConstraint(newConstraint);
            }
        }
    }

    public SQLCheckConstraintContainer getContainer() {
        return this.container;
    }

    public String getPlatform() {
        return this.platform;
    }
}

