/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectVersion;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContextImpl;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.DuplicateProperties;
import ca.sqlpower.architect.swingui.ImportSafetyChecker;
import ca.sqlpower.architect.swingui.KettleDataSourceOptionsPanel;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.QFAUserSettings;
import ca.sqlpower.architect.swingui.TabbedDataEntryPanel;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.JDBCDataSourcePanel;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.ExceptionReport;
import ca.sqlpower.util.SQLPowerUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class ASUtils {
    private static final Logger logger = Logger.getLogger(ASUtils.class);
    private static ArchitectSwingSessionContext context;
    private Thread focusDebuggerThread = null;
    private boolean focusDebuggerStopping = true;
    private Runnable showFocusOwnerTask = new Runnable(){

        @Override
        public void run() {
            while (!ASUtils.this.focusDebuggerStopping) {
                logger.debug((Object)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)"Interrupted in sleep");
                }
            }
            ASUtils.this.focusDebuggerThread = null;
        }
    };

    private ASUtils() {
    }

    public static double distance(Point p1, Point p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public void stopFocusDebugger() {
        this.focusDebuggerStopping = true;
    }

    public void startFocusDebugger() {
        this.focusDebuggerThread = new Thread(this.showFocusOwnerTask);
        this.focusDebuggerStopping = false;
        this.focusDebuggerThread.start();
    }

    public static void setupTargetDBComboBox(final ArchitectSwingSession session, final JComboBox targetDB) {
        JComboBox<JDBCDataSource> newTargetDB = new JComboBox<JDBCDataSource>();
        JDBCDataSource currentTarget = session.getTargetDatabase().getDataSource();
        newTargetDB.addItem(currentTarget);
        for (JDBCDataSource dbcs : session.getDataSources().getConnections()) {
            if (dbcs.equals((Object)currentTarget)) continue;
            newTargetDB.addItem(dbcs);
        }
        newTargetDB.setSelectedIndex(0);
        targetDB.setModel(newTargetDB.getModel());
        targetDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDBCDataSource comboBoxDS;
                JDBCDataSource projectDS = session.getTargetDatabase().getDataSource();
                if (!projectDS.equals((Object)(comboBoxDS = (JDBCDataSource)((JComboBox)e.getSource()).getSelectedItem()))) {
                    projectDS.copyFrom(comboBoxDS);
                }
                ASUtils.setupTargetDBComboBox(session, targetDB);
            }
        });
    }

    public static void showTargetDbcsDialog(Window parentWindow, final ArchitectSwingSession session, final JComboBox targetDB) {
        JDialog d = ASUtils.showDbcsDialog(parentWindow, session.getTargetDatabase().getDataSource(), null, false);
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                session.getTargetDatabase().getDataSource().setName(Messages.getString("ASUtils.targetDatabase"));
                ASUtils.setupTargetDBComboBox(session, targetDB);
            }
        });
    }

    public static JDialog showDbcsDialog(Window parentWindow, JDBCDataSource dataSource, Runnable onAccept) {
        return ASUtils.showDbcsDialog(parentWindow, dataSource, onAccept, true);
    }

    public static JDialog showDbcsDialog(Window parentWindow, JDBCDataSource dataSource, final Runnable onAccept, boolean enforceUniqueName) {
        final DataEntryPanel dbcsPanel = ASUtils.createDataSourceOptionsPanel(dataSource, enforceUniqueName);
        Callable<Boolean> okCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (dbcsPanel.applyChanges()) {
                    if (onAccept != null) {
                        onAccept.run();
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        Callable<Boolean> cancelCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                dbcsPanel.discardChanges();
                return Boolean.TRUE;
            }
        };
        JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)dbcsPanel, (Component)parentWindow, (String)Messages.getString("ASUtils.databaseConnectionDialogTitle", dataSource.getDisplayName()), (String)DataEntryPanelBuilder.OK_BUTTON_LABEL, (Callable)okCall, (Callable)cancelCall);
        d.pack();
        d.setLocationRelativeTo(parentWindow);
        d.setVisible(true);
        return d;
    }

    public static DataEntryPanel createDataSourceOptionsPanel(JDBCDataSource ds, boolean enforceUniqueName) {
        JDBCDataSourcePanel generalPanel = new JDBCDataSourcePanel(ds);
        generalPanel.setEnforcingUniqueName(enforceUniqueName);
        final KettleDataSourceOptionsPanel kettlePanel = new KettleDataSourceOptionsPanel(ds);
        TabbedDataEntryPanel p = new TabbedDataEntryPanel();
        p.addTab(Messages.getString("ASUtils.datasourceOptionsGeneralTab"), (DataEntryPanel)generalPanel);
        p.addTab(Messages.getString("ASUtils.datasourceOptionsKettleTab"), kettlePanel);
        generalPanel.getDataSourceTypeBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                JDBCDataSourceType parentType = (JDBCDataSourceType)cb.getSelectedItem();
                kettlePanel.parentTypeChanged(parentType);
            }
        });
        return p;
    }

    public static String lineToString(Line2D.Double l) {
        return "[(" + l.x1 + "," + l.y1 + ") - (" + l.x2 + "," + l.y2 + ")]";
    }

    public static List<Point2D.Double> getIntersectPoints(Shape s1, Shape s2) {
        ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>();
        PathIterator myPI = s1.getPathIterator(null);
        Line2D.Double myLine = new Line2D.Double();
        float[] myCoords = new float[6];
        while (!myPI.isDone()) {
            int mySegType = myPI.currentSegment(myCoords);
            if (mySegType == 1) {
                myLine.x1 = myLine.x2;
                myLine.y1 = myLine.y2;
                myLine.x2 = myCoords[0];
                myLine.y2 = myCoords[1];
            } else if (mySegType == 0 || mySegType == 4) {
                myLine.x1 = myCoords[0];
                myLine.y1 = myCoords[1];
                myLine.x2 = myCoords[0];
                myLine.y2 = myCoords[1];
            } else {
                throw new IllegalStateException("Unsupported my PathIterator type " + mySegType + ". Current myLine is " + ASUtils.lineToString(myLine));
            }
            myPI.next();
            if (myLine.x1 == myLine.x2 && myLine.y1 == myLine.y2) continue;
            PathIterator otherPI = s2.getPathIterator(null);
            Line2D.Double otherLine = new Line2D.Double();
            float[] otherCoords = new float[6];
            while (!otherPI.isDone()) {
                Point2D.Double point;
                int otherSegType = otherPI.currentSegment(otherCoords);
                if (otherSegType == 1) {
                    otherLine.x1 = otherLine.x2;
                    otherLine.y1 = otherLine.y2;
                    otherLine.x2 = otherCoords[0];
                    otherLine.y2 = otherCoords[1];
                } else if (otherSegType == 0 || otherSegType == 4) {
                    otherLine.x1 = otherCoords[0];
                    otherLine.y1 = otherCoords[1];
                    otherLine.x2 = otherCoords[0];
                    otherLine.y2 = otherCoords[1];
                } else {
                    throw new IllegalStateException("Unsupported other PathIterator type " + otherSegType + ". Current otherLine is " + ASUtils.lineToString(otherLine));
                }
                otherPI.next();
                if (otherLine.x1 == otherLine.x2 && otherLine.y1 == otherLine.y2 || !ASUtils.getLineLineIntersection(myLine, otherLine, point = new Point2D.Double())) continue;
                list.add(point);
            }
        }
        return list;
    }

    public static boolean getLineLineIntersection(Line2D.Double l1, Line2D.Double l2, Point2D.Double intersection) {
        if (!l1.intersectsLine(l2)) {
            return false;
        }
        double x1 = l1.getX1();
        double y1 = l1.getY1();
        double x2 = l1.getX2();
        double y2 = l1.getY2();
        double x3 = l2.getX1();
        double y3 = l2.getY1();
        double x4 = l2.getX2();
        double y4 = l2.getY2();
        intersection.x = ASUtils.det(ASUtils.det(x1, y1, x2, y2), x1 - x2, ASUtils.det(x3, y3, x4, y4), x3 - x4) / ASUtils.det(x1 - x2, y1 - y2, x3 - x4, y3 - y4);
        intersection.y = ASUtils.det(ASUtils.det(x1, y1, x2, y2), y1 - y2, ASUtils.det(x3, y3, x4, y4), y3 - y4) / ASUtils.det(x1 - x2, y1 - y2, x3 - x4, y3 - y4);
        return true;
    }

    static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    public static Image getFrameIconImage() {
        return SPSUtils.createIcon((String)"Architect", (String)"Architect Logo", (int)16).getImage();
    }

    public static ArchitectSwingSessionContext getContext() {
        if (context == null) {
            try {
                context = new ArchitectSwingSessionContextImpl();
                context.setExitAfterAllSessionsClosed(true);
            }
            catch (Exception e) {
                ASUtils.showExceptionDialogNoReport(Messages.getString("ASUtils.couldNotLaunchPowerArchitect"), e);
                System.exit(1);
            }
        }
        return context;
    }

    public static void showExceptionDialogNoReport(String message, Throwable t) {
        JFrame f = new JFrame();
        f.setIconImage(ASUtils.getFrameIconImage());
        SPSUtils.showExceptionDialogNoReport((Component)f, (String)message, (Throwable)t);
    }

    public static void showExceptionDialogNoReport(Component parent, String message, Throwable t) {
        SPSUtils.showExceptionDialogNoReport((Component)parent, (String)message, (Throwable)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showExceptionDialog(ArchitectSwingSession session, String message, Throwable t) {
        try {
            QFAUserSettings settings = context.getUserSettings().getQfaUserSettings();
            if (!settings.getBoolean("QFAUserSettings.EXCEPTION_REPORTING", true)) {
                return;
            }
            ExceptionReport report = new ExceptionReport(t, "http://bugs.sqlpower.ca/architect/postReport", ArchitectVersion.APP_FULL_VERSION.toString(), "Architect");
            if (session != null && session.getProjectLoader() != null && session.getPlayPen() != null && session.getDBTree() != null) {
                PlayPen pp = session.getPlayPen();
                report.addAdditionalInfo("Number of objects in the play pen", "" + pp.getPPComponentCount());
                report.addAdditionalInfo("Number of source connections", "" + session.getDBTree().getDatabaseList().size());
                logger.debug((Object)report.toString());
                report.send();
            }
        }
        catch (Throwable seriousProblem) {
            logger.error((Object)"Couldn't generate and send exception report!  Note that this is not the primary problem; it's a side effect of trying to report the real problem.", seriousProblem);
            JOptionPane.showMessageDialog(null, "Error reporting failed: " + seriousProblem.getMessage() + "\nAdditional information is available in the application log.");
        }
        finally {
            ArchitectFrame owner = null;
            if (session != null) {
                owner = session.getArchitectFrame();
            } else {
                logger.error((Object)"got a null session in showExceptionDialog()");
            }
            SPSUtils.showExceptionDialogNoReport((Component)owner, (String)message, (Throwable)t);
        }
    }

    public static DuplicateProperties createDuplicateProperties(ArchitectSwingSession currentSession, SQLObject source) {
        ArchitectSwingSession containingSession = null;
        List ancestorList = SQLObjectUtils.ancestorList((SQLObject)source);
        ArrayList<ArchitectSwingSession> containingSessions = new ArrayList<ArchitectSwingSession>();
        for (ArchitectSession s : currentSession.getContext().getSessions()) {
            ArchitectSwingSession session = (ArchitectSwingSession)s;
            SQLObjectRoot root = session.getRootObject();
            if (!ancestorList.contains(root)) continue;
            containingSessions.add(session);
        }
        if (containingSessions.size() == 1) {
            containingSession = (ArchitectSwingSession)containingSessions.get(0);
        } else if (containingSessions.size() > 1) {
            for (ArchitectSwingSession session : containingSessions) {
                if (session.getWorkspace().getUUID().equals(currentSession.getWorkspace().getUUID())) continue;
                throw new IllegalStateException("The object " + source + " exists in both " + (Object)((Object)currentSession.getWorkspace()) + " and " + (Object)((Object)session.getWorkspace()) + " by UUID equality.");
            }
            containingSession = currentSession;
        }
        if (containingSession == null) {
            return new DuplicateProperties(false, SQLTable.TransferStyles.COPY, false, false, true);
        }
        if (containingSession != currentSession) {
            ImportSafetyChecker checker = new ImportSafetyChecker(currentSession);
            boolean preserveColumnSource = checker.visit(source);
            return new DuplicateProperties(true, SQLTable.TransferStyles.COPY, false, preserveColumnSource, true);
        }
        if (!ancestorList.contains(currentSession.getTargetDatabase())) {
            return new DuplicateProperties(true, SQLTable.TransferStyles.REVERSE_ENGINEER, false, true, false);
        }
        return new DuplicateProperties(false, SQLTable.TransferStyles.COPY, true, true, true);
    }

    public static void correctSourceColumn(SQLColumn source, DuplicateProperties duplicateProperties, SQLColumn column, DBTree dbTree) throws SQLObjectException {
        SQLColumn sourceColumn;
        if (!duplicateProperties.isPreserveColumnSource()) {
            return;
        }
        if (duplicateProperties.getDefaultTransferStyle() == SQLTable.TransferStyles.REVERSE_ENGINEER) {
            sourceColumn = source;
        } else if (duplicateProperties.getDefaultTransferStyle() == SQLTable.TransferStyles.COPY) {
            if (source.getSourceColumn() == null) {
                source.setSourceColumn(source);
            }
            sourceColumn = source.getSourceColumn();
        } else {
            sourceColumn = null;
        }
        ASUtils.correctSourceColumn(column, sourceColumn, dbTree);
    }

    private static void correctSourceColumn(SQLColumn column, SQLColumn sourceColumn, DBTree dbTree) throws SQLObjectException {
        logger.debug((Object)("New column " + column.getName() + " has source " + column.getSourceColumn()));
        if (sourceColumn != null && !SQLObjectUtils.isInSameSession((SQLObject)column, (SQLObject)sourceColumn)) {
            SQLDatabase sourceSourceDatabase = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)sourceColumn, SQLDatabase.class);
            JDBCDataSource targetSourceSPDataSource = dbTree.getDuplicateDbcs((SPDataSource)sourceSourceDatabase.getDataSource());
            if (targetSourceSPDataSource == null) {
                throw new IllegalStateException("Cannot find target data source " + sourceSourceDatabase + " in the target session but was available in the source.");
            }
            if (!dbTree.dbcsAlreadyExists((SPDataSource)targetSourceSPDataSource)) {
                dbTree.addSourceConnection((SPDataSource)sourceSourceDatabase.getDataSource());
            }
            SQLDatabase targetSourceDatabase = dbTree.getDatabase((SPDataSource)targetSourceSPDataSource);
            List ancestors = SQLObjectUtils.ancestorList((SQLObject)sourceColumn);
            System.out.println(ancestors);
            SQLDatabase child = targetSourceDatabase;
            int waits = 0;
            while (child.getChildren().size() == 0) {
                try {
                    Thread.sleep(50L);
                    if (++waits <= 100) continue;
                    throw new RuntimeException("Waiting too long for database to be populated.");
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            for (int i = 2; i < ancestors.size(); ++i) {
                SQLObject ancestor = (SQLObject)ancestors.get(i);
                System.out.println("Child " + child + " ancestor " + ancestor);
                child = child.getChildByName(ancestor.getName(), ancestor.getClass());
            }
            column.setSourceColumn((SQLColumn)child);
        }
    }

    public static int findFirstRow(TableModel model, int col, String value) {
        String trimmedValue = value.trim();
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!((String)model.getValueAt(i, col)).trim().equals(trimmedValue)) continue;
            return i;
        }
        return -1;
    }

    public static int findLastRow(TableModel model, int col, String value) {
        String trimmedValue = value.trim();
        for (int i = model.getRowCount() - 1; i >= 0; --i) {
            if (!((String)model.getValueAt(i, 0)).trim().equals(trimmedValue)) continue;
            return i;
        }
        return -1;
    }
}

