/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticManager;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CriticGrouping
extends AbstractSPObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(CriticAndSettings.class);
    private final List<CriticAndSettings> settings = new ArrayList<CriticAndSettings>();
    private boolean enabled = true;
    private final String platformType;

    @Constructor
    public CriticGrouping(@ConstructorParameter(propertyName="platformType") String platformType) {
        this.platformType = platformType;
        this.setName("Critic group for platform " + platformType);
    }

    protected void addChildImpl(SPObject child, int index) {
        CriticAndSettings critic;
        if (child instanceof CriticAndSettings) {
            critic = (CriticAndSettings)child;
            if (!this.getPlatformType().equals(critic.getPlatformType())) {
                throw new IllegalArgumentException("The platform type " + critic.getPlatformType() + " does not match this groups type of " + this.getPlatformType());
            }
        } else {
            throw new IllegalStateException("Invalid child type " + child);
        }
        this.settings.add(index, critic);
        critic.setParent((SPObject)this);
        this.fireChildAdded(CriticAndSettings.class, child, index);
    }

    protected boolean removeChildImpl(SPObject child) {
        int index = this.settings.indexOf(child);
        boolean removed = this.settings.remove(child);
        if (removed) {
            this.fireChildRemoved(CriticAndSettings.class, child, index);
            child.setParent(null);
        }
        return removed;
    }

    @Transient
    @Accessor
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @NonProperty
    public List<? extends SPObject> getChildren() {
        return Collections.unmodifiableList(this.settings);
    }

    @NonBound
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
        for (CriticAndSettings setting : this.settings) {
            setting.removeDependency(dependency);
        }
    }

    @Mutator
    public void setEnabled(boolean enabled) {
        boolean oldVal = this.enabled;
        this.enabled = enabled;
        this.firePropertyChange("enabled", oldVal, enabled);
    }

    @Accessor
    public boolean isEnabled() {
        return this.enabled;
    }

    @Accessor
    public String getPlatformType() {
        return this.platformType;
    }

    @NonProperty
    public List<CriticAndSettings> getSettings() {
        return Collections.unmodifiableList(this.settings);
    }

    @Accessor
    public CriticManager getParent() {
        return (CriticManager)super.getParent();
    }

    @Mutator
    public void setParent(SPObject parent) {
        if (parent != null && !(parent instanceof CriticManager)) {
            throw new IllegalArgumentException("Critic groups must be a child of a critic manager.");
        }
        super.setParent(parent);
    }
}

