/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.propertyinput;

import java.io.File;
import java.io.FileInputStream;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.propertyinput.Messages;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputData;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputField;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputMeta;

public class PropertyInput
extends BaseStep
implements StepInterface {
    private PropertyInputMeta meta;
    private PropertyInputData data;

    public PropertyInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block9: {
            if (this.first && !this.meta.isFileField()) {
                int i;
                this.data.files = this.meta.getFiles(this);
                if (this.data.files == null || this.data.files.nrOfFiles() == 0) {
                    throw new KettleException(Messages.getString("PropertyInput.Log.NoFiles"));
                }
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.convertRowMeta = this.data.outputRowMeta.clone();
                for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                    this.data.convertRowMeta.getValueMeta(i).setType(2);
                }
                this.data.convertRowMeta = this.data.outputRowMeta.clone();
                for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                    this.data.convertRowMeta.getValueMeta(i).setType(2);
                }
            }
            Object[] r = null;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                Object[] outputRowData = this.getOneRow();
                if (outputRowData == null) {
                    this.setOutputDone();
                    return false;
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("PropertyInput.ErrorInStepRunning", e.getMessage()));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block9;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "PropertyInput001");
            }
        }
        return true;
    }

    private Object[] getOneRow() throws KettleException {
        try {
            if (this.meta.isFileField()) {
                while (this.data.readrow == null || !this.data.it.hasNext()) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            } else {
                while (this.data.file == null || !this.data.it.hasNext()) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            }
        }
        catch (Exception IO) {
            return null;
        }
        Object[] r = this.buildEmptyRow();
        if (this.meta.isFileField()) {
            r = (Object[])this.data.readrow.clone();
        }
        try {
            RowMetaInterface irow;
            String key = null;
            key = this.data.it.next().toString();
            for (int i = 0; i < this.meta.getInputFields().length; ++i) {
                String value = null;
                value = this.meta.getInputFields()[i].getColumnCode().equals(PropertyInputField.ColumnCode[0]) ? key : this.data.pro.getProperty(key);
                switch (this.meta.getInputFields()[i].getTrimType()) {
                    case 1: {
                        value = Const.ltrim((String)value);
                        break;
                    }
                    case 2: {
                        value = Const.rtrim((String)value);
                        break;
                    }
                    case 3: {
                        value = Const.trim((String)value);
                        break;
                    }
                }
                if (this.meta.isFileField()) {
                    r = RowDataUtil.addValueData((Object[])r, (int)(this.data.totalpreviousfields + i), (Object)value);
                }
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                r[this.data.totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)value);
                if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)value)) continue;
                r[this.data.totalpreviousfields + i] = this.data.previousRow[this.data.totalpreviousfields + i];
            }
            int rowIndex = this.meta.getInputFields().length;
            if (this.meta.includeFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
                r[this.data.totalpreviousfields + rowIndex++] = KettleVFS.getFilename((FileObject)this.data.file);
            }
            if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                r[this.data.totalpreviousfields + rowIndex++] = new Long(this.data.rownr);
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? r : irow.cloneRow(r);
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("PropertyInput.Error.CanNotReadFromFile", this.data.file.toString()), (Throwable)e);
        }
        return r;
    }

    private boolean openNextFile() {
        try {
            if (!this.meta.isFileField()) {
                if (this.data.filenr >= this.data.files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("PropertyInput.Log.FinishedProcessing"));
                    }
                    return false;
                }
                this.data.last_file = this.data.filenr == this.data.files.nrOfFiles() - 1;
                this.data.file = this.data.files.getFile(this.data.filenr);
                ++this.data.filenr;
            } else {
                this.data.readrow = this.getRow();
                if (this.data.readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("PropertyInput.Log.FinishedProcessing"));
                    }
                    return false;
                }
                if (this.first) {
                    int i;
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    if (Const.isEmpty((String)this.meta.getDynamicFilenameField())) {
                        this.logError(Messages.getString("PropertyInput.Log.NoField"));
                        throw new KettleException(Messages.getString("PropertyInput.Log.NoField"));
                    }
                    if (this.data.indexOfFilenameField < 0) {
                        this.data.indexOfFilenameField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicFilenameField());
                        if (this.data.indexOfFilenameField < 0) {
                            this.logError(Messages.getString("PropertyInput.Log.ErrorFindingField") + "[" + this.meta.getDynamicFilenameField() + "]");
                            throw new KettleException(Messages.getString("PropertyInput.Exception.CouldnotFindField", this.meta.getDynamicFilenameField()));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("PropertyInput.Log.FilenameInStream", this.meta.getDynamicFilenameField(), filename), new Object[0]);
                }
                this.data.file = KettleVFS.getFileObject((String)filename);
            }
            if (this.meta.resetRowNumber()) {
                this.data.rownr = 0L;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("PropertyInput.Log.OpeningFile", this.data.file.toString()));
            }
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(Messages.getString("PropertyInput.Log.FileAddedResult"));
                this.addResultFile(resultFile);
            }
            File f = new File(KettleVFS.getFilename((FileObject)this.data.file));
            FileInputStream in = new FileInputStream(f);
            this.data.pro.load(in);
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("PropertyInput.Log.FileOpened", this.data.file.toString()));
                this.logDetailed(Messages.getString("PropertyInput.log.TotalKey", "" + this.data.pro.keySet().size(), KettleVFS.getFilename((FileObject)this.data.file)));
            }
            this.data.it = this.data.pro.keySet().iterator();
        }
        catch (Exception e) {
            this.logError(Messages.getString("PropertyInput.Log.UnableToOpenFile", "" + this.data.filenr, this.data.file.toString(), e.toString()));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PropertyInputMeta)smi;
        this.data = (PropertyInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.rownr = 1L;
            this.data.totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PropertyInputMeta)smi;
        this.data = (PropertyInputData)sdi;
        if (this.data.rw != null) {
            this.data.rw = null;
        }
        if (this.data.readrow != null) {
            this.data.readrow = null;
        }
        if (this.data.file != null) {
            try {
                this.data.file.close();
                this.data.file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

