/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.io.IOException;
import java.net.ServerSocket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.config.ConfigManager;
import org.pentaho.di.core.config.KettleConfig;
import org.pentaho.di.core.exception.KettleConfigException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleStepLoaderException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.trans.SlaveStepCopyPartitionDistribution;
import org.pentaho.di.trans.StepLoader;
import org.pentaho.di.trans.StepPlugin;
import org.pentaho.di.trans.StepPluginMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.cluster.TransSplitter;
import org.pentaho.di.trans.step.Messages;
import org.pentaho.di.trans.step.RemoteStep;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepCategory;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.mapping.Mapping;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.di.www.SocketRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseStep
extends Thread
implements VariableSpace,
StepInterface {
    private VariableSpace variables = new Variables();
    public static StepPluginMeta[] steps = null;
    public static final String[] category_order;
    public static final String[] statusDesc;
    private TransMeta transMeta;
    private StepMeta stepMeta;
    private String stepname;
    protected LogWriter log;
    private Trans trans;
    private Object statusCountersLock = new Object();
    public long linesRead;
    public long linesWritten;
    public long linesInput;
    public long linesOutput;
    public long linesUpdated;
    public long linesSkipped;
    public long linesRejected;
    private boolean distributed;
    private long errors;
    private StepMeta[] nextSteps;
    private StepMeta[] prevSteps;
    private int currentInputRowSetNr;
    private int currentOutputRowSetNr;
    public List<BaseStep> thr;
    public ArrayList<RowSet> inputRowSets;
    public ArrayList<RowSet> outputRowSets;
    public List<RemoteStep> remoteInputSteps;
    public List<RemoteStep> remoteOutputSteps;
    public RowSet errorRowSet;
    public AtomicBoolean stopped;
    public AtomicBoolean paused;
    public boolean waiting;
    public boolean init;
    private int stepcopy;
    private Date start_time;
    private Date stop_time;
    public boolean first;
    public boolean terminator;
    public List<Object[]> terminator_rows;
    private StepMetaInterface stepMetaInterface;
    private StepDataInterface stepDataInterface;
    private List<RowListener> rowListeners;
    private Map<String, ResultFile> resultFiles;
    private boolean safeModeEnabled;
    private RowMetaInterface inputReferenceRow;
    private boolean partitioned;
    private String partitionID;
    private int repartitioning;
    private Map<String, RowSet> partitionTargets;
    private RowMetaInterface inputRowMeta;
    private StepPartitioningMeta nextStepPartitioningMeta;
    private RowMetaInterface errorRowMeta = null;
    private RowMetaInterface previewRowMeta;
    private boolean checkTransRunning;
    private int slaveNr;
    private int clusterSize;
    private int uniqueStepNrAcrossSlaves;
    private int uniqueStepCountAcrossSlaves;
    private boolean remoteOutputStepsInitialized;
    private boolean remoteInputStepsInitialized;
    private RowSet[] partitionNrRowSetList;
    private List<ServerSocket> serverSockets;
    private static int NR_OF_ROWS_IN_BLOCK;
    private int blockPointer;
    private boolean clusteredPartitioningFirst;
    private boolean clusteredPartitioning;
    private boolean usingThreadPriorityManagment;
    private List<StepListener> stepListeners;
    private SocketRepository socketRepository;
    private int upperBufferBoundary;
    private int lowerBufferBoundary;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        this.log = LogWriter.getInstance();
        this.stepMeta = stepMeta;
        this.stepDataInterface = stepDataInterface;
        this.stepcopy = copyNr;
        this.transMeta = transMeta;
        this.trans = trans;
        this.stepname = stepMeta.getName();
        this.socketRepository = trans.getSocketRepository();
        if (stepMeta.getName() == null) {
            throw new RuntimeException("A step in transformation [" + transMeta.toString() + "] doesn't have a name.  A step should always have a name to identify it by.");
        }
        this.setName(this.toString() + " (" + super.getName() + ")");
        this.first = true;
        this.clusteredPartitioningFirst = true;
        this.stopped = new AtomicBoolean(false);
        this.paused = new AtomicBoolean(false);
        this.init = false;
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesRead = 0L;
            this.linesWritten = 0L;
            this.linesUpdated = 0L;
            this.linesSkipped = 0L;
            this.linesRejected = 0L;
            this.linesInput = 0L;
            this.linesOutput = 0L;
        }
        this.inputRowSets = null;
        this.outputRowSets = null;
        this.nextSteps = null;
        this.terminator = stepMeta.hasTerminator();
        this.terminator_rows = this.terminator ? new ArrayList<Object[]>() : null;
        this.start_time = null;
        this.stop_time = null;
        this.distributed = stepMeta.isDistributes();
        if (this.distributed) {
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("BaseStep.Log.DistributionActivated"));
            } else if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("BaseStep.Log.DistributionDeactivated"));
            }
        }
        this.rowListeners = new ArrayList<RowListener>();
        this.resultFiles = new Hashtable<String, ResultFile>();
        this.repartitioning = 0;
        this.partitionTargets = new Hashtable<String, RowSet>();
        this.serverSockets = new ArrayList<ServerSocket>();
        this.checkTransRunning = false;
        this.blockPointer = 0;
        this.stepListeners = new ArrayList<StepListener>();
        this.dispatch();
        this.upperBufferBoundary = (int)((double)transMeta.getSizeRowset() * 0.98);
        this.lowerBufferBoundary = (int)((double)transMeta.getSizeRowset() * 0.02);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        RemoteStep copy;
        int i;
        sdi.setStatus(1);
        String slaveNr = this.transMeta.getVariable("Internal.Slave.Transformation.Number");
        String clusterSize = this.transMeta.getVariable("Internal.Cluster.Size");
        boolean master = "Y".equalsIgnoreCase(this.transMeta.getVariable("Internal.Cluster.Master"));
        if (!(Const.isEmpty((String)slaveNr) || Const.isEmpty((String)clusterSize) || master)) {
            this.slaveNr = Integer.parseInt(slaveNr);
            this.clusterSize = Integer.parseInt(clusterSize);
            if (this.log.isDetailed()) {
                this.logDetailed("Running on slave server #" + slaveNr + "/" + clusterSize + ".");
            }
        } else {
            this.slaveNr = 0;
            this.clusterSize = 0;
        }
        SlaveStepCopyPartitionDistribution partitionDistribution = this.transMeta.getSlaveStepCopyPartitionDistribution();
        if (this.stepMeta.isPartitioned()) {
            if (partitionDistribution != null && !partitionDistribution.getDistribution().isEmpty()) {
                String slaveServerName = this.getVariable("Internal.Slave.Server.Name");
                int stepCopyNr = this.stepcopy;
                PartitionSchema partitionSchema = this.stepMeta.getStepPartitioningMeta().getPartitionSchema();
                int partitionNr = partitionDistribution.getPartition(slaveServerName, partitionSchema.getName(), stepCopyNr);
                if (partitionNr >= 0) {
                    String partitionNrString = new DecimalFormat("000").format(partitionNr);
                    this.setVariable("Internal.Step.Partition.Number", partitionNrString);
                    if (partitionDistribution.getOriginalPartitionSchemas() != null) {
                        String partitionSchemaName = this.stepMeta.getStepPartitioningMeta().getPartitionSchema().getName();
                        for (PartitionSchema originalPartitionSchema : partitionDistribution.getOriginalPartitionSchemas()) {
                            String slavePartitionSchemaName = TransSplitter.createSlavePartitionSchemaName(originalPartitionSchema.getName());
                            if (!slavePartitionSchemaName.equals(partitionSchemaName)) continue;
                            PartitionSchema schema = (PartitionSchema)originalPartitionSchema.clone();
                            if (schema.isDynamicallyDefined()) {
                                schema.expandPartitionsDynamically(this.clusterSize, this);
                            }
                            String partID = schema.getPartitionIDs().get(partitionNr);
                            this.setVariable("Internal.Step.Partition.ID", partID);
                            break;
                        }
                    }
                }
            } else {
                int partitionNr = this.stepcopy;
                String partitionNrString = new DecimalFormat("000").format(partitionNr);
                this.setVariable("Internal.Step.Partition.Number", partitionNrString);
                String partitionID = this.stepMeta.getStepPartitioningMeta().getPartitionSchema().getPartitionIDs().get(partitionNr);
                this.setVariable("Internal.Step.Partition.ID", partitionID);
            }
        } else if (!Const.isEmpty((String)this.partitionID)) {
            this.setVariable("Internal.Step.Partition.ID", this.partitionID);
        }
        this.uniqueStepNrAcrossSlaves = this.slaveNr * this.getStepMeta().getCopies() + this.stepcopy;
        int n = this.uniqueStepCountAcrossSlaves = this.clusterSize <= 1 ? this.getStepMeta().getCopies() : this.clusterSize * this.getStepMeta().getCopies();
        if (this.uniqueStepCountAcrossSlaves == 0) {
            this.uniqueStepCountAcrossSlaves = 1;
        }
        this.setVariable("Internal.Step.Unique.Number", Integer.toString(this.uniqueStepNrAcrossSlaves));
        this.setVariable("Internal.Step.Unique.Count", Integer.toString(this.uniqueStepCountAcrossSlaves));
        this.setVariable("Internal.Step.CopyNr", Integer.toString(this.stepcopy));
        try {
            this.remoteOutputSteps = new ArrayList<RemoteStep>();
            for (i = 0; i < this.stepMeta.getRemoteOutputSteps().size(); ++i) {
                RemoteStep remoteStep = this.stepMeta.getRemoteOutputSteps().get(i);
                if (this.getCopy() != remoteStep.getSourceStepCopyNr()) continue;
                copy = (RemoteStep)remoteStep.clone();
                try {
                    if (this.log.isDetailed()) {
                        this.logDetailed("Selected remote output step [" + copy + "] to open a server socket to remote step [" + copy.getTargetStep() + "]." + copy.getTargetStepCopyNr() + " on port " + copy.getPort());
                    }
                    copy.openServerSocket(this);
                    if (this.log.isDetailed()) {
                        this.logDetailed("Opened a server socket connection to " + copy);
                    }
                }
                catch (Exception e) {
                    this.log.logError(this.toString(), "Unable to open server socket during step initialisation: " + copy.toString(), (Throwable)e);
                    throw e;
                }
                this.remoteOutputSteps.add(copy);
            }
        }
        catch (Exception e) {
            for (RemoteStep remoteStep : this.remoteOutputSteps) {
                if (remoteStep.getServerSocket() == null) continue;
                try {
                    ServerSocket serverSocket = remoteStep.getServerSocket();
                    this.getTrans().getSocketRepository().releaseSocket(serverSocket.getLocalPort());
                }
                catch (IOException e1) {
                    this.log.logError(this.toString(), "Unable to close server socket after error during step initialisation", (Throwable)e);
                }
            }
            return false;
        }
        try {
            this.remoteInputSteps = new ArrayList<RemoteStep>();
            if (this.stepMeta.isPartitioned() && this.getClusterSize() > 1 || this.stepMeta.getCopies() > 1) {
                for (i = 0; i < this.stepMeta.getRemoteInputSteps().size(); ++i) {
                    RemoteStep remoteStep = this.stepMeta.getRemoteInputSteps().get(i);
                    if (remoteStep.getTargetStepCopyNr() != this.stepcopy) continue;
                    copy = (RemoteStep)remoteStep.clone();
                    this.remoteInputSteps.add(copy);
                }
            } else {
                for (RemoteStep remoteStep : this.stepMeta.getRemoteInputSteps()) {
                    copy = (RemoteStep)remoteStep.clone();
                    this.remoteInputSteps.add(copy);
                }
            }
        }
        catch (Exception e) {
            this.log.logError(this.toString(), "Unable to initialize remote input steps during step initialisation", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        sdi.setStatus(6);
    }

    @Override
    public void cleanup() {
        for (ServerSocket serverSocket : this.serverSockets) {
            try {
                this.socketRepository.releaseSocket(serverSocket.getLocalPort());
                this.log.logDetailed(this.toString(), "Released server socket on port " + serverSocket.getLocalPort(), new Object[0]);
            }
            catch (IOException e) {
                this.log.logError(this.toString(), "Cleanup: Unable to release server socket (" + serverSocket.getLocalPort() + ")", (Throwable)e);
            }
        }
    }

    public long getProcessed() {
        if (this.getLinesRead() > this.getLinesWritten()) {
            return this.getLinesRead();
        }
        return this.getLinesWritten();
    }

    public void setCopy(int cop) {
        this.stepcopy = cop;
    }

    @Override
    public int getCopy() {
        return this.stepcopy;
    }

    @Override
    public long getErrors() {
        return this.errors;
    }

    @Override
    public void setErrors(long e) {
        this.errors = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesRead() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesRead() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementLinesRead() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return --this.linesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesRead(long newLinesReadValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesRead = newLinesReadValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesInput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesInput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesInput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesInput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesInput(long newLinesInputValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesInput = newLinesInputValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesOutput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesOutput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesOutput(long newLinesOutputValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesOutput = newLinesOutputValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesWritten() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesWritten() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementLinesWritten() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return --this.linesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesWritten(long newLinesWrittenValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesWritten = newLinesWrittenValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesUpdated() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesUpdated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesUpdated() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesUpdated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesUpdated(long newLinesUpdatedValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesUpdated = newLinesUpdatedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesRejected() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesRejected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesRejected() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesRejected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLinesRejected(long newLinesRejectedValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesRejected = newLinesRejectedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLinesSkipped() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesSkipped() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesSkipped(long newLinesSkippedValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesSkipped = newLinesSkippedValue;
        }
    }

    @Override
    public String getStepname() {
        return this.stepname;
    }

    public void setStepname(String stepname) {
        this.stepname = stepname;
    }

    public Trans getDispatcher() {
        return this.trans;
    }

    public String getStatusDescription() {
        return statusDesc[this.getStatus()];
    }

    public StepMetaInterface getStepMetaInterface() {
        return this.stepMetaInterface;
    }

    public void setStepMetaInterface(StepMetaInterface stepMetaInterface) {
        this.stepMetaInterface = stepMetaInterface;
    }

    public StepDataInterface getStepDataInterface() {
        return this.stepDataInterface;
    }

    public void setStepDataInterface(StepDataInterface stepDataInterface) {
        this.stepDataInterface = stepDataInterface;
    }

    @Override
    public StepMeta getStepMeta() {
        return this.stepMeta;
    }

    public void setStepMeta(StepMeta stepMeta) {
        this.stepMeta = stepMeta;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public Trans getTrans() {
        return this.trans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("BaseStep.Log.StopPuttingARow"));
            }
            this.stopAll();
            return;
        }
        if (!this.checkTransRunning) {
            while (!this.trans.isRunning() && !this.stopped.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
            this.checkTransRunning = true;
        }
        e = this;
        synchronized (e) {
            for (i = 0; i < this.rowListeners.size(); ++i) {
                rowListener = this.rowListeners.get(i);
                rowListener.rowWrittenEvent(rowMeta, row);
            }
        }
        if (this.terminator && this.terminator_rows != null) {
            try {
                this.terminator_rows.add(rowMeta.cloneRow(row));
            }
            catch (KettleValueException e) {
                throw new KettleStepException("Unable to clone row while adding rows to the terminator rows.", (Throwable)e);
            }
        }
        if (this.outputRowSets.isEmpty()) {
            this.incrementLinesWritten();
            return;
        }
        switch (this.repartitioning) {
            case 0: {
                if (this.distributed) {
                    rs = this.outputRowSets.get(this.currentOutputRowSetNr);
                    if (this.isUsingThreadPriorityManagment() && !rs.isDone() && rs.size() >= this.upperBufferBoundary && !this.isStopped()) {
                        try {
                            Thread.sleep(0L, 1);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    while (!rs.putRow(rowMeta, row) && !this.isStopped()) {
                    }
                    this.incrementLinesWritten();
                    if (this.outputRowSets.size() <= 1) break;
                    ++this.currentOutputRowSetNr;
                    if (this.currentOutputRowSetNr < this.outputRowSets.size()) break;
                    this.currentOutputRowSetNr = 0;
                    break;
                }
                for (i = 1; i < this.outputRowSets.size(); ++i) {
                    rs = this.outputRowSets.get(i);
                    if (this.isUsingThreadPriorityManagment() && !rs.isDone() && rs.size() >= this.upperBufferBoundary && !this.isStopped()) {
                        try {
                            Thread.sleep(0L, 1);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    try {
                        while (!rs.putRow(rowMeta, rowMeta.cloneRow(row)) && !this.isStopped()) {
                        }
                        this.incrementLinesWritten();
                        continue;
                    }
                    catch (KettleValueException e) {
                        throw new KettleStepException("Unable to clone row while copying rows to multiple target steps", (Throwable)e);
                    }
                }
                rs = this.outputRowSets.get(0);
                while (!rs.putRow(rowMeta, row) && !this.isStopped()) {
                }
                this.incrementLinesWritten();
                break;
            }
            case 2: {
                if (this.nextStepPartitioningMeta == null && (nextSteps = this.transMeta.findNextSteps(this.stepMeta)).size() > 0) {
                    this.nextStepPartitioningMeta = nextSteps.get(0).getStepPartitioningMeta();
                }
                try {
                    partitionNr = this.nextStepPartitioningMeta.getPartition(rowMeta, row);
                }
                catch (KettleException e) {
                    throw new KettleStepException("Unable to convert a value to integer while calculating the partition number", (Throwable)e);
                }
                selectedRowSet = null;
                if (this.clusteredPartitioningFirst) {
                    this.clusteredPartitioningFirst = false;
                    v0 = this.clusteredPartitioning = this.transMeta.getSlaveStepCopyPartitionDistribution() != null && this.transMeta.getSlaveStepCopyPartitionDistribution().getDistribution().isEmpty() == false;
                }
                if (!this.clusteredPartitioning) ** GOTO lbl116
                if (this.partitionNrRowSetList == null) {
                    this.partitionNrRowSetList = new RowSet[this.outputRowSets.size()];
                    distribution = this.transMeta.getSlaveStepCopyPartitionDistribution();
                    nextPartitionSchemaName = TransSplitter.createPartitionSchemaNameFromTarget(this.nextStepPartitioningMeta.getPartitionSchema().getName());
                    for (RowSet outputRowSet : this.outputRowSets) {
                        partNr = distribution.getPartition(outputRowSet.getRemoteSlaveServerName(), nextPartitionSchemaName, outputRowSet.getDestinationStepCopy());
                        if (partNr < 0) {
                            throw new KettleStepException("Unable to find partition using rowset data, slave=" + outputRowSet.getRemoteSlaveServerName() + ", partition schema=" + this.nextStepPartitioningMeta.getPartitionSchema().getName() + ", copy=" + outputRowSet.getDestinationStepCopy());
                        }
                        this.partitionNrRowSetList[partNr] = outputRowSet;
                    }
                }
                if (partitionNr < this.partitionNrRowSetList.length) {
                    selectedRowSet = this.partitionNrRowSetList[partitionNr];
                } else {
                    rowsets = "";
                    for (RowSet rowSet : this.partitionNrRowSetList) {
                        rowsets = rowsets + "[" + rowSet.toString() + "] ";
                    }
                    throw new KettleStepException("Internal error: the referenced partition nr '" + partitionNr + "' is higher than the maximum of '" + (this.partitionNrRowSetList.length - 1) + ".  The available row sets are: {" + rowsets + "}");
lbl116:
                    // 1 sources

                    selectedRowSet = this.outputRowSets.get(partitionNr);
                }
                if (selectedRowSet == null) {
                    this.logBasic("Target rowset is not available for target partition, partitionNr=" + partitionNr);
                }
                while (!selectedRowSet.putRow(rowMeta, row) && !this.isStopped()) {
                }
                this.incrementLinesWritten();
                if (!this.log.isRowLevel()) break;
                try {
                    this.logRowlevel("Partitioned #" + partitionNr + " to " + selectedRowSet + ", row=" + rowMeta.getString(row));
                    break;
                }
                catch (KettleValueException e) {
                    throw new KettleStepException((Throwable)e);
                }
            }
            case 1: {
                for (r = 0; r < this.outputRowSets.size(); ++r) {
                    rowSet = this.outputRowSets.get(r);
                    while (!rowSet.putRow(rowMeta, row) && !this.isStopped()) {
                    }
                }
                break;
            }
            default: {
                throw new KettleStepException("Internal error: invalid repartitioning type: " + this.repartitioning);
            }
        }
    }

    public void putRowTo(RowMetaInterface rowMeta, Object[] row, RowSet rowSet) throws KettleStepException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        for (int i = 0; i < this.rowListeners.size(); ++i) {
            RowListener rowListener = this.rowListeners.get(i);
            rowListener.rowWrittenEvent(rowMeta, row);
        }
        if (this.terminator && this.terminator_rows != null) {
            try {
                this.terminator_rows.add(rowMeta.cloneRow(row));
            }
            catch (KettleValueException e) {
                throw new KettleStepException("Unable to clone row while adding rows to the terminator buffer", (Throwable)e);
            }
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("BaseStep.Log.StopPuttingARow"));
            }
            this.stopAll();
            return;
        }
        while (!rowSet.putRow(rowMeta, row) && !this.isStopped()) {
        }
        this.incrementLinesWritten();
    }

    public void putError(RowMetaInterface rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws KettleStepException {
        if (this.safeModeEnabled && rowMeta.size() > row.length) {
            throw new KettleStepException(Messages.getString("BaseStep.Exception.MetadataDoesntMatchDataRowSize", Integer.toString(rowMeta.size()), Integer.toString(row != null ? row.length : 0)));
        }
        StepErrorMeta stepErrorMeta = this.stepMeta.getStepErrorMeta();
        if (this.errorRowMeta == null) {
            this.errorRowMeta = rowMeta.clone();
            RowMetaInterface add = stepErrorMeta.getErrorRowMeta(nrErrors, errorDescriptions, fieldNames, errorCodes);
            this.errorRowMeta.addRowMeta(add);
        }
        Object[] errorRowData = RowDataUtil.allocateRowData((int)this.errorRowMeta.size());
        if (row != null) {
            System.arraycopy(row, 0, errorRowData, 0, rowMeta.size());
        }
        stepErrorMeta.addErrorRowData(errorRowData, rowMeta.size(), nrErrors, errorDescriptions, fieldNames, errorCodes);
        for (int i = 0; i < this.rowListeners.size(); ++i) {
            RowListener rowListener = this.rowListeners.get(i);
            rowListener.errorRowWrittenEvent(rowMeta, row);
        }
        if (this.errorRowSet != null) {
            while (!this.errorRowSet.putRow(this.errorRowMeta, errorRowData) && !this.isStopped()) {
            }
            this.incrementLinesRejected();
        }
        this.verifyRejectionRates();
    }

    private void verifyRejectionRates() {
        int pct;
        StepErrorMeta stepErrorMeta = this.stepMeta.getStepErrorMeta();
        if (stepErrorMeta == null) {
            return;
        }
        if (stepErrorMeta.getMaxErrors() > 0L && this.getLinesRejected() > stepErrorMeta.getMaxErrors()) {
            this.logError(Messages.getString("BaseStep.Log.TooManyRejectedRows", Long.toString(stepErrorMeta.getMaxErrors()), Long.toString(this.getLinesRejected())));
            this.setErrors(1L);
            this.stopAll();
        }
        if (stepErrorMeta.getMaxPercentErrors() > 0 && this.getLinesRejected() > 0L && (stepErrorMeta.getMinPercentRows() <= 0L || this.getLinesRead() >= stepErrorMeta.getMinPercentRows()) && (pct = (int)(100L * this.getLinesRejected() / this.getLinesRead())) > stepErrorMeta.getMaxPercentErrors()) {
            this.logError(Messages.getString("BaseStep.Log.MaxPercentageRejectedReached", Integer.toString(pct), Long.toString(this.getLinesRejected()), Long.toString(this.getLinesRead())));
            this.setErrors(1L);
            this.stopAll();
        }
    }

    private RowSet currentInputStream() {
        return this.inputRowSets.get(this.currentInputRowSetNr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextInputStream() {
        ArrayList<RowSet> arrayList = this.inputRowSets;
        synchronized (arrayList) {
            this.blockPointer = 0;
            int streams = this.inputRowSets.size();
            if (streams == 0) {
                return;
            }
            if (streams == 1) {
                this.currentInputRowSetNr = 0;
            }
            ++this.currentInputRowSetNr;
            if (this.currentInputRowSetNr >= this.inputRowSets.size()) {
                this.currentInputRowSetNr = 0;
            }
        }
    }

    @Override
    public Object[] getRow() throws KettleException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("BaseStep.Log.StopLookingForMoreRows"));
            }
            this.stopAll();
            return null;
        }
        if (!this.checkTransRunning) {
            while (!this.trans.isRunning() && !this.stopped.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
            this.checkTransRunning = true;
        }
        this.openRemoteInputStepSocketsOnce();
        if (this.inputRowSets.isEmpty()) {
            return null;
        }
        RowSet inputRowSet = null;
        Object[] row = null;
        if (this.blockPointer >= NR_OF_ROWS_IN_BLOCK) {
            for (int r = 0; r < this.inputRowSets.size() && row == null; ++r) {
                this.nextInputStream();
                inputRowSet = this.currentInputStream();
                row = inputRowSet.getRowImmediate();
            }
            if (row != null) {
                this.incrementLinesRead();
            }
        } else {
            inputRowSet = this.currentInputStream();
        }
        if (this.isUsingThreadPriorityManagment() && !inputRowSet.isDone() && inputRowSet.size() <= this.lowerBufferBoundary && !this.isStopped()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        while (row == null && !this.isStopped()) {
            row = inputRowSet.getRowWait(1L, TimeUnit.MILLISECONDS);
            if (row != null) {
                this.incrementLinesRead();
                ++this.blockPointer;
                continue;
            }
            if (inputRowSet.isDone()) {
                row = inputRowSet.getRowWait(1L, TimeUnit.MILLISECONDS);
                if (row == null) {
                    this.inputRowSets.remove(this.currentInputRowSetNr);
                    if (this.inputRowSets.isEmpty()) {
                        return null;
                    }
                } else {
                    this.incrementLinesRead();
                }
            }
            this.nextInputStream();
            inputRowSet = this.currentInputStream();
        }
        while (row == null && !this.stopped.get()) {
            if (this.inputRowSets.isEmpty()) {
                return null;
            }
            this.nextInputStream();
            inputRowSet = this.currentInputStream();
            row = this.getRowFrom(inputRowSet);
        }
        if (this.inputRowMeta == null) {
            this.inputRowMeta = inputRowSet.getRowMeta();
        }
        if (row != null) {
            if (this.safeModeEnabled) {
                BaseStep.safeModeChecking(inputRowSet.getRowMeta(), this.inputRowMeta);
                if (row.length < this.inputRowMeta.size()) {
                    throw new KettleException("Safe mode check noticed that the length of the row data is smaller (" + row.length + ") than the row metadata size (" + this.inputRowMeta.size() + ")");
                }
            }
            for (int i = 0; i < this.rowListeners.size(); ++i) {
                RowListener rowListener = this.rowListeners.get(i);
                rowListener.rowReadEvent(this.inputRowMeta, row);
            }
        }
        this.verifyRejectionRates();
        return row;
    }

    protected void openRemoteInputStepSocketsOnce() throws KettleStepException {
        if (!this.remoteInputSteps.isEmpty() && !this.remoteInputStepsInitialized) {
            for (RemoteStep remoteStep : this.remoteInputSteps) {
                try {
                    RowSet rowSet = remoteStep.openReaderSocket(this);
                    this.inputRowSets.add(rowSet);
                }
                catch (Exception e) {
                    throw new KettleStepException("Error opening reader socket to remote step '" + remoteStep + "'", (Throwable)e);
                }
            }
            this.remoteInputStepsInitialized = true;
        }
    }

    protected void openRemoteOutputStepSocketsOnce() throws KettleStepException {
        if (!this.remoteOutputSteps.isEmpty() && !this.remoteOutputStepsInitialized) {
            for (int c = 0; c < this.outputRowSets.size(); ++c) {
                RowSet rowSet = this.outputRowSets.get(c);
                rowSet.setRemoteSlaveServerName(this.getVariable("Internal.Slave.Server.Name"));
                if (this.getVariable("Internal.Slave.Server.Name") != null) continue;
                throw new KettleStepException("Variable 'Internal.Slave.Server.Name' is not defined.");
            }
            for (int i = 0; i < this.remoteOutputSteps.size(); ++i) {
                RemoteStep remoteStep = this.remoteOutputSteps.get(i);
                try {
                    if (remoteStep.getTargetSlaveServerName() == null) {
                        throw new KettleStepException("The target slave server name is not defined for remote output step: " + remoteStep);
                    }
                    RowSet rowSet = remoteStep.openWriterSocket();
                    if (this.log.isDetailed()) {
                        this.logDetailed("Opened a writer socket to remote step: " + remoteStep);
                    }
                    this.outputRowSets.add(rowSet);
                    continue;
                }
                catch (IOException e) {
                    throw new KettleStepException("Error opening writer socket to remote step '" + remoteStep + "'", (Throwable)e);
                }
            }
            this.remoteOutputStepsInitialized = true;
        }
    }

    protected void safeModeChecking(RowMetaInterface row) throws KettleRowException {
        if (row == null) {
            return;
        }
        if (this.inputReferenceRow == null) {
            this.inputReferenceRow = row.clone();
            Object[] fieldnames = row.getFieldNames();
            Arrays.sort(fieldnames);
            for (int i = 0; i < fieldnames.length - 1; ++i) {
                if (!((String)fieldnames[i]).equals(fieldnames[i + 1])) continue;
                throw new KettleRowException(Messages.getString("BaseStep.SafeMode.Exception.DoubleFieldnames", (String)fieldnames[i]));
            }
        } else {
            BaseStep.safeModeChecking(this.inputReferenceRow, row);
        }
    }

    public static void safeModeChecking(RowMetaInterface referenceRowMeta, RowMetaInterface rowMeta) throws KettleRowException {
        if (referenceRowMeta.size() != rowMeta.size()) {
            throw new KettleRowException(Messages.getString("BaseStep.SafeMode.Exception.VaryingSize", "" + referenceRowMeta.size(), "" + rowMeta.size(), rowMeta.toString()));
        }
        for (int i = 0; i < referenceRowMeta.size(); ++i) {
            ValueMetaInterface referenceValue = referenceRowMeta.getValueMeta(i);
            ValueMetaInterface compareValue = rowMeta.getValueMeta(i);
            if (!referenceValue.getName().equalsIgnoreCase(compareValue.getName())) {
                throw new KettleRowException(Messages.getString("BaseStep.SafeMode.Exception.MixingLayout", "" + (i + 1), referenceValue.getName() + " " + referenceValue.toStringMeta(), compareValue.getName() + " " + compareValue.toStringMeta()));
            }
            if (referenceValue.getType() == compareValue.getType()) continue;
            throw new KettleRowException(Messages.getString("BaseStep.SafeMode.Exception.MixingTypes", "" + (i + 1), referenceValue.getName() + " " + referenceValue.toStringMeta(), compareValue.getName() + " " + compareValue.toStringMeta()));
        }
    }

    public Object[] getRowFrom(RowSet rowSet) throws KettleStepException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.isUsingThreadPriorityManagment() && !rowSet.isDone() && rowSet.size() <= this.lowerBufferBoundary && !this.isStopped()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Object[] rowData = rowSet.getRow();
        while (rowData == null && !rowSet.isDone() && !this.stopped.get()) {
            rowData = rowSet.getRow();
        }
        if (rowData == null && rowSet.isDone()) {
            rowData = rowSet.getRow();
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("BaseStep.Log.StopLookingForMoreRows"));
            }
            this.stopAll();
            return null;
        }
        if (rowData == null && rowSet.isDone() && (rowData = rowSet.getRow()) == null) {
            this.inputRowSets.remove(rowSet);
            return null;
        }
        this.incrementLinesRead();
        for (int i = 0; i < this.rowListeners.size(); ++i) {
            RowListener rowListener = this.rowListeners.get(i);
            rowListener.rowReadEvent(rowSet.getRowMeta(), rowData);
        }
        return rowData;
    }

    public RowSet findInputRowSet(String sourceStep) throws KettleStepException {
        StepMeta sourceStepMeta = this.transMeta.findStep(sourceStep);
        if (sourceStepMeta == null) {
            throw new KettleStepException(Messages.getString("BaseStep.Exception.SourceStepToReadFromDoesntExist", sourceStep));
        }
        if (sourceStepMeta.getCopies() > 1) {
            throw new KettleStepException(Messages.getString("BaseStep.Exception.SourceStepToReadFromCantRunInMultipleCopies", sourceStep, Integer.toString(sourceStepMeta.getCopies())));
        }
        return this.findInputRowSet(sourceStep, 0, this.getStepname(), this.getCopy());
    }

    public RowSet findInputRowSet(String from, int fromcopy, String to, int tocopy) {
        List<BaseStep> baseSteps;
        for (RowSet rs : this.inputRowSets) {
            if (!rs.getOriginStepName().equalsIgnoreCase(from) || !rs.getDestinationStepName().equalsIgnoreCase(to) || rs.getOriginStepCopy() != fromcopy || rs.getDestinationStepCopy() != tocopy) continue;
            return rs;
        }
        StepMeta mappingStep = this.transMeta.findStep(from);
        if (mappingStep != null && mappingStep.isMapping() && (baseSteps = this.trans.findBaseSteps(from)).size() == 1) {
            MappingOutput[] outputs;
            Mapping mapping = (Mapping)baseSteps.get(0);
            for (MappingOutput output : outputs = mapping.getMappingTrans().findMappingOutput()) {
                for (RowSet rs : output.getOutputRowSets()) {
                    if (!rs.getDestinationStepName().equalsIgnoreCase(to)) continue;
                    return rs;
                }
            }
        }
        return null;
    }

    public RowSet findOutputRowSet(String targetStep) throws KettleStepException {
        StepMeta targetStepMeta = this.transMeta.findStep(targetStep);
        if (targetStepMeta == null) {
            throw new KettleStepException(Messages.getString("BaseStep.Exception.TargetStepToWriteToDoesntExist", targetStep));
        }
        if (targetStepMeta.getCopies() > 1) {
            throw new KettleStepException(Messages.getString("BaseStep.Exception.TargetStepToWriteToCantRunInMultipleCopies", targetStep, Integer.toString(targetStepMeta.getCopies())));
        }
        return this.findOutputRowSet(this.getStepname(), this.getCopy(), targetStep, 0);
    }

    public RowSet findOutputRowSet(String from, int fromcopy, String to, int tocopy) {
        List<BaseStep> baseSteps;
        for (RowSet rs : this.outputRowSets) {
            if (!rs.getOriginStepName().equalsIgnoreCase(from) || !rs.getDestinationStepName().equalsIgnoreCase(to) || rs.getOriginStepCopy() != fromcopy || rs.getDestinationStepCopy() != tocopy) continue;
            return rs;
        }
        StepMeta mappingStep = this.transMeta.findStep(to);
        if (mappingStep != null && mappingStep.isMapping() && (baseSteps = this.trans.findBaseSteps(to)).size() == 1) {
            MappingInput[] inputs;
            Mapping mapping = (Mapping)baseSteps.get(0);
            for (MappingInput input : inputs = mapping.getMappingTrans().findMappingInput()) {
                for (RowSet rs : input.getInputRowSets()) {
                    if (!rs.getOriginStepName().equalsIgnoreCase(from)) continue;
                    return rs;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputDone() {
        if (this.log.isDebug()) {
            this.logDebug(Messages.getString("BaseStep.Log.OutputDone", String.valueOf(this.outputRowSets.size())));
        }
        ArrayList<RowSet> arrayList = this.outputRowSets;
        synchronized (arrayList) {
            for (int i = 0; i < this.outputRowSets.size(); ++i) {
                RowSet rs = this.outputRowSets.get(i);
                rs.setDone();
            }
            if (this.errorRowSet != null) {
                this.errorRowSet.setDone();
            }
        }
    }

    public void dispatch() {
        RowSet rowSet;
        int c;
        int nrCopies;
        int dispatchType;
        int nextCopies;
        int prevCopies;
        int i;
        if (this.transMeta == null) {
            return;
        }
        StepMeta stepMeta = this.transMeta.findStep(this.stepname);
        if (this.log.isDetailed()) {
            this.logDetailed(Messages.getString("BaseStep.Log.StartingBuffersAllocation"));
        }
        List<StepMeta> previousSteps = this.transMeta.findPreviousSteps(stepMeta, true);
        List<StepMeta> succeedingSteps = this.transMeta.findNextSteps(stepMeta);
        int nrInput = previousSteps.size();
        int nrOutput = succeedingSteps.size();
        this.inputRowSets = new ArrayList();
        this.outputRowSets = new ArrayList();
        this.errorRowSet = null;
        this.prevSteps = new StepMeta[nrInput];
        this.nextSteps = new StepMeta[nrOutput];
        this.currentInputRowSetNr = 0;
        if (this.log.isDetailed()) {
            this.logDetailed(Messages.getString("BaseStep.Log.StepInfo", String.valueOf(nrInput), String.valueOf(nrOutput)));
        }
        for (i = 0; i < previousSteps.size(); ++i) {
            this.prevSteps[i] = previousSteps.get(i);
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("BaseStep.Log.GotPreviousStep", this.stepname, String.valueOf(i), this.prevSteps[i].getName()));
            }
            prevCopies = this.prevSteps[i].getCopies();
            nextCopies = stepMeta.getCopies();
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("BaseStep.Log.InputRowInfo", String.valueOf(prevCopies), String.valueOf(nextCopies)));
            }
            if (prevCopies == 1 && nextCopies == 1) {
                dispatchType = 1;
                nrCopies = 1;
            } else if (prevCopies == 1 && nextCopies > 1) {
                dispatchType = 2;
                nrCopies = 1;
            } else if (prevCopies > 1 && nextCopies == 1) {
                dispatchType = 3;
                nrCopies = prevCopies;
            } else if (prevCopies == nextCopies) {
                dispatchType = 4;
                nrCopies = 1;
            } else {
                dispatchType = 5;
                nrCopies = prevCopies;
            }
            for (c = 0; c < nrCopies; ++c) {
                rowSet = null;
                switch (dispatchType) {
                    case 1: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), 0, this.stepname, 0);
                        break;
                    }
                    case 2: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), 0, this.stepname, this.getCopy());
                        break;
                    }
                    case 3: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), c, this.stepname, 0);
                        break;
                    }
                    case 4: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), this.getCopy(), this.stepname, this.getCopy());
                        break;
                    }
                    case 5: {
                        rowSet = this.trans.findRowSet(this.prevSteps[i].getName(), c, this.stepname, this.getCopy());
                    }
                }
                if (rowSet != null) {
                    this.inputRowSets.add(rowSet);
                    if (!this.log.isDetailed()) continue;
                    this.logDetailed(Messages.getString("BaseStep.Log.FoundInputRowset", rowSet.getName()));
                    continue;
                }
                if (this.prevSteps[i].isMapping() || stepMeta.isMapping()) continue;
                this.logError(Messages.getString("BaseStep.Log.UnableToFindInputRowset"));
                this.setErrors(1L);
                this.stopAll();
                return;
            }
        }
        for (i = 0; i < nrOutput; ++i) {
            this.nextSteps[i] = succeedingSteps.get(i);
            prevCopies = stepMeta.getCopies();
            nextCopies = this.nextSteps[i].getCopies();
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("BaseStep.Log.OutputRowInfo", String.valueOf(prevCopies), String.valueOf(nextCopies)));
            }
            if (prevCopies == 1 && nextCopies == 1) {
                dispatchType = 1;
                nrCopies = 1;
            } else if (prevCopies == 1 && nextCopies > 1) {
                dispatchType = 2;
                nrCopies = nextCopies;
            } else if (prevCopies > 1 && nextCopies == 1) {
                dispatchType = 3;
                nrCopies = 1;
            } else if (prevCopies == nextCopies) {
                dispatchType = 4;
                nrCopies = 1;
            } else {
                dispatchType = 5;
                nrCopies = nextCopies;
            }
            for (c = 0; c < nrCopies; ++c) {
                rowSet = null;
                switch (dispatchType) {
                    case 1: {
                        rowSet = this.trans.findRowSet(this.stepname, 0, this.nextSteps[i].getName(), 0);
                        break;
                    }
                    case 2: {
                        rowSet = this.trans.findRowSet(this.stepname, 0, this.nextSteps[i].getName(), c);
                        break;
                    }
                    case 3: {
                        rowSet = this.trans.findRowSet(this.stepname, this.getCopy(), this.nextSteps[i].getName(), 0);
                        break;
                    }
                    case 4: {
                        rowSet = this.trans.findRowSet(this.stepname, this.getCopy(), this.nextSteps[i].getName(), this.getCopy());
                        break;
                    }
                    case 5: {
                        rowSet = this.trans.findRowSet(this.stepname, this.getCopy(), this.nextSteps[i].getName(), c);
                    }
                }
                if (rowSet != null) {
                    this.outputRowSets.add(rowSet);
                    if (!this.log.isDetailed()) continue;
                    this.logDetailed(Messages.getString("BaseStep.Log.FoundOutputRowset", rowSet.getName()));
                    continue;
                }
                if (stepMeta.isMapping() || this.nextSteps[i].isMapping()) continue;
                this.logError(Messages.getString("BaseStep.Log.UnableToFindOutputRowset"));
                this.setErrors(1L);
                this.stopAll();
                return;
            }
        }
        if (stepMeta.getTargetStepPartitioningMeta() != null) {
            this.nextStepPartitioningMeta = stepMeta.getTargetStepPartitioningMeta();
        }
        if (this.log.isDetailed()) {
            this.logDetailed(Messages.getString("BaseStep.Log.FinishedDispatching"));
        }
    }

    public void logMinimal(String s) {
        this.log.println(2, this.toString(), s, new Object[0]);
    }

    public void logBasic(String s) {
        this.log.println(3, this.toString(), s, new Object[0]);
    }

    public void logError(String s) {
        this.log.println(1, this.toString(), s, new Object[0]);
    }

    public void logError(String s, Throwable e) {
        this.log.logError(this.toString(), s, e);
    }

    public void logDetailed(String s) {
        this.log.println(4, this.toString(), s, new Object[0]);
    }

    public void logDebug(String s) {
        this.log.println(5, this.toString(), s, new Object[0]);
    }

    public void logRowlevel(String s) {
        this.log.println(6, this.toString(), s, new Object[0]);
    }

    public int getNextClassNr() {
        int ret = this.trans.class_nr++;
        return ret;
    }

    public boolean outputIsDone() {
        int nrstopped = 0;
        for (RowSet rs : this.outputRowSets) {
            if (!rs.isDone()) continue;
            ++nrstopped;
        }
        return nrstopped >= this.outputRowSets.size();
    }

    @Override
    public void stopAll() {
        this.stopped.set(true);
        this.trans.stopAll();
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void setStopped(boolean stopped) {
        this.stopped.set(stopped);
    }

    public void setStopped(AtomicBoolean stopped) {
        this.stopped = stopped;
    }

    @Override
    public void pauseRunning() {
        this.setPaused(true);
    }

    @Override
    public void resumeRunning() {
        this.setPaused(false);
    }

    public void setPaused(boolean paused) {
        this.paused.set(paused);
    }

    public void setPaused(AtomicBoolean paused) {
        this.paused = paused;
    }

    public boolean isInitialising() {
        return this.init;
    }

    @Override
    public void markStart() {
        Calendar cal = Calendar.getInstance();
        this.start_time = cal.getTime();
        this.setInternalVariables();
    }

    public void setInternalVariables() {
        this.setVariable("Internal.Step.Name", this.stepname);
        this.setVariable("Internal.Step.CopyNr", Integer.toString(this.getCopy()));
    }

    @Override
    public void markStop() {
        Calendar cal = Calendar.getInstance();
        this.stop_time = cal.getTime();
        for (StepListener stepListener : this.stepListeners) {
            stepListener.stepFinished(this.trans, this.stepMeta, this);
        }
    }

    public long getRuntime() {
        long lapsed;
        if (this.start_time != null && this.stop_time == null) {
            Calendar cal = Calendar.getInstance();
            long now = cal.getTimeInMillis();
            long st = this.start_time.getTime();
            lapsed = now - st;
        } else {
            lapsed = this.start_time != null && this.stop_time != null ? this.stop_time.getTime() - this.start_time.getTime() : 0L;
        }
        return lapsed;
    }

    public RowMetaAndData buildLog(String sname, int copynr, long lines_read, long lines_written, long lines_updated, long lines_skipped, long errors, Date start_date, Date end_date) {
        RowMeta r = new RowMeta();
        Object[] data = new Object[9];
        int nr = 0;
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.Stepname"), 2));
        data[nr] = sname;
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.Copy"), 1));
        data[++nr] = new Double(copynr);
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.LinesReaded"), 1));
        data[++nr] = new Double(lines_read);
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.LinesWritten"), 1));
        data[++nr] = new Double(lines_written);
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.LinesUpdated"), 1));
        data[++nr] = new Double(lines_updated);
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.LinesSkipped"), 1));
        data[++nr] = new Double(lines_skipped);
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.Errors"), 1));
        data[++nr] = new Double(errors);
        r.addValueMeta((ValueMetaInterface)new ValueMeta("start_date", 3));
        data[++nr] = start_date;
        r.addValueMeta((ValueMetaInterface)new ValueMeta("end_date", 3));
        data[++nr] = end_date;
        ++nr;
        return new RowMetaAndData((RowMetaInterface)r, data);
    }

    public static final RowMetaInterface getLogFields(String comm) {
        RowMeta r = new RowMeta();
        ValueMeta sname = new ValueMeta(Messages.getString("BaseStep.ColumnName.Stepname"), 2);
        sname.setLength(256);
        r.addValueMeta((ValueMetaInterface)sname);
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.Copy"), 1));
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.LinesReaded"), 1));
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.LinesWritten"), 1));
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.LinesUpdated"), 1));
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.LinesSkipped"), 1));
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.Errors"), 1));
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.StartDate"), 3));
        r.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("BaseStep.ColumnName.EndDate"), 3));
        for (int i = 0; i < r.size(); ++i) {
            r.getValueMeta(i).setOrigin(comm);
        }
        return r;
    }

    @Override
    public String toString() {
        StringBuffer string = new StringBuffer();
        if (!Const.isEmpty((String)this.getTrans().getMappingStepName())) {
            string.append('[').append(this.trans.toString()).append(']').append('.');
        }
        if (!Const.isEmpty((String)this.partitionID)) {
            string.append(this.stepname).append('.').append(this.partitionID);
        } else if (this.clusterSize > 1) {
            string.append(this.stepname).append('.').append(this.slaveNr).append('.').append(Integer.toString(this.getCopy()));
        } else {
            string.append(this.stepname).append('.').append(Integer.toString(this.getCopy()));
        }
        return string.toString();
    }

    public Thread getThread() {
        return this;
    }

    public int rowsetOutputSize() {
        int size = 0;
        for (int i = 0; i < this.outputRowSets.size(); ++i) {
            size += this.outputRowSets.get(i).size();
        }
        return size;
    }

    public int rowsetInputSize() {
        int size = 0;
        for (int i = 0; i < this.inputRowSets.size(); ++i) {
            size += this.inputRowSets.get(i).size();
        }
        return size;
    }

    public static final StepMetaInterface getStepInfo(StepPlugin stepplugin, StepLoader steploader) throws KettleStepLoaderException {
        return steploader.getStepClass(stepplugin);
    }

    public static final String getIconFilename(int steptype) {
        return steps[steptype].getImageFileName();
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
    }

    public void stopRunning() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSummary() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            long li = this.getLinesInput();
            long lo = this.getLinesOutput();
            long lr = this.getLinesRead();
            long lw = this.getLinesWritten();
            long lu = this.getLinesUpdated();
            long lj = this.getLinesRejected();
            if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || this.errors > 0L) {
                this.logBasic(Messages.getString("BaseStep.Log.SummaryInfo", String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lw), String.valueOf(this.errors + lj)));
            } else {
                this.logDetailed(Messages.getString("BaseStep.Log.SummaryInfo", String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lw), String.valueOf(this.errors + lj)));
            }
        }
    }

    @Override
    public String getStepID() {
        if (this.stepMeta != null) {
            return this.stepMeta.getStepID();
        }
        return null;
    }

    @Override
    public List<RowSet> getInputRowSets() {
        return this.inputRowSets;
    }

    public void setInputRowSets(ArrayList<RowSet> inputRowSets) {
        this.inputRowSets = inputRowSets;
    }

    @Override
    public List<RowSet> getOutputRowSets() {
        return this.outputRowSets;
    }

    public void setOutputRowSets(ArrayList<RowSet> outputRowSets) {
        this.outputRowSets = outputRowSets;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    @Override
    public void addRowListener(RowListener rowListener) {
        this.rowListeners.add(rowListener);
    }

    @Override
    public void removeRowListener(RowListener rowListener) {
        this.rowListeners.remove(rowListener);
    }

    @Override
    public List<RowListener> getRowListeners() {
        return this.rowListeners;
    }

    public void addResultFile(ResultFile resultFile) {
        this.resultFiles.put(resultFile.getFile().toString(), resultFile);
    }

    public Map<String, ResultFile> getResultFiles() {
        return this.resultFiles;
    }

    public boolean isSafeModeEnabled() {
        return this.safeModeEnabled;
    }

    public void setSafeModeEnabled(boolean safeModeEnabled) {
        this.safeModeEnabled = safeModeEnabled;
    }

    public int getStatus() {
        if (this.isAlive()) {
            if (this.isStopped()) {
                return 9;
            }
            if (this.isPaused()) {
                return 8;
            }
            return 2;
        }
        if (this.trans.isInitializing()) {
            if (this.isInitialising()) {
                return 1;
            }
            return 3;
        }
        if (this.isStopped()) {
            return 5;
        }
        StepDataInterface sdi = this.trans.getStepDataInterface(this.stepname, this.stepcopy);
        if (sdi != null) {
            if (sdi.getStatus() == 6 && !this.isAlive()) {
                return 4;
            }
            return sdi.getStatus();
        }
        return 0;
    }

    @Override
    public String getPartitionID() {
        return this.partitionID;
    }

    @Override
    public void setPartitionID(String partitionID) {
        this.partitionID = partitionID;
    }

    public Map<String, RowSet> getPartitionTargets() {
        return this.partitionTargets;
    }

    public void setPartitionTargets(Map<String, RowSet> partitionTargets) {
        this.partitionTargets = partitionTargets;
    }

    public int getRepartitioning() {
        return this.repartitioning;
    }

    public void setRepartitioning(int repartitioning) {
        this.repartitioning = repartitioning;
    }

    @Override
    public boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    protected boolean checkFeedback(long lines) {
        return this.getTransMeta().isFeedbackShown() && lines > 0L && this.getTransMeta().getFeedbackSize() > 0 && lines % (long)this.getTransMeta().getFeedbackSize() == 0L;
    }

    public RowMetaInterface getInputRowMeta() {
        return this.inputRowMeta;
    }

    public void setInputRowMeta(RowMetaInterface rowMeta) {
        this.inputRowMeta = rowMeta;
    }

    public RowMetaInterface getErrorRowMeta() {
        return this.errorRowMeta;
    }

    public void setErrorRowMeta(RowMetaInterface errorRowMeta) {
        this.errorRowMeta = errorRowMeta;
    }

    public RowMetaInterface getPreviewRowMeta() {
        return this.previewRowMeta;
    }

    public void setPreviewRowMeta(RowMetaInterface previewRowMeta) {
        this.previewRowMeta = previewRowMeta;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public String getTypeId() {
        return this.getStepID();
    }

    public int getSlaveNr() {
        return this.slaveNr;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public int getUniqueStepNrAcrossSlaves() {
        return this.uniqueStepNrAcrossSlaves;
    }

    public int getUniqueStepCountAcrossSlaves() {
        return this.uniqueStepCountAcrossSlaves;
    }

    public List<ServerSocket> getServerSockets() {
        return this.serverSockets;
    }

    public void setServerSockets(List<ServerSocket> serverSockets) {
        this.serverSockets = serverSockets;
    }

    public void setUsingThreadPriorityManagment(boolean usingThreadPriorityManagment) {
        this.usingThreadPriorityManagment = usingThreadPriorityManagment;
    }

    public boolean isUsingThreadPriorityManagment() {
        return this.usingThreadPriorityManagment;
    }

    @Override
    public void initBeforeStart() throws KettleStepException {
        this.openRemoteOutputStepSocketsOnce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runStepThread(StepInterface stepInterface, StepMetaInterface meta, StepDataInterface data) {
        LogWriter log = LogWriter.getInstance();
        try {
            try {
                if (log.isDetailed()) {
                    log.logDetailed(stepInterface.toString(), Messages.getString("System.Log.StartingToRun"), new Object[0]);
                }
                while (stepInterface.processRow(meta, data) && !stepInterface.isStopped()) {
                }
                Object var9_4 = null;
                stepInterface.dispose(meta, data);
            }
            catch (Throwable t) {
                block27: {
                    try {
                        try {
                            if (t instanceof OutOfMemoryError) {
                                log.logError(stepInterface.toString(), "UnexpectedError: " + t.toString(), new Object[0]);
                            } else {
                                log.logError(stepInterface.toString(), Messages.getString("System.Log.UnexpectedError") + " : ", new Object[0]);
                            }
                            log.logError(stepInterface.toString(), Const.getStackTracker((Throwable)t), new Object[0]);
                        }
                        catch (OutOfMemoryError e) {
                            e.printStackTrace();
                            Object var7_45 = null;
                            stepInterface.setErrors(1L);
                            stepInterface.stopAll();
                            break block27;
                        }
                        Object var7_44 = null;
                        stepInterface.setErrors(1L);
                        stepInterface.stopAll();
                    }
                    catch (Throwable throwable) {
                        Object var7_46 = null;
                        stepInterface.setErrors(1L);
                        stepInterface.stopAll();
                        throw throwable;
                    }
                }
                Object var9_5 = null;
                stepInterface.dispose(meta, data);
                try {
                    try {
                        long li = stepInterface.getLinesInput();
                        long lo = stepInterface.getLinesOutput();
                        long lr = stepInterface.getLinesRead();
                        long lw = stepInterface.getLinesWritten();
                        long lu = stepInterface.getLinesUpdated();
                        long lj = stepInterface.getLinesRejected();
                        long e = stepInterface.getErrors();
                        if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
                            log.logBasic(stepInterface.toString(), Messages.getString("BaseStep.Log.SummaryInfo", String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)), new Object[0]);
                        } else {
                            log.logDetailed(stepInterface.toString(), Messages.getString("BaseStep.Log.SummaryInfo", String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)), new Object[0]);
                        }
                    }
                    catch (Throwable t2) {
                        log.logError(stepInterface.toString(), "UnexpectedError: " + t2.toString(), new Object[0]);
                        Object var25_35 = null;
                        stepInterface.markStop();
                        return;
                    }
                    Object var25_34 = null;
                    stepInterface.markStop();
                    return;
                }
                catch (Throwable throwable) {
                    Object var25_36 = null;
                    stepInterface.markStop();
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            stepInterface.dispose(meta, data);
            try {}
            catch (Throwable throwable2) {
                Object var25_39 = null;
                stepInterface.markStop();
                throw throwable2;
            }
            try {}
            catch (Throwable t2) {
                log.logError(stepInterface.toString(), "UnexpectedError: " + t2.toString(), new Object[0]);
                Object var25_38 = null;
                stepInterface.markStop();
                throw throwable;
            }
            long li = stepInterface.getLinesInput();
            long lo = stepInterface.getLinesOutput();
            long lr = stepInterface.getLinesRead();
            long lw = stepInterface.getLinesWritten();
            long lu = stepInterface.getLinesUpdated();
            long lj = stepInterface.getLinesRejected();
            long e = stepInterface.getErrors();
            if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
                log.logBasic(stepInterface.toString(), Messages.getString("BaseStep.Log.SummaryInfo", String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)), new Object[0]);
            } else {
                log.logDetailed(stepInterface.toString(), Messages.getString("BaseStep.Log.SummaryInfo", String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)), new Object[0]);
            }
            Object var25_37 = null;
            stepInterface.markStop();
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var25_33 = null;
            stepInterface.markStop();
            throw throwable;
        }
        try {}
        catch (Throwable t2) {
            log.logError(stepInterface.toString(), "UnexpectedError: " + t2.toString(), new Object[0]);
            Object var25_32 = null;
            stepInterface.markStop();
            return;
        }
        long li = stepInterface.getLinesInput();
        long lo = stepInterface.getLinesOutput();
        long lr = stepInterface.getLinesRead();
        long lw = stepInterface.getLinesWritten();
        long lu = stepInterface.getLinesUpdated();
        long lj = stepInterface.getLinesRejected();
        long e = stepInterface.getErrors();
        if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
            log.logBasic(stepInterface.toString(), Messages.getString("BaseStep.Log.SummaryInfo", String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)), new Object[0]);
        } else {
            log.logDetailed(stepInterface.toString(), Messages.getString("BaseStep.Log.SummaryInfo", String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)), new Object[0]);
        }
        Object var25_31 = null;
        stepInterface.markStop();
    }

    public List<StepListener> getStepListeners() {
        return this.stepListeners;
    }

    public void setStepListeners(List<StepListener> stepListeners) {
        this.stepListeners = stepListeners;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        return false;
    }

    @Override
    public void addStepListener(StepListener stepListener) {
        this.stepListeners.add(stepListener);
    }

    @Override
    public boolean isMapping() {
        return this.stepMeta.isMapping();
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<BaseStep> clazz = BaseStep.class;
        synchronized (BaseStep.class) {
            try {
                ConfigManager<?> stepsAnntCfg = KettleConfig.getInstance().getManager("steps-annotation-config");
                Collection<StepPluginMeta> mainSteps = stepsAnntCfg.loadAs(StepPluginMeta.class);
                ConfigManager<?> stepsCfg = KettleConfig.getInstance().getManager("steps-xml-config");
                Collection<StepPluginMeta> csteps = stepsCfg.loadAs(StepPluginMeta.class);
                mainSteps.addAll(csteps);
                steps = mainSteps.toArray(new StepPluginMeta[mainSteps.size()]);
            }
            catch (KettleConfigException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            category_order = new String[]{StepCategory.INPUT.getName(), StepCategory.OUTPUT.getName(), StepCategory.LOOKUP.getName(), StepCategory.TRANSFORM.getName(), StepCategory.JOINS.getName(), StepCategory.SCRIPTING.getName(), StepCategory.DATA_WAREHOUSE.getName(), StepCategory.MAPPING.getName(), StepCategory.JOB.getName(), StepCategory.INLINE.getName(), StepCategory.EXPERIMENTAL.getName(), StepCategory.DEPRECATED.getName(), StepCategory.BULK.getName()};
            statusDesc = new String[]{Messages.getString("BaseStep.status.Empty"), Messages.getString("BaseStep.status.Init"), Messages.getString("BaseStep.status.Running"), Messages.getString("BaseStep.status.Idle"), Messages.getString("BaseStep.status.Finished"), Messages.getString("BaseStep.status.Stopped"), Messages.getString("BaseStep.status.Disposed"), Messages.getString("BaseStep.status.Halted"), Messages.getString("BaseStep.status.Paused"), Messages.getString("BaseStep.status.Halting")};
            NR_OF_ROWS_IN_BLOCK = 500;
            return;
        }
    }
}

