/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.config;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Inject;
import org.pentaho.di.core.annotations.Job;
import org.pentaho.di.core.config.BasicConfigManager;
import org.pentaho.di.core.exception.KettleConfigException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.ResolverUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobEntryCategory;
import org.pentaho.di.job.JobPluginMeta;
import org.pentaho.di.job.entry.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedJobConfigManager<T extends JobPluginMeta>
extends BasicConfigManager<T> {
    @Inject
    String packages;

    @Override
    public Collection<T> load() throws KettleConfigException {
        int oldLogLevel = LogWriter.getInstance().getLogLevel();
        ResolverUtil resolver = new ResolverUtil();
        String allPackages = this.packages;
        String extraPackages = System.getProperty("KETTLE_PLUGIN_PACKAGES");
        if (!Const.isEmpty((String)extraPackages)) {
            allPackages = allPackages + "," + extraPackages;
        }
        resolver.find((ResolverUtil.Test)new ResolverUtil.AnnotatedWith(Job.class), allPackages != null ? allPackages.split(",") : new String[]{});
        LinkedHashSet<JobPluginMeta> jobs = new LinkedHashSet<JobPluginMeta>(resolver.size());
        for (Class clazz : resolver.getClasses()) {
            String category;
            String packageName;
            Job job = clazz.getAnnotation(Job.class);
            String jobId = job.id();
            if (jobId.equals("")) {
                jobId = clazz.getName();
            }
            if (Const.isEmpty((String)(packageName = job.i18nPackageName()))) {
                packageName = Messages.class.getPackage().getName();
            }
            String altPackageName = clazz.getPackage().getName();
            LogWriter.getInstance().setLogLevel(3);
            String name = BaseMessages.getString((String)packageName, (String)job.name());
            if (name.startsWith("!") && name.endsWith("!")) {
                name = Messages.getString(job.name());
            }
            LogWriter.getInstance().setLogLevel(oldLogLevel);
            if (!Const.isEmpty((String)job.name()) && name.startsWith("!") && name.endsWith("!")) {
                name = BaseMessages.getString((String)altPackageName, (String)job.name());
            }
            if (name.startsWith("!") && name.endsWith("!")) {
                name = job.name();
            }
            LogWriter.getInstance().setLogLevel(3);
            String tooltip = BaseMessages.getString((String)packageName, (String)job.tooltip());
            if (tooltip.startsWith("!") && tooltip.endsWith("!")) {
                tooltip = Messages.getString(job.tooltip());
            }
            LogWriter.getInstance().setLogLevel(oldLogLevel);
            if (tooltip.startsWith("!") && tooltip.endsWith("!")) {
                tooltip = BaseMessages.getString((String)altPackageName, (String)job.tooltip());
            }
            if (tooltip.startsWith("!") && tooltip.endsWith("!")) {
                tooltip = job.tooltip();
            }
            if (Const.isEmpty((String)name)) {
                name = tooltip;
            }
            if (job.category() != -1) {
                category = JobEntryCategory.STANDARD_CATEGORIES[job.category()].getName();
            } else {
                LogWriter.getInstance().setLogLevel(3);
                category = BaseMessages.getString((String)packageName, (String)job.categoryDescription());
                if (category.startsWith("!") && category.endsWith("!")) {
                    category = Messages.getString(job.categoryDescription());
                }
                LogWriter.getInstance().setLogLevel(oldLogLevel);
                if (category.startsWith("!") && category.endsWith("!")) {
                    category = BaseMessages.getString((String)altPackageName, (String)job.categoryDescription());
                }
            }
            jobs.add(new JobPluginMeta(clazz, jobId, job.type(), name, tooltip, job.image(), category));
        }
        return jobs;
    }
}

