/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.VersionMap;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;

public class HeaderItem {
    private static final byte[] MAGIC_VALUE = new byte[]{100, 101, 120, 10, 0, 0, 0, 0};

    public static byte[] getMagicForApi(int api) {
        return HeaderItem.getMagicForDexVersion(VersionMap.mapApiToDexVersion(api));
    }

    public static byte[] getMagicForDexVersion(int dexVersion) {
        byte[] magic = (byte[])MAGIC_VALUE.clone();
        if (dexVersion < 0 || dexVersion > 999) {
            throw new IllegalArgumentException("dexVersion must be within [0, 999]");
        }
        for (int i = 6; i >= 4; --i) {
            int digit = dexVersion % 10;
            magic[i] = (byte)(48 + digit);
            dexVersion /= 10;
        }
        return magic;
    }

    public static boolean verifyMagic(byte[] buf, int offset) {
        int i;
        if (buf.length - offset < 8) {
            return false;
        }
        for (i = 0; i < 4; ++i) {
            if (buf[offset + i] == MAGIC_VALUE[i]) continue;
            return false;
        }
        for (i = 4; i < 7; ++i) {
            if (buf[offset + i] >= 48 && buf[offset + i] <= 57) continue;
            return false;
        }
        return buf[offset + 7] == MAGIC_VALUE[7];
    }

    public static int getVersion(byte[] buf, int offset) {
        if (!HeaderItem.verifyMagic(buf, offset)) {
            return -1;
        }
        return HeaderItem.getVersionUnchecked(buf, offset);
    }

    private static int getVersionUnchecked(byte[] buf, int offset) {
        int version = (buf[offset + 4] - 48) * 100;
        version += (buf[offset + 5] - 48) * 10;
        return version += buf[offset + 6] - 48;
    }

    public static boolean isSupportedDexVersion(int version) {
        return VersionMap.mapDexVersionToApi(version) != -1;
    }

    public static int getEndian(byte[] buf, int offset) {
        DexBuffer bdb = new DexBuffer(buf);
        return bdb.readInt(offset + 40);
    }
}

