/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SingleFloat;

public final class ftruncate
extends Primitive {
    private static final Primitive FTRUNCATE = new ftruncate();

    private ftruncate() {
        super("ftruncate", "number &optional divisor");
    }

    @Override
    public LispObject execute(LispObject arg) {
        float f;
        LispThread thread = LispThread.currentThread();
        if (arg.zerop()) {
            LispObject q = arg;
            LispObject r = arg instanceof DoubleFloat ? DoubleFloat.ZERO : SingleFloat.ZERO;
            return thread.setValues(q, r);
        }
        if (arg instanceof DoubleFloat) {
            double d = ((DoubleFloat)arg).value;
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                return thread.setValues(arg, new DoubleFloat(Double.NaN));
            }
        } else if (arg instanceof SingleFloat && (Float.isInfinite(f = ((SingleFloat)arg).value) || Float.isNaN(f))) {
            return thread.setValues(arg, new SingleFloat(Float.NaN));
        }
        LispObject q = arg.truncate(Fixnum.ONE);
        q = arg instanceof DoubleFloat ? (q.zerop() ? (arg.minusp() ? new DoubleFloat(-0.0) : new DoubleFloat(0.0)) : (q instanceof Fixnum ? new DoubleFloat(((Fixnum)q).value) : new DoubleFloat(((Bignum)q).doubleValue()))) : (q.zerop() ? (arg.minusp() ? new SingleFloat(-0.0f) : new SingleFloat(0.0f)) : (q instanceof Fixnum ? new SingleFloat(((Fixnum)q).value) : new SingleFloat(((Bignum)q).floatValue())));
        thread._values[0] = q;
        return q;
    }

    @Override
    public LispObject execute(LispObject first, LispObject second) {
        float f1;
        LispThread thread = LispThread.currentThread();
        if (first.zerop()) {
            LispObject q = first;
            LispObject r = first instanceof DoubleFloat ? DoubleFloat.ZERO : SingleFloat.ZERO;
            return thread.setValues(q, r);
        }
        if (first instanceof DoubleFloat) {
            double d1 = ((DoubleFloat)first).value;
            if (Double.isInfinite(d1) || Double.isNaN(d1)) {
                return thread.setValues(first, new DoubleFloat(Double.NaN));
            }
        } else if (first instanceof SingleFloat && (Float.isInfinite(f1 = ((SingleFloat)first).value) || Float.isNaN(f1))) {
            return thread.setValues(first, new SingleFloat(Float.NaN));
        }
        LispObject q = first.truncate(second);
        q = first instanceof DoubleFloat || second instanceof DoubleFloat ? (q.zerop() ? (first.minusp() ? (second.minusp() ? new DoubleFloat(0.0) : new DoubleFloat(-0.0)) : (second.minusp() ? new DoubleFloat(-0.0) : new DoubleFloat(0.0))) : (q instanceof Fixnum ? new DoubleFloat(((Fixnum)q).value) : new DoubleFloat(((Bignum)q).doubleValue()))) : (q.zerop() ? (first.minusp() ? (second.minusp() ? new SingleFloat(0.0f) : new SingleFloat(-0.0f)) : (second.minusp() ? new SingleFloat(-0.0f) : new SingleFloat(0.0f))) : (q instanceof Fixnum ? new SingleFloat(((Fixnum)q).value) : new SingleFloat(((Bignum)q).floatValue())));
        thread._values[0] = q;
        return q;
    }
}

