/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexArray;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class SimpleArray_T
extends AbstractArray {
    private final int[] dimv;
    private final LispObject elementType;
    private final int totalSize;
    final LispObject[] data;

    public SimpleArray_T(int[] dimv, LispObject elementType) {
        this.dimv = dimv;
        this.elementType = elementType;
        this.totalSize = SimpleArray_T.computeTotalSize(dimv);
        this.data = new LispObject[this.totalSize];
        int i = this.totalSize;
        while (i-- > 0) {
            this.data[i] = Fixnum.ZERO;
        }
    }

    public SimpleArray_T(int[] dimv, LispObject elementType, LispObject initialContents) {
        this.dimv = dimv;
        this.elementType = elementType;
        int rank = dimv.length;
        LispObject rest = initialContents;
        for (int i = 0; i < rank; ++i) {
            dimv[i] = rest.length();
            rest = rest.elt(0);
        }
        this.totalSize = SimpleArray_T.computeTotalSize(dimv);
        this.data = new LispObject[this.totalSize];
        this.setInitialContents(0, dimv, initialContents, 0);
    }

    public SimpleArray_T(int rank, LispObject initialContents) {
        if (rank < 2) {
            Debug.assertTrue(false);
        }
        this.dimv = new int[rank];
        this.elementType = Lisp.T;
        LispObject rest = initialContents;
        for (int i = 0; i < rank; ++i) {
            this.dimv[i] = rest.length();
            if (rest == Lisp.NIL || rest.length() == 0) break;
            rest = rest.elt(0);
        }
        this.totalSize = SimpleArray_T.computeTotalSize(this.dimv);
        this.data = new LispObject[this.totalSize];
        this.setInitialContents(0, this.dimv, initialContents, 0);
    }

    public SimpleArray_T(int[] dimv, LispObject[] initialData, LispObject elementType) {
        this.dimv = dimv;
        this.elementType = elementType;
        this.data = initialData;
        this.totalSize = SimpleArray_T.computeTotalSize(dimv);
    }

    private int setInitialContents(int axis, int[] dims, LispObject contents, int index) {
        if (dims.length == 0) {
            try {
                this.data[index] = contents;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Lisp.error(new LispError("Bad initial contents for array."));
                return -1;
            }
            ++index;
        } else {
            int i;
            int dim = dims[0];
            if (dim != contents.length()) {
                Lisp.error(new LispError("Bad initial contents for array."));
                return -1;
            }
            int[] newDims = new int[dims.length - 1];
            for (i = 1; i < dims.length; ++i) {
                newDims[i - 1] = dims[i];
            }
            if (contents.listp()) {
                i = contents.length();
                while (i-- > 0) {
                    LispObject content = contents.car();
                    index = this.setInitialContents(axis + 1, newDims, content, index);
                    contents = contents.cdr();
                }
            } else {
                AbstractVector v = Lisp.checkVector(contents);
                int length = v.length();
                for (int i2 = 0; i2 < length; ++i2) {
                    LispObject content = v.AREF(i2);
                    index = this.setInitialContents(axis + 1, newDims, content, index);
                }
            }
        }
        return index;
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_ARRAY, this.elementType, this.getDimensions());
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.SIMPLE_ARRAY;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    @Override
    public int getRank() {
        return this.dimv.length;
    }

    @Override
    public LispObject getDimensions() {
        LispObject result = Lisp.NIL;
        int i = this.dimv.length;
        while (i-- > 0) {
            result = new Cons(Fixnum.getInstance(this.dimv[i]), result);
        }
        return result;
    }

    @Override
    public int getDimension(int n) {
        try {
            return this.dimv[n];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Lisp.error(new TypeError("Bad array dimension " + n + "."));
            return -1;
        }
    }

    @Override
    public LispObject getElementType() {
        return this.elementType;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public LispObject AREF(int index) {
        try {
            return this.data[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Bad row major index " + index + "."));
        }
    }

    @Override
    public void aset(int index, LispObject newValue) {
        try {
            this.data[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Lisp.error(new TypeError("Bad row major index " + index + "."));
        }
    }

    @Override
    public int getRowMajorIndex(int[] subscripts) {
        int rank = this.dimv.length;
        if (rank != subscripts.length) {
            StringBuilder sb = new StringBuilder("Wrong number of subscripts (");
            sb.append(subscripts.length);
            sb.append(") for array of rank ");
            sb.append(rank);
            sb.append('.');
            Lisp.program_error(sb.toString());
        }
        int sum = 0;
        int size = 1;
        int i = rank;
        while (i-- > 0) {
            int dim = this.dimv[i];
            int lastSize = size;
            size *= dim;
            int n = subscripts[i];
            if (n < 0 || n >= dim) {
                StringBuilder sb = new StringBuilder("Invalid index ");
                sb.append(n);
                sb.append(" for array ");
                sb.append(this);
                sb.append('.');
                Lisp.program_error(sb.toString());
            }
            sum += n * lastSize;
        }
        return sum;
    }

    @Override
    public LispObject get(int[] subscripts) {
        try {
            return this.data[this.getRowMajorIndex(subscripts)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Bad row major index " + this.getRowMajorIndex(subscripts) + "."));
        }
    }

    @Override
    public void set(int[] subscripts, LispObject newValue) {
        try {
            this.data[this.getRowMajorIndex((int[])subscripts)] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Lisp.error(new TypeError("Bad row major index " + this.getRowMajorIndex(subscripts) + "."));
        }
    }

    @Override
    public void fill(LispObject obj) {
        int i = this.totalSize;
        while (i-- > 0) {
            this.data[i] = obj;
        }
    }

    @Override
    public String printObject() {
        return this.printObject(this.dimv);
    }

    @Override
    public AbstractArray adjustArray(int[] dimv, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            return new SimpleArray_T(dimv, this.elementType, initialContents);
        }
        for (int i = 0; i < dimv.length; ++i) {
            if (dimv[i] == this.dimv[i]) continue;
            SimpleArray_T newArray = new SimpleArray_T(dimv, this.elementType);
            if (initialElement != null) {
                newArray.fill(initialElement);
            }
            SimpleArray_T.copyArray(this, newArray);
            return newArray;
        }
        return new SimpleArray_T(dimv, (LispObject[])this.data.clone(), this.elementType);
    }

    static void copyArray(AbstractArray a1, AbstractArray a2) {
        Debug.assertTrue(a1.getRank() == a2.getRank());
        int[] subscripts = new int[a1.getRank()];
        int axis = 0;
        SimpleArray_T.copySubArray(a1, a2, subscripts, axis);
    }

    private static void copySubArray(AbstractArray a1, AbstractArray a2, int[] subscripts, int axis) {
        if (axis < subscripts.length) {
            int limit = Math.min(a1.getDimension(axis), a2.getDimension(axis));
            int i = 0;
            while (i < limit) {
                subscripts[axis] = i++;
                SimpleArray_T.copySubArray(a1, a2, subscripts, axis + 1);
            }
        } else {
            int i1 = a1.getRowMajorIndex(subscripts);
            int i2 = a2.getRowMajorIndex(subscripts);
            a2.aset(i2, a1.AREF(i1));
        }
    }

    @Override
    public AbstractArray adjustArray(int[] dimv, AbstractArray displacedTo, int displacement) {
        return new ComplexArray(dimv, displacedTo, displacement);
    }
}

