/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SimpleBitVector;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public abstract class AbstractBitVector
extends AbstractVector {
    protected static final int LONG_MASK = 63;
    protected int capacity;
    protected long[] bits;

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.BIT_VECTOR) {
            return Lisp.T;
        }
        if (type == BuiltInClass.BIT_VECTOR) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.BIT_VECTOR;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final LispObject getElementType() {
        return Symbol.BIT;
    }

    @Override
    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractBitVector) {
            AbstractBitVector v = (AbstractBitVector)obj;
            if (this.length() != v.length()) {
                return false;
            }
            int i = this.length();
            while (i-- > 0) {
                if (this.getBit(i) == v.getBit(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractBitVector) {
            AbstractBitVector v = (AbstractBitVector)obj;
            if (this.length() != v.length()) {
                return false;
            }
            int i = this.length();
            while (i-- > 0) {
                if (this.getBit(i) == v.getBit(i)) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof AbstractString) {
            return false;
        }
        if (obj instanceof AbstractVector) {
            return ((AbstractVector)obj).equalp(this);
        }
        return false;
    }

    @Override
    public void fill(LispObject obj) {
        if (obj instanceof Fixnum) {
            switch (((Fixnum)obj).value) {
                case 0: {
                    if (this.bits != null) {
                        int i = this.bits.length;
                        while (i-- > 0) {
                            this.bits[i] = 0L;
                        }
                    } else {
                        int i = this.capacity;
                        while (i-- > 0) {
                            this.clearBit(i);
                        }
                    }
                    return;
                }
                case 1: {
                    if (this.bits != null) {
                        int i = this.bits.length;
                        while (i-- > 0) {
                            this.bits[i] = -1L;
                        }
                    } else {
                        int i = this.capacity;
                        while (i-- > 0) {
                            this.setBit(i);
                        }
                    }
                    return;
                }
            }
        }
        Lisp.type_error(obj, Symbol.BIT);
    }

    @Override
    public LispObject subseq(int start, int end) {
        SimpleBitVector v = new SimpleBitVector(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                if (this.getBit(i++) == 0) {
                    v.clearBit(j++);
                    continue;
                }
                v.setBit(j++);
            }
            return v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Array index out of bounds: " + i + "."));
        }
    }

    public int hashCode() {
        int hashCode = 1;
        int limit = Math.min(this.length(), 64);
        for (int i = 0; i < limit; ++i) {
            hashCode = hashCode * 31 + this.getBit(i);
        }
        return hashCode;
    }

    @Override
    public String printObject() {
        LispThread thread = LispThread.currentThread();
        int length = this.length();
        if (Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL || Symbol.PRINT_ARRAY.symbolValue(thread) != Lisp.NIL) {
            StringBuilder sb = new StringBuilder(length + 2);
            sb.append("#*");
            for (int i = 0; i < length; ++i) {
                sb.append(this.getBit(i) == 1 ? (char)'1' : '0');
            }
            return sb.toString();
        }
        String str = "(%sBIT-VECTOR %d)";
        String pre = this instanceof SimpleBitVector ? "SIMPLE-" : "";
        return this.unreadableString(String.format("(%sBIT-VECTOR %d)", pre, length));
    }

    @Override
    public LispObject reverse() {
        int length = this.length();
        SimpleBitVector result = new SimpleBitVector(length);
        int i = 0;
        int j = length - 1;
        while (i < length) {
            if (this.getBit(j) == 1) {
                result.setBit(i);
            } else {
                result.clearBit(i);
            }
            ++i;
            --j;
        }
        return result;
    }

    protected abstract int getBit(int var1);

    protected abstract void setBit(int var1);

    protected abstract void clearBit(int var1);
}

