/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import de.rub.nds.tlsattacker.core.crypto.ec.FieldElement;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldElementF2m
extends FieldElement
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();

    public FieldElementF2m(BigInteger data, BigInteger modulus) {
        super(data, modulus);
    }

    private FieldElementF2m() {
        super(null, null);
    }

    @Override
    public FieldElement add(FieldElement f) {
        BigInteger tmp = this.getData().xor(f.getData());
        return new FieldElementF2m(tmp, this.getModulus());
    }

    @Override
    public FieldElement mult(FieldElement f) {
        BigInteger thisData = this.getData();
        BigInteger fData = f.getData();
        BigInteger tmp = new BigInteger("0");
        for (int i = 0; i < fData.bitLength(); ++i) {
            if (!fData.testBit(i)) continue;
            tmp = tmp.xor(thisData.shiftLeft(i));
        }
        tmp = this.reduce(tmp);
        return new FieldElementF2m(tmp, this.getModulus());
    }

    @Override
    public FieldElement addInv() {
        return this;
    }

    @Override
    public FieldElement multInv() {
        BigInteger r;
        if (this.getData().equals(BigInteger.ZERO)) {
            throw new ArithmeticException();
        }
        if (this.getData().equals(BigInteger.ONE)) {
            return this;
        }
        BigInteger r2 = this.getModulus();
        BigInteger r1 = this.getData();
        BigInteger t2 = new BigInteger("0");
        BigInteger t1 = BigInteger.ONE;
        do {
            BigInteger[] division = this.polynomialDivision(r2, r1);
            r = division[1];
            BigInteger q = division[0];
            FieldElementF2m t1Polynomial = new FieldElementF2m(t1, this.getModulus());
            FieldElementF2m qPolynomial = new FieldElementF2m(q, this.getModulus());
            BigInteger t = t1Polynomial.mult(qPolynomial).getData();
            t = this.reduce(t);
            t = t2.xor(t);
            t2 = t1;
            t1 = t;
            r2 = r1;
        } while (!(r1 = r).equals(BigInteger.ONE) && !r1.equals(BigInteger.ZERO));
        return new FieldElementF2m(t1, this.getModulus());
    }

    private BigInteger[] polynomialDivision(BigInteger f, BigInteger p) {
        int modLength = p.bitLength();
        BigInteger q = new BigInteger("0");
        while (f.bitLength() >= modLength && modLength != 0) {
            BigInteger tmp = new BigInteger("1");
            tmp = tmp.shiftLeft(f.bitLength() - modLength);
            q = q.xor(tmp);
            BigInteger shift = p.multiply(tmp);
            f = f.xor(shift);
        }
        BigInteger[] result = new BigInteger[]{q, f};
        return result;
    }

    private BigInteger reduce(BigInteger f) {
        return this.polynomialDivision(f, this.getModulus())[1];
    }
}

