/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.parser.DefaultPreserveAspectRatioHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGPreserveAspectRatio;

public abstract class AbstractSVGPreserveAspectRatio
implements SVGPreserveAspectRatio {
    protected short align = (short)6;
    protected short meetOrSlice = 1;

    public short getAlign() {
        return this.align;
    }

    public short getMeetOrSlice() {
        return this.meetOrSlice;
    }

    public void setAlign(short s) {
        this.align = s;
        this.setAttributeValue(this.getValueAsString());
    }

    public void setMeetOrSlice(short s) {
        this.meetOrSlice = s;
        this.setAttributeValue(this.getValueAsString());
    }

    public void reset() {
        this.align = (short)6;
        this.meetOrSlice = 1;
    }

    protected abstract void setAttributeValue(String var1) throws DOMException;

    protected abstract DOMException createDOMException(short var1, String var2, Object[] var3);

    protected void setValueAsString(String string) throws DOMException {
        PreserveAspectRatioParserHandler preserveAspectRatioParserHandler = new PreserveAspectRatioParserHandler();
        try {
            PreserveAspectRatioParser preserveAspectRatioParser = new PreserveAspectRatioParser();
            preserveAspectRatioParser.setPreserveAspectRatioHandler(preserveAspectRatioParserHandler);
            preserveAspectRatioParser.parse(string);
            this.align = preserveAspectRatioParserHandler.getAlign();
            this.meetOrSlice = preserveAspectRatioParserHandler.getMeetOrSlice();
        }
        catch (ParseException parseException) {
            throw this.createDOMException((short)0, "invalid value for preserveAspectRatio", null);
        }
    }

    protected String getValueAsString() {
        String string = null;
        switch (this.align) {
            case 1: {
                string = "none";
                return string;
            }
            case 2: {
                string = "xMinYMin";
                break;
            }
            case 3: {
                string = "xMidYMin";
                break;
            }
            case 4: {
                string = "xMaxYMin";
                break;
            }
            case 5: {
                string = "xMinYMid";
                break;
            }
            case 6: {
                string = "xMidYMid";
                break;
            }
            case 7: {
                string = "xMaxYMid";
                break;
            }
            case 8: {
                string = "xMinYMax";
                break;
            }
            case 9: {
                string = "xMidYMax";
                break;
            }
            case 10: {
                string = "xMaxYMax";
                break;
            }
            default: {
                throw this.createDOMException((short)0, "invalid value for preserveAspectRatio", null);
            }
        }
        switch (this.meetOrSlice) {
            case 1: {
                string = string + " " + "meet";
                break;
            }
            case 2: {
                string = string + " " + "slice";
                break;
            }
            default: {
                throw this.createDOMException((short)0, "invalid value for preserveAspectRatio", null);
            }
        }
        return string;
    }

    protected class PreserveAspectRatioParserHandler
    extends DefaultPreserveAspectRatioHandler {
        public short align = (short)6;
        public short meetOrSlice = 1;

        protected PreserveAspectRatioParserHandler() {
        }

        public short getAlign() {
            return this.align;
        }

        public short getMeetOrSlice() {
            return this.meetOrSlice;
        }

        public void none() throws ParseException {
            this.align = 1;
        }

        public void xMaxYMax() throws ParseException {
            this.align = (short)10;
        }

        public void xMaxYMid() throws ParseException {
            this.align = (short)7;
        }

        public void xMaxYMin() throws ParseException {
            this.align = (short)4;
        }

        public void xMidYMax() throws ParseException {
            this.align = (short)9;
        }

        public void xMidYMid() throws ParseException {
            this.align = (short)6;
        }

        public void xMidYMin() throws ParseException {
            this.align = (short)3;
        }

        public void xMinYMax() throws ParseException {
            this.align = (short)8;
        }

        public void xMinYMid() throws ParseException {
            this.align = (short)5;
        }

        public void xMinYMin() throws ParseException {
            this.align = (short)2;
        }

        public void meet() throws ParseException {
            this.meetOrSlice = 1;
        }

        public void slice() throws ParseException {
            this.meetOrSlice = (short)2;
        }
    }
}

