/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/resolve/AbstractNativeAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "requiredAnnotation", "Lorg/jetbrains/kotlin/js/PredefinedAnnotation;", "(Lorg/jetbrains/kotlin/js/PredefinedAnnotation;)V", "additionalCheck", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "check", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
public abstract class AbstractNativeAnnotationsChecker
implements DeclarationChecker {
    @NotNull
    private final PredefinedAnnotation requiredAnnotation;

    public AbstractNativeAnnotationsChecker(@NotNull PredefinedAnnotation requiredAnnotation) {
        Intrinsics.checkNotNullParameter((Object)((Object)requiredAnnotation), (String)"requiredAnnotation");
        this.requiredAnnotation = requiredAnnotation;
    }

    public void additionalCheck(@NotNull KtNamedFunction declaration, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(this.requiredAnnotation.getFqName());
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        if (!(declaration instanceof KtNamedFunction) || !(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        boolean isMember = !DescriptorUtils.isTopLevelDeclaration(descriptor2) && !Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getVisibility(), (Object)DescriptorVisibilities.LOCAL);
        boolean isExtension = DescriptorUtils.isExtension((CallableDescriptor)descriptor2);
        if (isMember && (isExtension || !AnnotationsUtils.isNativeObject(descriptor2)) || !isMember && !isExtension) {
            context.getTrace().report(ErrorsJs.NATIVE_ANNOTATIONS_ALLOWED_ONLY_ON_MEMBER_OR_EXTENSION_FUN.on((KtElement)((PsiElement)declaration), annotationDescriptor2.getType()));
        }
        this.additionalCheck((KtNamedFunction)declaration, (FunctionDescriptor)descriptor2, context.getTrace());
    }
}

