/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.DataConverter;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Command;
import org.traccar.protocol.HuabaoProtocolDecoder;

public class HuabaoProtocolEncoder
extends BaseProtocolEncoder {
    public HuabaoProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object encodeCommand(Command command) {
        boolean alternative = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_ALTERNATIVE.withPrefix(this.getProtocolName()), command.getDeviceId());
        ByteBuf id = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(this.getUniqueId(command.getDeviceId())));
        try {
            ByteBuf data = Unpooled.buffer();
            byte[] time = DataConverter.parseHex(new SimpleDateFormat("yyMMddHHmmss").format(new Date()));
            switch (command.getType()) {
                case "custom": {
                    data.writeByte(1);
                    Charset charset = Charset.isSupported("GBK") ? Charset.forName("GBK") : StandardCharsets.US_ASCII;
                    data.writeCharSequence((CharSequence)command.getString("data"), charset);
                    ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 33536, id, false, data);
                    return byteBuf;
                }
                case "rebootDevice": {
                    data.writeByte(1);
                    data.writeByte(35);
                    data.writeByte(1);
                    data.writeByte(3);
                    ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 784, id, false, data);
                    return byteBuf;
                }
                case "positionPeriodic": {
                    data.writeByte(1);
                    data.writeByte(6);
                    data.writeByte(4);
                    data.writeInt(command.getInteger("frequency"));
                    ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 784, id, false, data);
                    return byteBuf;
                }
                case "alarmArm": 
                case "alarmDisarm": {
                    data.writeByte(1);
                    data.writeByte(36);
                    String username = "user";
                    data.writeByte(1 + username.length());
                    data.writeByte(command.getType().equals("alarmArm") ? 1 : 0);
                    data.writeCharSequence((CharSequence)username, StandardCharsets.US_ASCII);
                    ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 784, id, false, data);
                    return byteBuf;
                }
                case "engineStop": 
                case "engineResume": {
                    if (alternative) {
                        data.writeByte(command.getType().equals("engineStop") ? 1 : 0);
                        data.writeBytes(time);
                        ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 40966, id, false, data);
                        return byteBuf;
                    }
                    data.writeByte(command.getType().equals("engineStop") ? 240 : 241);
                    ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 33029, id, false, data);
                    return byteBuf;
                }
            }
            Object var10_16 = null;
            return var10_16;
        }
        finally {
            id.release();
        }
    }
}

