/*
 * Decompiled with CFR 0.152.
 */
package tr.view.collect;

import au.com.trgtd.tr.appl.InitialAction;
import java.awt.EventQueue;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.collect.screen.CollectThoughtsTopComponent;

public class CollectThoughtsAction
extends CallableSystemAction
implements InitialAction {
    public CollectThoughtsAction() {
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                CollectThoughtsAction.this.enableDisable();
            }
        });
    }

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/Collect.png";
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_CollectThoughtsAction");
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public String getID() {
        return "CollectThoughts";
    }

    public void performAction() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Data data = (Data)DataLookup.instance().lookup(Data.class);
                if (data == null) {
                    return;
                }
                WindowUtils.closeWindows();
                CollectThoughtsTopComponent tc = CollectThoughtsTopComponent.findInstance();
                Mode mode = WindowManager.getDefault().findMode("CollectThoughts");
                if (mode != null) {
                    mode.dockInto((TopComponent)tc);
                }
                tc.open();
                tc.requestActive();
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.collect");
    }
}

