/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipreader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.zipreader.ZipReadContentLocation;
import org.pentaho.reporting.libraries.repository.zipreader.ZipReadRepository;

public class ZipReadContentItem
implements ContentItem {
    private String comment;
    private String name;
    private long size;
    private long time;
    private ZipReadRepository repository;
    private byte[] rawData;
    private ZipReadContentLocation parent;
    private String entryName;

    public ZipReadContentItem(ZipReadRepository repository, ZipReadContentLocation parent, ZipEntry zipEntry, byte[] bytes) {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        if (bytes == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.repository = repository;
        this.comment = zipEntry.getComment();
        this.name = zipEntry.getName();
        this.entryName = IOUtils.getInstance().getFileName(this.name);
        this.size = zipEntry.getSize();
        this.time = zipEntry.getTime();
        this.rawData = bytes;
    }

    @Override
    public String getMimeType() throws ContentIOException {
        return this.repository.getMimeRegistry().getMimeType(this);
    }

    @Override
    public OutputStream getOutputStream() throws ContentIOException, IOException {
        throw new ContentCreationException("This repository is read-only");
    }

    @Override
    public InputStream getInputStream() throws ContentIOException, IOException {
        return new InflaterInputStream(new ByteArrayInputStream(this.rawData));
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWriteable() {
        return false;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public Object getContentId() {
        return this.name;
    }

    @Override
    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("size".equals(key)) {
                return new Long(this.size);
            }
            if ("version".equals(key)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(domain) && "comment".equals(key)) {
            return this.comment;
        }
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        return false;
    }
}

