/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.email.freemarker.beans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.forms.login.freemarker.model.OrganizationBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.userprofile.UserProfileProvider;

public class ProfileBean {
    private static final Logger logger = Logger.getLogger(ProfileBean.class);
    private UserModel user;
    private final KeycloakSession session;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private List<OrganizationBean> organizations;

    public ProfileBean(UserModel user, KeycloakSession session) {
        this.user = user;
        this.session = session;
        if (user.getAttributes() != null) {
            UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
            UPConfig configuration = provider.getConfiguration();
            for (Map.Entry attr : user.getAttributes().entrySet()) {
                UPAttribute attribute;
                boolean multivalued;
                List attrValue = (List)attr.getValue();
                if (attrValue != null && attrValue.size() > 0) {
                    this.attributes.put((String)attr.getKey(), (String)attrValue.get(0));
                }
                if ((multivalued = (attribute = configuration.getAttribute((String)attr.getKey())) != null && attribute.isMultivalued()) || attrValue == null || attrValue.size() <= 1) continue;
                logger.warnf("There are more values for attribute '%s' of user '%s' . Will display just first value", attr.getKey(), (Object)user.getUsername());
            }
        }
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<OrganizationBean> getOrganizations() {
        if (this.organizations == null) {
            this.organizations = ((OrganizationProvider)this.session.getProvider(OrganizationProvider.class)).getByMember(this.user).map(o -> new OrganizationBean((OrganizationModel)o, this.user)).toList();
        }
        return this.organizations;
    }
}

