/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.marshalling;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;

public class KeycloakIndexSchemaUtil {
    private static final String BASIC_ANNOTATION = "Basic";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SEARCHABLE_ATTRIBUTE = "searchable";
    private static final String PROJECTABLE_ATTRIBUTE = "projectable";
    private static final String AGGREGABLE_ATTRIBUTE = "aggregable";
    private static final String SORTABLE_ATTRIBUTE = "sortable";
    private static final String INDEX_NULL_AS_ATTRIBUTE = "indexNullAs";
    private static final List<String> INDEX_ANNOTATION = List.of("Basic");

    public static void configureAnnotationProcessor(Configuration.Builder builder) {
        builder.annotationsConfig().annotation(BASIC_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.FIELD}).attribute(NAME_ATTRIBUTE).type(AnnotationElement.AttributeType.STRING).defaultValue((Object)"").attribute(SEARCHABLE_ATTRIBUTE).type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)true).attribute(PROJECTABLE_ATTRIBUTE).type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)false).attribute(AGGREGABLE_ATTRIBUTE).type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)false).attribute(SORTABLE_ATTRIBUTE).type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)false).attribute(INDEX_NULL_AS_ATTRIBUTE).type(AnnotationElement.AttributeType.STRING).defaultValue((Object)"__Infinispan_indexNullAs_doNotIndexNull");
    }

    public static boolean isIndexSchemaChanged(Descriptor oldDescriptor, Descriptor newDescriptor) {
        Set allFields = Stream.concat(oldDescriptor.getFields().stream().map(AnnotatedDescriptorImpl::getName), newDescriptor.getFields().stream().map(AnnotatedDescriptorImpl::getName)).collect(Collectors.toSet());
        for (String fieldName : allFields) {
            FieldDescriptor newField;
            FieldDescriptor oldField = oldDescriptor.findFieldByName(fieldName);
            if (KeycloakIndexSchemaUtil.isNewFieldAdded(oldField, newField = newDescriptor.findFieldByName(fieldName))) {
                if (!KeycloakIndexSchemaUtil.isFieldIndexed(newField)) continue;
                return true;
            }
            if (KeycloakIndexSchemaUtil.isNewFieldRemoved(oldField, newField)) {
                if (!KeycloakIndexSchemaUtil.isFieldIndexed(oldField)) continue;
                return true;
            }
            if (KeycloakIndexSchemaUtil.isFieldIndexed(oldField) != KeycloakIndexSchemaUtil.isFieldIndexed(newField)) {
                return true;
            }
            if (!KeycloakIndexSchemaUtil.isFieldIndexed(oldField) && !KeycloakIndexSchemaUtil.isFieldIndexed(newField) || !KeycloakIndexSchemaUtil.isAnnotationChanged(oldField, newField)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNewFieldAdded(FieldDescriptor oldField, FieldDescriptor newField) {
        return oldField == null && newField != null;
    }

    private static boolean isNewFieldRemoved(FieldDescriptor oldField, FieldDescriptor newField) {
        return oldField != null && newField == null;
    }

    private static boolean isFieldIndexed(FieldDescriptor descriptor) {
        Map annotations = descriptor.getAnnotations();
        return INDEX_ANNOTATION.stream().anyMatch(annotations::containsKey);
    }

    private static boolean isAnnotationChanged(FieldDescriptor oldField, FieldDescriptor newField) {
        return INDEX_ANNOTATION.stream().anyMatch(s -> {
            AnnotationElement.Annotation oldAnnot = (AnnotationElement.Annotation)oldField.getAnnotations().get(s);
            AnnotationElement.Annotation newAnnot = (AnnotationElement.Annotation)newField.getAnnotations().get(s);
            return KeycloakIndexSchemaUtil.isAnnotatedDifferent(oldAnnot, newAnnot);
        });
    }

    private static boolean isAnnotatedDifferent(AnnotationElement.Annotation oldAnnot, AnnotationElement.Annotation newAnnot) {
        if (oldAnnot == null && newAnnot == null) {
            return false;
        }
        if (oldAnnot != null && newAnnot == null) {
            return true;
        }
        if (oldAnnot == null) {
            return true;
        }
        return !Objects.equals(KeycloakIndexSchemaUtil.getAnnotationValues(oldAnnot), KeycloakIndexSchemaUtil.getAnnotationValues(newAnnot));
    }

    private static Map<String, Object> getAnnotationValues(AnnotationElement.Annotation annotation) {
        return annotation.getAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AnnotationElement.Attribute)e.getValue()).getValue().getValue()));
    }
}

