/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.type;

import io.quarkus.deployment.configuration.type.ConverterType;
import java.lang.reflect.Array;
import java.util.Objects;

public final class ArrayOf
extends ConverterType {
    private final ConverterType type;
    private int hashCode;
    private Class<?> arrayType;

    public ArrayOf(ConverterType type) {
        this.type = type;
    }

    public ConverterType getElementType() {
        return this.type;
    }

    @Override
    public Class<?> getLeafType() {
        return this.type.getLeafType();
    }

    public Class<?> getArrayType() {
        Class<?> arrayType = this.arrayType;
        if (arrayType == null) {
            this.arrayType = arrayType = Array.newInstance(this.getLeafType(), 0).getClass();
        }
        return arrayType;
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = Objects.hash(this.type, ArrayOf.class);
            if (hashCode == 0) {
                hashCode = Integer.MIN_VALUE;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof ArrayOf && this.equals((ArrayOf)obj);
    }

    public boolean equals(ArrayOf obj) {
        return this == obj || obj != null && this.type.equals(obj.type);
    }
}

