/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.stringio;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.ObjectFlags;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.func.ObjectObjectIntFunction;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.Getline;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"StringIO"})
public class StringIO
extends RubyObject
implements EncodingCapable,
DataType {
    StringIOData ptr;
    private static final String STRINGIO_VERSION = "3.1.2";
    private static final int STRIO_READABLE;
    private static final int STRIO_WRITABLE;
    private static final int STRIO_READWRITE;
    private static final AtomicReferenceFieldUpdater<StringIOData, Object> LOCKED_UPDATER;
    private static final ThreadLocal<Object> VMODE_VPERM_TL;
    private static final ThreadLocal<int[]> FMODE_TL;
    private static final int[] OFLAGS_UNUSED;
    private static final int CHAR_BIT = 8;
    private static final Getline.Callback<StringIO, IRubyObject> GETLINE;
    private static final Getline.Callback<StringIO, StringIO> GETLINE_YIELD;
    private static final Getline.Callback<StringIO, RubyArray<IRubyObject>> GETLINE_ARY;
    public static final ByteList NEWLINE;
    private static final MethodHandle CAT_WITH_CODE_RANGE;
    private static final MethodHandle MODIFY_AND_CLEAR_CODE_RANGE;
    private static final MethodHandle SUBSTR_ENC;

    public static RubyClass createStringIOClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("StringIO", ruby.getObject(), StringIO::new);
        RubyString rubyString = RubyString.newString((Ruby)ruby, (String)STRINGIO_VERSION);
        rubyClass.defineConstant("VERSION", (IRubyObject)rubyString);
        rubyClass.defineConstant("MAX_LENGTH", (IRubyObject)RubyNumeric.int2fix((Ruby)ruby, (long)Integer.MAX_VALUE));
        rubyClass.defineAnnotatedMethods(StringIO.class);
        rubyClass.includeModule((IRubyObject)ruby.getEnumerable());
        if (ruby.getObject().isConstantDefined("Java")) {
            rubyClass.defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        RubyModule rubyModule = ruby.getIO().defineOrGetModuleUnder("GenericReadable");
        rubyModule.defineAnnotatedMethods(GenericReadable.class);
        rubyClass.includeModule((IRubyObject)rubyModule);
        RubyModule rubyModule2 = ruby.getIO().defineOrGetModuleUnder("GenericWritable");
        rubyModule2.defineAnnotatedMethods(GenericWritable.class);
        rubyClass.includeModule((IRubyObject)rubyModule2);
        return rubyClass;
    }

    public Encoding getEncoding() {
        StringIOData stringIOData = this.ptr;
        Encoding encoding = stringIOData.enc;
        return encoding != null ? encoding : stringIOData.string.getEncoding();
    }

    public void setEncoding(Encoding encoding) {
        this.ptr.enc = encoding;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        StringIO.warnIfBlock(threadContext, block, rubyClass);
        return rubyClass.newInstance(threadContext, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        StringIO.warnIfBlock(threadContext, block, rubyClass);
        return rubyClass.newInstance(threadContext, block);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        StringIO.warnIfBlock(threadContext, block, rubyClass);
        return rubyClass.newInstance(threadContext, iRubyObject2, block);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        StringIO.warnIfBlock(threadContext, block, rubyClass);
        return rubyClass.newInstance(threadContext, iRubyObject2, iRubyObject3, block);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        StringIO.warnIfBlock(threadContext, block, rubyClass);
        return rubyClass.newInstance(threadContext, iRubyObject2, iRubyObject3, iRubyObject4, block);
    }

    private static void warnIfBlock(ThreadContext threadContext, Block block, RubyClass rubyClass) {
        if (block.isGiven()) {
            Ruby ruby = threadContext.runtime;
            RubyString rubyString = RubyStringBuilder.types((Ruby)ruby, (RubyModule)rubyClass);
            ruby.getWarnings().warn(IRubyWarnings.ID.BLOCK_NOT_ACCEPTED, RubyStringBuilder.str((Ruby)ruby, (IRubyObject)rubyString, (String)"::new() does not take block; use ", (IRubyObject)rubyString, (String)"::open() instead"));
        }
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        StringIO stringIO = (StringIO)((RubyClass)iRubyObject).newInstance(threadContext, iRubyObjectArray, Block.NULL_BLOCK);
        return StringIO.yieldOrReturn(threadContext, block, stringIO);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        StringIO stringIO = (StringIO)((RubyClass)iRubyObject).newInstance(threadContext, Block.NULL_BLOCK);
        return StringIO.yieldOrReturn(threadContext, block, stringIO);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        StringIO stringIO = (StringIO)((RubyClass)iRubyObject).newInstance(threadContext, iRubyObject2, Block.NULL_BLOCK);
        return StringIO.yieldOrReturn(threadContext, block, stringIO);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        StringIO stringIO = (StringIO)((RubyClass)iRubyObject).newInstance(threadContext, iRubyObject2, iRubyObject3, Block.NULL_BLOCK);
        return StringIO.yieldOrReturn(threadContext, block, stringIO);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
        StringIO stringIO = (StringIO)((RubyClass)iRubyObject).newInstance(threadContext, iRubyObject2, iRubyObject3, iRubyObject4, Block.NULL_BLOCK);
        return StringIO.yieldOrReturn(threadContext, block, stringIO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject yieldOrReturn(ThreadContext threadContext, Block block, StringIO stringIO) {
        StringIO stringIO2 = stringIO;
        if (block.isGiven()) {
            try {
                stringIO2 = block.yield(threadContext, (IRubyObject)stringIO);
            }
            finally {
                stringIO.ptr.string = null;
                stringIO.flags &= ~STRIO_READWRITE;
            }
        }
        return stringIO2;
    }

    protected StringIO(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext) {
        if (this.ptr == null) {
            this.ptr = new StringIOData();
        }
        this.strioInit(threadContext, 0, null, null);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.ptr == null) {
            this.ptr = new StringIOData();
        }
        this.strioInit(threadContext, 1, iRubyObject, null);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (this.ptr == null) {
            this.ptr = new StringIOData();
        }
        this.strioInit(threadContext, 2, iRubyObject, iRubyObject2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strioInit(ThreadContext threadContext, int n, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.runtime;
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            RubyString rubyString;
            Object object;
            IRubyObject iRubyObject3 = threadContext.nil;
            switch (n) {
                case 1: {
                    iRubyObject3 = iRubyObject;
                    break;
                }
                case 2: {
                    iRubyObject3 = iRubyObject2;
                }
            }
            Encoding encoding = null;
            IRubyObject iRubyObject4 = ArgsUtil.getOptionsArg((Ruby)ruby, (IRubyObject)iRubyObject3);
            IOEncodable.ConvConfig convConfig = new IOEncodable.ConvConfig();
            if (!iRubyObject4.isNil()) {
                --n;
                int[] nArray = new int[]{0};
                object = VMODE_VPERM_TL.get();
                EncodingUtils.extractModeEncoding((ThreadContext)threadContext, (IOEncodable)convConfig, (Object)object, (IRubyObject)iRubyObject4, (int[])OFLAGS_UNUSED, (int[])FMODE_TL.get());
                EncodingUtils.vmode((Object)object, null);
                EncodingUtils.vperm((Object)object, null);
                stringIOData.flags = nArray[0];
                encoding = convConfig.enc;
            }
            switch (n) {
                case 2: {
                    boolean bl2;
                    IRubyObject iRubyObject5 = iRubyObject2;
                    if (iRubyObject5 instanceof RubyFixnum) {
                        int n2 = RubyFixnum.fix2int((IRubyObject)iRubyObject5);
                        stringIOData.flags |= ModeFlags.getOpenFileFlagsFor((int)n2);
                        bl2 = (n2 & ModeFlags.TRUNC) != 0;
                    } else {
                        object = iRubyObject2.convertToString().toString();
                        stringIOData.flags |= OpenFile.ioModestrFmode((Ruby)ruby, (String)object);
                        bl2 = ((String)object).length() > 0 && ((String)object).charAt(0) == 'w';
                    }
                    rubyString = iRubyObject.convertToString();
                    if ((stringIOData.flags & 2) != 0 && rubyString.isFrozen()) {
                        throw ruby.newErrnoEACCESError("Permission denied");
                    }
                    if (!bl2) break;
                    rubyString.resize(0);
                    break;
                }
                case 1: {
                    rubyString = iRubyObject.convertToString();
                    stringIOData.flags = stringIOData.flags | (rubyString.isFrozen() ? 1 : 3);
                    break;
                }
                case 0: {
                    rubyString = RubyString.newEmptyString((Ruby)ruby, (Encoding)ruby.getDefaultExternalEncoding());
                    stringIOData.flags |= 3;
                    break;
                }
                default: {
                    throw ruby.newArgumentError(3, 2);
                }
            }
            stringIOData.string = rubyString;
            stringIOData.enc = encoding;
            stringIOData.pos = 0;
            stringIOData.lineno = 0;
            if ((stringIOData.flags & 0x100000) != 0) {
                this.setEncodingByBOM(threadContext);
            }
            this.flags |= (stringIOData.flags & 3) * (STRIO_READABLE / 1);
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext threadContext, IRubyObject iRubyObject) {
        StringIO stringIO = (StringIO)TypeConverter.convertToType((IRubyObject)iRubyObject, (RubyClass)threadContext.runtime.getClass("StringIO"), (String)"to_strio");
        if (this == stringIO) {
            return this;
        }
        this.ptr = stringIO.ptr;
        this.flags = this.flags & ~STRIO_READWRITE | stringIO.flags & STRIO_READWRITE;
        return this;
    }

    @JRubyMethod
    public IRubyObject binmode(ThreadContext threadContext) {
        StringIOData stringIOData = this.ptr;
        stringIOData.enc = EncodingUtils.ascii8bitEncoding((Ruby)threadContext.runtime);
        if (this.writable()) {
            stringIOData.string.setEncoding(stringIOData.enc);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject strio_self() {
        return this;
    }

    @JRubyMethod(name={"fcntl"}, rest=true, notImplemented=true)
    public IRubyObject strio_unimpl(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        throw threadContext.runtime.newNotImplementedError("");
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject strioZero(ThreadContext threadContext) {
        return RubyFixnum.zero((Ruby)threadContext.runtime);
    }

    @JRubyMethod(name={"sync="})
    public IRubyObject strioFirst(IRubyObject iRubyObject) {
        this.checkInitialized();
        return iRubyObject;
    }

    @JRubyMethod(name={"isatty", "tty?"})
    public IRubyObject strioFalse(ThreadContext threadContext) {
        return threadContext.fals;
    }

    @JRubyMethod(name={"pid", "fileno"})
    public IRubyObject strioNil(ThreadContext threadContext) {
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext threadContext) {
        this.checkInitialized();
        if (this.closed()) {
            return threadContext.nil;
        }
        this.flags &= ~STRIO_READWRITE;
        return threadContext.nil;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closed());
    }

    @JRubyMethod
    public IRubyObject close_read(ThreadContext threadContext) {
        this.checkInitialized();
        if ((this.ptr.flags & 1) == 0) {
            throw threadContext.runtime.newIOError("not opened for reading");
        }
        int n = this.flags;
        if ((n & STRIO_READABLE) != 0) {
            this.flags = n & ~STRIO_READABLE;
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(!this.readable());
    }

    @JRubyMethod
    public IRubyObject close_write(ThreadContext threadContext) {
        this.checkInitialized();
        if ((this.ptr.flags & 2) == 0) {
            throw threadContext.runtime.newIOError("not opened for writing");
        }
        int n = this.flags;
        if ((n & STRIO_WRITABLE) != 0) {
            this.flags = n & ~STRIO_WRITABLE;
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(!this.writable());
    }

    @JRubyMethod(name={"each"}, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext threadContext, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each");
        }
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_YIELD, (Object)((Object)this), (Encoding)this.getEncoding(), (int)0, null, null, null, (Block)block);
    }

    @JRubyMethod(name={"each"}, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each", (IRubyObject)iRubyObject);
        }
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_YIELD, (Object)((Object)this), (Encoding)this.getEncoding(), (int)1, (IRubyObject)iRubyObject, null, null, (Block)block);
    }

    @JRubyMethod(name={"each"}, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each", (IRubyObject[])Helpers.arrayOf((IRubyObject)iRubyObject, (IRubyObject)iRubyObject2));
        }
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_YIELD, (Object)((Object)this), (Encoding)this.getEncoding(), (int)2, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, null, (Block)block);
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each", (IRubyObject[])Helpers.arrayOf((IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3));
        }
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_YIELD, (Object)((Object)this), (Encoding)this.getEncoding(), (int)3, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3, (Block)block);
    }

    public IRubyObject each(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each", (IRubyObject[])iRubyObjectArray);
        }
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.each(threadContext, block);
            }
            case 1: {
                return this.each(threadContext, iRubyObjectArray[0], block);
            }
            case 2: {
                return this.each(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], block);
            }
            case 3: {
                return this.each(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2], block);
            }
        }
        Arity.raiseArgumentError((ThreadContext)threadContext, (int)iRubyObjectArray.length, (int)0, (int)3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext threadContext, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line");
        }
        return this.each(threadContext, block);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line", (IRubyObject)iRubyObject);
        }
        return this.each(threadContext, iRubyObject, block);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line", (IRubyObject[])new IRubyObject[]{iRubyObject, iRubyObject2});
        }
        return this.each(threadContext, iRubyObject, iRubyObject2, block);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line", (IRubyObject[])new IRubyObject[]{iRubyObject, iRubyObject2, iRubyObject3});
        }
        return this.each(threadContext, iRubyObject, iRubyObject2, iRubyObject3, block);
    }

    public IRubyObject each_line(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line", (IRubyObject[])iRubyObjectArray);
        }
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.each_line(threadContext, block);
            }
            case 1: {
                return this.each_line(threadContext, iRubyObjectArray[0], block);
            }
            case 2: {
                return this.each_line(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], block);
            }
            case 3: {
                return this.each_line(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2], block);
            }
        }
        Arity.raiseArgumentError((ThreadContext)threadContext, (int)iRubyObjectArray.length, (int)0, (int)3);
        throw new AssertionError((Object)"BUG");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"each_byte"})
    public IRubyObject each_byte(ThreadContext threadContext, Block block) {
        Ruby ruby = threadContext.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)ruby, (IRubyObject)this, (String)"each_byte");
        }
        this.checkReadable();
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            ByteList byteList = stringIOData.string.getByteList();
            while (stringIOData.pos < byteList.length()) {
                block.yield(threadContext, (IRubyObject)ruby.newFixnum(byteList.get(stringIOData.pos++) & 0xFF));
            }
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_char(ThreadContext threadContext, Block block) {
        IRubyObject iRubyObject;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_char");
        }
        while (!(iRubyObject = this.getc(threadContext)).isNil()) {
            block.yieldSpecific(threadContext, iRubyObject);
        }
        return this;
    }

    @JRubyMethod(name={"eof", "eof?"})
    public IRubyObject eof(ThreadContext threadContext) {
        this.checkReadable();
        if (this.ptr.pos < this.ptr.string.size()) {
            return threadContext.fals;
        }
        return threadContext.tru;
    }

    private boolean isEndOfString() {
        return this.ptr.pos >= this.ptr.string.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"getc"})
    public IRubyObject getc(ThreadContext threadContext) {
        this.checkReadable();
        if (this.isEndOfString()) {
            return threadContext.nil;
        }
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            int n = stringIOData.pos;
            RubyString rubyString = stringIOData.string;
            int n2 = 1 + StringSupport.bytesToFixBrokenTrailingCharacter((ByteList)rubyString.getByteList(), (int)(n + 1));
            stringIOData.pos += n2;
            RubyString rubyString2 = threadContext.runtime.newString(rubyString.getByteList().makeShared(n, n2));
            return rubyString2;
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext threadContext) {
        int n;
        this.checkReadable();
        if (this.isEndOfString()) {
            return threadContext.nil;
        }
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            n = stringIOData.string.getByteList().get(stringIOData.pos++) & 0xFF;
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
        return threadContext.runtime.newFixnum(n);
    }

    private RubyString strioSubstr(Ruby ruby, int n, int n2, Encoding encoding) {
        StringIOData stringIOData = this.ptr;
        RubyString rubyString = stringIOData.string;
        ByteList byteList = rubyString.getByteList();
        int n3 = rubyString.size() - n;
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 == 0) {
            return RubyString.newEmptyString((Ruby)ruby, (Encoding)encoding);
        }
        rubyString.setByteListShared();
        return RubyString.newStringShared((Ruby)ruby, (byte[])byteList.getUnsafeBytes(), (int)(byteList.getBegin() + n), (int)n2, (Encoding)encoding);
    }

    private static void bm_init_skip(int[] nArray, byte[] byArray, int n, int n2) {
        for (int i = 0; i < 256; ++i) {
            nArray[i] = n2;
        }
        while (--n2 > 0) {
            nArray[byArray[n++]] = n2;
        }
    }

    private static int bm_search(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int[] nArray) {
        for (int i = n2 - 1; i < n4; i += nArray[byArray2[i + n3] & 0xFF]) {
            int n5;
            int n6 = i;
            for (n5 = n2 - 1; n5 >= 0 && byArray2[n6 + n3] == byArray[n5 + n]; --n5) {
                --n6;
            }
            if (n5 >= 0) continue;
            return n6 + 1;
        }
        return -1;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext threadContext) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE, (Object)((Object)this), (Encoding)this.getEncoding());
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext threadContext, IRubyObject iRubyObject) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject);
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2);
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3);
    }

    public IRubyObject gets(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.gets(threadContext);
            }
            case 1: {
                return this.gets(threadContext, iRubyObjectArray[0]);
            }
            case 2: {
                return this.gets(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
            case 3: {
                return this.gets(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
            }
        }
        Arity.raiseArgumentError((ThreadContext)threadContext, (int)iRubyObjectArray.length, (int)0, (int)3);
        throw new AssertionError((Object)"BUG");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject getline(ThreadContext threadContext, IRubyObject iRubyObject, int n, boolean bl) {
        RubyString rubyString;
        Ruby ruby = threadContext.runtime;
        this.checkReadable();
        if (this.isEndOfString()) {
            return threadContext.nil;
        }
        StringIOData stringIOData = this.ptr;
        Encoding encoding = this.getEncoding();
        boolean bl2 = StringIO.lock(threadContext, stringIOData);
        try {
            ByteList byteList = stringIOData.string.getByteList();
            byte[] byArray = byteList.getUnsafeBytes();
            int n2 = byteList.getBegin();
            int n3 = stringIOData.pos;
            int n4 = n2 + n3;
            int n5 = n2 + byteList.getRealSize();
            int n6 = 0;
            if (n > 0 && n4 + n < n5) {
                n5 = this.getEncoding().rightAdjustCharHead(byArray, n4, n4 + n, n5);
            }
            if (iRubyObject == threadContext.nil) {
                if (bl) {
                    n6 = StringIO.chompNewlineWidth(byArray, n4, n5);
                }
                rubyString = this.strioSubstr(ruby, n3, n5 - n4 - n6, encoding);
            } else {
                int n7 = ((RubyString)iRubyObject).size();
                if (n7 == 0) {
                    int n8 = 0;
                    int n9 = n4;
                    while (byArray[n9] == 10) {
                        if (++n9 != n5) continue;
                        IRubyObject iRubyObject2 = threadContext.nil;
                        return iRubyObject2;
                    }
                    n4 = n9;
                    while ((n9 = StringSupport.memchr((byte[])byArray, (int)n9, (int)10, (int)(n5 - n9))) != -1 && n9 != n5) {
                        if ((++n9 >= n5 || byArray[n9] != 10) && (n9 + 1 >= n5 || byArray[n9] != 13 || byArray[n9 + 1] != 10)) continue;
                        n8 = n9 - (byArray[n9 - 2] == 13 ? 2 : 1);
                        while (n9 < n5 && byArray[n9] == 10 || n9 + 1 < n5 && byArray[n9] == 13 && byArray[n9 + 1] == 10) {
                            n9 += byArray[n9] == 13 ? 2 : 1;
                        }
                        n5 = n9;
                        break;
                    }
                    if (bl && n8 != 0) {
                        n6 = n5 - n8;
                    }
                    rubyString = this.strioSubstr(ruby, n4 - n2, n5 - n4 - n6, encoding);
                } else if (n7 == 1) {
                    RubyString rubyString2 = (RubyString)iRubyObject;
                    ByteList byteList2 = rubyString2.getByteList();
                    int n10 = StringSupport.memchr((byte[])byArray, (int)n4, (int)byteList2.get(0), (int)(n5 - n4));
                    if (n10 != -1) {
                        n5 = n10 + 1;
                        n6 = bl ? (n10 > n4 && byArray[n10 - 1] == 13 ? 1 : 0) + 1 : 0;
                    }
                    rubyString = this.strioSubstr(ruby, n3, n5 - n4 - n6, encoding);
                } else {
                    if (n7 < n5 - n4 + (bl ? 1 : 0)) {
                        RubyString rubyString3 = (RubyString)iRubyObject;
                        ByteList byteList3 = rubyString3.getByteList();
                        byte[] byArray2 = byteList3.getUnsafeBytes();
                        if (n5 - n4 < 1024 || n7 == n5 - n4) {
                            int n11 = n4;
                            while (n11 + n7 <= n5) {
                                if (ByteList.memcmp((byte[])byArray, (int)n11, (byte[])byArray2, (int)0, (int)n7) == 0) {
                                    n5 = n11 + n7;
                                    n6 = bl ? n7 : 0;
                                    break;
                                }
                                ++n11;
                            }
                        } else {
                            int[] nArray = new int[256];
                            int n12 = byteList3.getBegin();
                            StringIO.bm_init_skip(nArray, byArray2, n12, n7);
                            int n13 = StringIO.bm_search(byArray2, n12, n7, byArray, n4, n5 - n4, nArray);
                            if (n13 >= 0) {
                                n5 = n4 + n13 + n7;
                            }
                        }
                    }
                    rubyString = this.strioSubstr(ruby, n3, n5 - n4 - n6, encoding);
                }
            }
            stringIOData.pos = n5 - n2;
            ++stringIOData.lineno;
        }
        finally {
            if (bl2) {
                StringIO.unlock(stringIOData);
            }
        }
        return rubyString;
    }

    private static int chompNewlineWidth(byte[] byArray, int n, int n2) {
        if (n2 > n && byArray[--n2] == 10) {
            if (n2 > n && byArray[--n2] == 13) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        this.checkInitialized();
        this.checkFinalized();
        return this.getRuntime().newFixnum(this.ptr.string.size());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.ptr.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.ptr.lineno = RubyNumeric.fix2int((IRubyObject)iRubyObject);
        return threadContext.nil;
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos(ThreadContext threadContext) {
        this.checkInitialized();
        return threadContext.runtime.newFixnum(this.ptr.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject iRubyObject) {
        this.checkInitialized();
        long l = RubyNumeric.fix2long((IRubyObject)iRubyObject);
        if (l < 0L) {
            throw this.getRuntime().newErrnoEINVALError(iRubyObject.toString());
        }
        if (l > Integer.MAX_VALUE) {
            throw this.getRuntime().newArgumentError("JRuby does not support StringIO larger than 2147483647 bytes");
        }
        this.ptr.pos = (int)l;
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strioExtend(ThreadContext threadContext, int n, int n2) {
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            RubyString rubyString = stringIOData.string;
            int n3 = rubyString.size();
            if (n + n2 > n3) {
                rubyString.resize(n + n2);
                if (n > n3) {
                    StringIO.modifyString(rubyString);
                    ByteList byteList = rubyString.getByteList();
                    int n4 = byteList.getBegin();
                    Arrays.fill(byteList.getUnsafeBytes(), n4 + n3, n4 + n, (byte)0);
                }
            } else {
                StringIO.modifyString(rubyString);
            }
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
    }

    @JRubyMethod(name={"putc"})
    public IRubyObject putc(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        this.checkWritable();
        IRubyObject iRubyObject2 = null;
        this.checkModifiable();
        if (iRubyObject instanceof RubyString) {
            iRubyObject2 = StringIO.substrString((RubyString)iRubyObject, iRubyObject2, ruby);
        } else {
            byte by = RubyNumeric.num2chr((IRubyObject)iRubyObject);
            iRubyObject2 = RubyString.newString((Ruby)ruby, (byte[])new byte[]{by});
        }
        this.write(threadContext, iRubyObject2);
        return iRubyObject;
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext threadContext) {
        return this.readCommon(threadContext, 0, null, null);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.readCommon(threadContext, 1, iRubyObject, null);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.readCommon(threadContext, 2, iRubyObject, iRubyObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject readCommon(ThreadContext threadContext, int n, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkReadable();
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject3 = threadContext.nil;
        boolean bl = false;
        StringIOData stringIOData = this.ptr;
        int n2 = stringIOData.pos;
        boolean bl2 = StringIO.lock(threadContext, stringIOData);
        try {
            RubyString rubyString;
            ASCIIEncoding aSCIIEncoding;
            int n3;
            switch (n) {
                case 2: {
                    iRubyObject3 = iRubyObject2;
                    if (!iRubyObject3.isNil()) {
                        iRubyObject3 = iRubyObject3.convertToString();
                        ((RubyString)iRubyObject3).modify();
                    }
                }
                case 1: {
                    if (!iRubyObject.isNil()) {
                        n3 = RubyNumeric.fix2int((IRubyObject)iRubyObject);
                        if (n3 < 0) {
                            throw ruby.newArgumentError("negative length " + n3 + " given");
                        }
                        if (n3 > 0 && this.isEndOfString()) {
                            if (!iRubyObject3.isNil()) {
                                ((RubyString)iRubyObject3).resize(0);
                            }
                            IRubyObject iRubyObject4 = threadContext.nil;
                            return iRubyObject4;
                        }
                        bl = true;
                        break;
                    }
                }
                case 0: {
                    n3 = stringIOData.string.size();
                    if (n3 <= n2) {
                        ASCIIEncoding aSCIIEncoding2;
                        Object object = aSCIIEncoding2 = bl ? ASCIIEncoding.INSTANCE : this.getEncoding();
                        if (iRubyObject3.isNil()) {
                            iRubyObject3 = ruby.newString();
                        } else {
                            ((RubyString)iRubyObject3).resize(0);
                        }
                        ((RubyString)iRubyObject3).setEncoding((Encoding)aSCIIEncoding2);
                        IRubyObject iRubyObject5 = iRubyObject3;
                        return iRubyObject5;
                    }
                    n3 -= n2;
                    break;
                }
                default: {
                    throw ruby.newArgumentError(n, 0, 2);
                }
            }
            if (iRubyObject3.isNil()) {
                aSCIIEncoding = bl ? ASCIIEncoding.INSTANCE : this.getEncoding();
                rubyString = this.strioSubstr(ruby, n2, n3, (Encoding)aSCIIEncoding);
            } else {
                rubyString = (RubyString)iRubyObject3;
                aSCIIEncoding = stringIOData.string;
                int n4 = aSCIIEncoding.size() - n2;
                if (n3 > n4) {
                    n3 = n4;
                }
                rubyString.resize(n3);
                ByteList byteList = rubyString.getByteList();
                byte[] byArray = byteList.getUnsafeBytes();
                ByteList byteList2 = aSCIIEncoding.getByteList();
                byte[] byArray2 = byteList2.getUnsafeBytes();
                System.arraycopy(byArray2, byteList2.getBegin() + n2, byArray, byteList.getBegin(), n3);
                if (bl) {
                    rubyString.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
                } else {
                    rubyString.setEncoding(aSCIIEncoding.getEncoding());
                }
            }
            stringIOData.pos += rubyString.size();
            aSCIIEncoding = rubyString;
            return aSCIIEncoding;
        }
        finally {
            if (bl2) {
                StringIO.unlock(stringIOData);
            }
        }
    }

    @JRubyMethod(name={"pread"})
    public IRubyObject pread(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.preadCommon(threadContext, 1, iRubyObject, null, null);
    }

    @JRubyMethod(name={"pread"})
    public IRubyObject pread(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.preadCommon(threadContext, 2, iRubyObject, iRubyObject2, null);
    }

    @JRubyMethod(name={"pread"})
    public IRubyObject pread(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.preadCommon(threadContext, 3, iRubyObject, iRubyObject2, iRubyObject3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyString preadCommon(ThreadContext threadContext, int n, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyString rubyString;
        int n2;
        int n3;
        IRubyObject iRubyObject4 = threadContext.nil;
        StringIOData stringIOData = this.ptr;
        Ruby ruby = threadContext.runtime;
        this.checkReadable();
        switch (n) {
            case 3: {
                iRubyObject4 = iRubyObject3;
                if (!iRubyObject4.isNil()) {
                    iRubyObject4 = iRubyObject4.convertToString();
                    ((RubyString)iRubyObject4).modify();
                }
            }
            case 2: {
                n3 = RubyNumeric.fix2int((IRubyObject)iRubyObject);
                n2 = RubyNumeric.fix2int((IRubyObject)iRubyObject2);
                if (iRubyObject.isNil()) break;
                n3 = RubyNumeric.fix2int((IRubyObject)iRubyObject);
                if (n3 < 0) {
                    throw ruby.newArgumentError("negative length " + n3 + " given");
                }
                if (n2 >= 0) break;
                throw ruby.newErrnoEINVALError("pread: Invalid offset argument");
            }
            default: {
                throw ruby.newArgumentError(n, 0, 2);
            }
        }
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            RubyString rubyString2 = stringIOData.string;
            if (n2 >= rubyString2.size()) {
                throw threadContext.runtime.newEOFError();
            }
            if (iRubyObject4.isNil()) {
                RubyString rubyString3 = this.strioSubstr(ruby, n2, n3, (Encoding)ASCIIEncoding.INSTANCE);
                return rubyString3;
            }
            rubyString = (RubyString)iRubyObject4;
            int n4 = rubyString2.size() - n2;
            if (n3 > n4) {
                n3 = n4;
            }
            rubyString.resize(n3);
            ByteList byteList = rubyString.getByteList();
            byte[] byArray = byteList.getUnsafeBytes();
            ByteList byteList2 = rubyString2.getByteList();
            byte[] byArray2 = byteList2.getUnsafeBytes();
            System.arraycopy(byArray2, byteList2.getBegin() + n2, byArray, byteList.getBegin(), n3);
            rubyString.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
        return rubyString;
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext threadContext) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_ARY, (Object)((Object)this), (Encoding)this.getEncoding());
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext threadContext, IRubyObject iRubyObject) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_ARY, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject);
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_ARY, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2);
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_ARY, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3);
    }

    public IRubyObject readlines(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.readlines(threadContext);
            }
            case 1: {
                return this.readlines(threadContext, iRubyObjectArray[0]);
            }
            case 2: {
                return this.readlines(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
            case 3: {
                return this.readlines(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
            }
        }
        Arity.raiseArgumentError((ThreadContext)threadContext, (int)iRubyObjectArray.length, (int)0, (int)3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod(name={"reopen"})
    public IRubyObject reopen(ThreadContext threadContext) {
        this.strioInit(threadContext, 0, null, null);
        return this;
    }

    @JRubyMethod(name={"reopen"})
    public IRubyObject reopen(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkFrozen();
        if (!(iRubyObject instanceof RubyString)) {
            return this.initialize_copy(threadContext, iRubyObject);
        }
        this.strioInit(threadContext, 1, iRubyObject, null);
        return this;
    }

    @JRubyMethod(name={"reopen"})
    public IRubyObject reopen(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkFrozen();
        this.strioInit(threadContext, 2, iRubyObject, iRubyObject2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind(ThreadContext threadContext) {
        this.checkInitialized();
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            stringIOData.pos = 0;
            stringIOData.lineno = 0;
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
        return RubyFixnum.zero((Ruby)threadContext.runtime);
    }

    @JRubyMethod
    public IRubyObject seek(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.seekCommon(threadContext, 1, iRubyObject, null);
    }

    @JRubyMethod
    public IRubyObject seek(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.seekCommon(threadContext, 2, iRubyObject, iRubyObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyFixnum seekCommon(ThreadContext threadContext, int n, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkFrozen();
        this.checkFinalized();
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject3 = threadContext.nil;
        int n2 = RubyNumeric.num2int((IRubyObject)iRubyObject);
        if (n > 1 && !iRubyObject.isNil()) {
            iRubyObject3 = iRubyObject2;
        }
        this.checkOpen();
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            switch (iRubyObject3.isNil() ? 0 : RubyNumeric.num2int((IRubyObject)iRubyObject3)) {
                case 0: {
                    break;
                }
                case 1: {
                    n2 += stringIOData.pos;
                    break;
                }
                case 2: {
                    n2 += stringIOData.string.size();
                    break;
                }
                default: {
                    throw ruby.newErrnoEINVALError("invalid whence");
                }
            }
            if (n2 < 0) {
                throw ruby.newErrnoEINVALError("invalid seek value");
            }
            stringIOData.pos = n2;
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
        return RubyFixnum.zero((Ruby)ruby);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkFrozen();
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            stringIOData.flags &= 0xFFFFFFFC;
            RubyString rubyString = iRubyObject.convertToString();
            stringIOData.flags = rubyString.isFrozen() ? 1 : 3;
            stringIOData.pos = 0;
            stringIOData.lineno = 0;
            RubyString rubyString2 = stringIOData.string = rubyString;
            return rubyString2;
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string(ThreadContext threadContext) {
        RubyString rubyString = this.ptr.string;
        if (rubyString == null) {
            return threadContext.nil;
        }
        return rubyString;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync(ThreadContext threadContext) {
        this.checkInitialized();
        return threadContext.tru;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkWritable();
        int n = RubyFixnum.fix2int((IRubyObject)iRubyObject);
        StringIOData stringIOData = this.ptr;
        RubyString rubyString = stringIOData.string;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            int n2 = rubyString.size();
            if (n < 0) {
                throw threadContext.runtime.newErrnoEINVALError("negative legnth");
            }
            rubyString.resize(n);
            ByteList byteList = rubyString.getByteList();
            if (n2 < n) {
                Arrays.fill(byteList.getUnsafeBytes(), byteList.getBegin() + n2, byteList.getBegin() + n, (byte)0);
            }
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"ungetc"})
    public IRubyObject ungetc(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString;
        Encoding encoding;
        this.checkModifiable();
        this.checkReadable();
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyInteger) {
            int n = RubyNumeric.num2int((IRubyObject)iRubyObject);
            byte[] byArray = new byte[16];
            Encoding encoding2 = this.getEncoding();
            int n2 = encoding2.codeToMbcLength(n);
            if (n2 <= 0) {
                EncodingUtils.encUintChr((ThreadContext)threadContext, (int)n, (Encoding)encoding2);
            }
            encoding2.codeToMbc(n, byArray, 0);
            this.ungetbyteCommon(threadContext, byArray, 0, n2);
            return threadContext.nil;
        }
        iRubyObject = iRubyObject.convertToString();
        Encoding encoding3 = this.getEncoding();
        if (encoding3 != (encoding = (rubyString = (RubyString)iRubyObject).getEncoding()) && encoding3 != ASCIIEncoding.INSTANCE) {
            rubyString = EncodingUtils.strConvEnc((ThreadContext)threadContext, (RubyString)rubyString, (Encoding)encoding, (Encoding)encoding3);
        }
        ByteList byteList = rubyString.getByteList();
        this.ungetbyteCommon(threadContext, byteList.unsafeBytes(), byteList.begin(), byteList.realSize());
        return threadContext.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungetbyteCommon(ThreadContext threadContext, int n) {
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            RubyString rubyString = stringIOData.string;
            rubyString.modify();
            --stringIOData.pos;
            ByteList byteList = rubyString.getByteList();
            if (this.isEndOfString()) {
                byteList.length(stringIOData.pos + 1);
            }
            if (stringIOData.pos == -1) {
                byteList.prepend((byte)n);
                stringIOData.pos = 0;
            } else {
                byteList.set(stringIOData.pos, n);
            }
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
    }

    private void ungetbyteCommon(ThreadContext threadContext, RubyString rubyString) {
        ByteList byteList = rubyString.getByteList();
        this.ungetbyteCommon(threadContext, byteList.unsafeBytes(), byteList.begin(), byteList.realSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungetbyteCommon(ThreadContext threadContext, byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            RubyString rubyString = stringIOData.string;
            rubyString.modify();
            int n3 = stringIOData.pos;
            int n4 = n2 > n3 ? 0 : n3 - n2;
            ByteList byteList = rubyString.getByteList();
            if (this.isEndOfString()) {
                byteList.length(Math.max(n3, n2));
            }
            byteList.replace(n4, n3 - n4, byArray, n, n2);
            stringIOData.pos = n4;
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
    }

    @JRubyMethod
    public IRubyObject ungetbyte(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkReadable();
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        this.checkModifiable();
        if (iRubyObject instanceof RubyInteger) {
            this.ungetbyteCommon(threadContext, ((RubyInteger)((RubyInteger)iRubyObject).op_mod(threadContext, 256L)).getIntValue());
        } else {
            this.ungetbyteCommon(threadContext, iRubyObject.convertToString());
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        return RubyFixnum.newFixnum((Ruby)ruby, (long)this.stringIOWrite(threadContext, ruby, iRubyObject));
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.runtime;
        long l = 0L;
        l += this.stringIOWrite(threadContext, ruby, iRubyObject);
        return RubyFixnum.newFixnum((Ruby)ruby, (long)(l += this.stringIOWrite(threadContext, ruby, iRubyObject2)));
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = threadContext.runtime;
        long l = 0L;
        l += this.stringIOWrite(threadContext, ruby, iRubyObject);
        l += this.stringIOWrite(threadContext, ruby, iRubyObject2);
        return RubyFixnum.newFixnum((Ruby)ruby, (long)(l += this.stringIOWrite(threadContext, ruby, iRubyObject3)));
    }

    @JRubyMethod(name={"write"}, required=1, rest=true)
    public IRubyObject write(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Arity.checkArgumentCount((ThreadContext)threadContext, (IRubyObject[])iRubyObjectArray, (int)1, (int)-1);
        Ruby ruby = threadContext.runtime;
        long l = 0L;
        for (IRubyObject iRubyObject : iRubyObjectArray) {
            l += this.stringIOWrite(threadContext, ruby, iRubyObject);
        }
        return RubyFixnum.newFixnum((Ruby)ruby, (long)l);
    }

    private static void catString(RubyString rubyString, RubyString rubyString2) {
        try {
            RubyString rubyString3 = CAT_WITH_CODE_RANGE.invokeExact(rubyString, rubyString2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static void modifyString(RubyString rubyString) {
        try {
            MODIFY_AND_CLEAR_CODE_RANGE.invokeExact(rubyString);
        }
        catch (Throwable throwable) {
            Helpers.throwException((Throwable)throwable);
        }
    }

    private static IRubyObject substrString(RubyString rubyString, IRubyObject iRubyObject, Ruby ruby) {
        try {
            iRubyObject = SUBSTR_ENC.invokeExact(rubyString, ruby, 0, 1);
        }
        catch (Throwable throwable) {
            Helpers.throwException((Throwable)throwable);
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long stringIOWrite(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject) {
        int n;
        this.checkWritable();
        RubyString rubyString = iRubyObject.asString();
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            int n2;
            Encoding encoding = this.getEncoding();
            Encoding encoding2 = rubyString.getEncoding();
            if (encoding != encoding2 && encoding != EncodingUtils.ascii8bitEncoding((Ruby)ruby) && encoding2 != ASCIIEncoding.INSTANCE) {
                rubyString = EncodingUtils.strConvEnc((ThreadContext)threadContext, (RubyString)rubyString, (Encoding)encoding2, (Encoding)encoding);
            }
            ByteList byteList = rubyString.getByteList();
            n = rubyString.size();
            if (n == 0) {
                long l = 0L;
                return l;
            }
            this.checkModifiable();
            RubyString rubyString2 = stringIOData.string;
            int n3 = rubyString2.size();
            if ((stringIOData.flags & 0x40) != 0) {
                stringIOData.pos = n3;
            }
            if ((n2 = stringIOData.pos) == n3) {
                if (encoding == EncodingUtils.ascii8bitEncoding((Ruby)ruby) || encoding2 == EncodingUtils.ascii8bitEncoding((Ruby)ruby)) {
                    EncodingUtils.encStrBufCat((Ruby)ruby, (RubyString)rubyString2, (ByteList)byteList, (Encoding)encoding);
                } else {
                    StringIO.catString(rubyString2, rubyString);
                }
            } else {
                this.strioExtend(threadContext, n2, n);
                ByteList byteList2 = rubyString2.getByteList();
                System.arraycopy(byteList.getUnsafeBytes(), byteList.getBegin(), byteList2.getUnsafeBytes(), byteList2.begin() + n2, n);
            }
            stringIOData.pos = n2 + n;
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext threadContext, IRubyObject iRubyObject) {
        Encoding encoding = iRubyObject.isNil() ? EncodingUtils.defaultExternalEncoding((Ruby)threadContext.runtime) : EncodingUtils.rbToEncoding((ThreadContext)threadContext, (IRubyObject)iRubyObject);
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            RubyString rubyString;
            stringIOData.enc = encoding;
            if (this.writable() && (rubyString = stringIOData.string).getEncoding() != encoding) {
                rubyString.modify();
                rubyString.setEncoding(encoding);
            }
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.set_encoding(threadContext, iRubyObject);
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.set_encoding(threadContext, iRubyObject);
    }

    @JRubyMethod
    public IRubyObject set_encoding_by_bom(ThreadContext threadContext) {
        if (this.setEncodingByBOM(threadContext) == null) {
            return threadContext.nil;
        }
        return threadContext.runtime.getEncodingService().convertEncodingToRubyEncoding(this.ptr.enc);
    }

    private Encoding setEncodingByBOM(ThreadContext threadContext2) {
        Encoding encoding2;
        this.ptr.enc = encoding2 = StringIO.detectBOM(threadContext2, this.ptr.string, (ObjectObjectIntFunction<ThreadContext, Encoding, Encoding>)((ObjectObjectIntFunction)(threadContext, encoding, n) -> {
            this.ptr.pos = n;
            if (this.writable()) {
                this.ptr.string.setEncoding(encoding);
            }
            return encoding;
        }));
        return encoding2;
    }

    private static Encoding detectBOM(ThreadContext threadContext, RubyString rubyString, ObjectObjectIntFunction<ThreadContext, Encoding, Encoding> objectObjectIntFunction) {
        ByteList byteList = rubyString.getByteList();
        byte[] byArray = byteList.unsafeBytes();
        int n = byteList.begin();
        int n2 = byteList.realSize();
        if (n2 < 1) {
            return null;
        }
        switch (Byte.toUnsignedInt(byArray[n])) {
            case 239: {
                if (n2 < 3 || Byte.toUnsignedInt(byArray[n + 1]) != 187 || Byte.toUnsignedInt(byArray[n + 2]) != 191) break;
                return (Encoding)objectObjectIntFunction.apply((Object)threadContext, (Object)UTF8Encoding.INSTANCE, 3);
            }
            case 254: {
                if (n2 < 2 || Byte.toUnsignedInt(byArray[n + 1]) != 255) break;
                return (Encoding)objectObjectIntFunction.apply((Object)threadContext, (Object)UTF16BEEncoding.INSTANCE, 2);
            }
            case 255: {
                if (n2 < 2 || Byte.toUnsignedInt(byArray[n + 1]) != 254) break;
                if (n2 >= 4 && Byte.toUnsignedInt(byArray[n + 2]) == 0 && Byte.toUnsignedInt(byArray[n + 3]) == 0) {
                    return (Encoding)objectObjectIntFunction.apply((Object)threadContext, (Object)UTF32LEEncoding.INSTANCE, 4);
                }
                return (Encoding)objectObjectIntFunction.apply((Object)threadContext, (Object)UTF16LEEncoding.INSTANCE, 2);
            }
            case 0: {
                if (n2 < 4 || Byte.toUnsignedInt(byArray[n + 1]) != 0 || Byte.toUnsignedInt(byArray[n + 2]) != 254 || Byte.toUnsignedInt(byArray[n + 3]) != 255) break;
                return (Encoding)objectObjectIntFunction.apply((Object)threadContext, (Object)UTF32BEEncoding.INSTANCE, 4);
            }
        }
        return (Encoding)objectObjectIntFunction.apply((Object)threadContext, null, 0);
    }

    @JRubyMethod
    public IRubyObject external_encoding(ThreadContext threadContext) {
        return threadContext.runtime.getEncodingService().convertEncodingToRubyEncoding(this.getEncoding());
    }

    @JRubyMethod
    public IRubyObject internal_encoding(ThreadContext threadContext) {
        return threadContext.nil;
    }

    @JRubyMethod(name={"each_codepoint"})
    public IRubyObject each_codepoint(ThreadContext threadContext, Block block) {
        Ruby ruby = threadContext.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)ruby, (IRubyObject)this, (String)"each_codepoint");
        }
        this.checkReadable();
        StringIOData stringIOData = this.ptr;
        boolean bl = StringIO.lock(threadContext, stringIOData);
        try {
            Encoding encoding = this.getEncoding();
            RubyString rubyString = stringIOData.string;
            ByteList byteList = rubyString.getByteList();
            byte[] byArray = byteList.getUnsafeBytes();
            int n = byteList.getBegin();
            while (true) {
                int n2;
                if ((n2 = stringIOData.pos) >= byteList.realSize()) {
                    StringIO stringIO = this;
                    return stringIO;
                }
                int n3 = StringSupport.codePoint((Ruby)ruby, (Encoding)encoding, (byte[])byArray, (int)(n + n2), (int)byArray.length);
                int n4 = StringSupport.codeLength((Encoding)encoding, (int)n3);
                block.yield(threadContext, (IRubyObject)ruby.newFixnum(n3));
                stringIOData.pos = n2 + n4;
            }
        }
        finally {
            if (bl) {
                StringIO.unlock(stringIOData);
            }
        }
    }

    public IRubyObject puts(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return GenericWritable.puts(threadContext, (IRubyObject)this, iRubyObjectArray);
    }

    public void checkFrozen() {
        super.checkFrozen();
        this.checkInitialized();
    }

    private boolean readable() {
        return (this.flags & STRIO_READABLE) != 0 && (this.ptr.flags & 1) != 0;
    }

    private boolean writable() {
        return (this.flags & STRIO_WRITABLE) != 0 && (this.ptr.flags & 2) != 0;
    }

    private boolean closed() {
        return (this.flags & STRIO_READWRITE) == 0 || (this.ptr.flags & 3) == 0;
    }

    private void checkReadable() {
        this.checkInitialized();
        if (!this.readable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        this.checkInitialized();
        if (!this.writable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void checkModifiable() {
        this.checkFrozen();
        if (this.ptr.string.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
    }

    private void checkInitialized() {
        if (this.ptr == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    private void checkFinalized() {
        if (this.ptr.string == null) {
            throw this.getRuntime().newIOError("not opened");
        }
    }

    private void checkOpen() {
        if (this.closed()) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private static boolean lock(ThreadContext threadContext, StringIOData stringIOData) {
        if (stringIOData.owner == threadContext) {
            return false;
        }
        while (!LOCKED_UPDATER.compareAndSet(stringIOData, null, threadContext)) {
        }
        return true;
    }

    private static void unlock(StringIOData stringIOData) {
        stringIOData.owner = null;
    }

    static {
        MethodHandle methodHandle;
        MethodHandle methodHandle2;
        MethodHandle methodHandle3;
        STRIO_READABLE = ObjectFlags.registry.newFlag(StringIO.class);
        STRIO_WRITABLE = ObjectFlags.registry.newFlag(StringIO.class);
        STRIO_READWRITE = STRIO_READABLE | STRIO_WRITABLE;
        LOCKED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(StringIOData.class, Object.class, "owner");
        VMODE_VPERM_TL = ThreadLocal.withInitial(() -> EncodingUtils.vmodeVperm(null, null));
        FMODE_TL = ThreadLocal.withInitial(() -> new int[]{0});
        OFLAGS_UNUSED = new int[]{0};
        GETLINE = (threadContext, stringIO, iRubyObject, n, bl, block) -> {
            if (n == 0) {
                return RubyString.newEmptyString((Ruby)threadContext.runtime, (Encoding)stringIO.getEncoding());
            }
            if (iRubyObject.isNil()) {
                bl = false;
            }
            IRubyObject iRubyObject2 = stringIO.getline(threadContext, iRubyObject, n, bl);
            threadContext.setLastLine(iRubyObject2);
            return iRubyObject2;
        };
        GETLINE_YIELD = (threadContext, stringIO, iRubyObject, n, bl, block) -> {
            IRubyObject iRubyObject2;
            if (n == 0) {
                throw threadContext.runtime.newArgumentError("invalid limit: 0 for each_line");
            }
            if (iRubyObject.isNil()) {
                bl = false;
            }
            while (!(iRubyObject2 = stringIO.getline(threadContext, iRubyObject, n, bl)).isNil()) {
                block.yieldSpecific(threadContext, iRubyObject2);
            }
            return stringIO;
        };
        GETLINE_ARY = (threadContext, stringIO, iRubyObject, n, bl, block) -> {
            IRubyObject iRubyObject2;
            RubyArray rubyArray = threadContext.runtime.newArray();
            if (n == 0) {
                throw threadContext.runtime.newArgumentError("invalid limit: 0 for readlines");
            }
            if (iRubyObject.isNil()) {
                bl = false;
            }
            while (!(iRubyObject2 = stringIO.getline(threadContext, iRubyObject, n, bl)).isNil()) {
                rubyArray.append(iRubyObject2);
            }
            return rubyArray;
        };
        NEWLINE = ByteList.create((CharSequence)"\n");
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            methodHandle3 = lookup.findVirtual(RubyString.class, "catWithCodeRange", MethodType.methodType(RubyString.class, RubyString.class));
            methodHandle2 = lookup.findVirtual(RubyString.class, "modifyAndClearCodeRange", MethodType.methodType(Void.TYPE));
            methodHandle = lookup.findVirtual(RubyString.class, "substrEnc", MethodType.methodType(IRubyObject.class, Ruby.class, Integer.TYPE, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            try {
                methodHandle3 = lookup.findVirtual(RubyString.class, "cat19", MethodType.methodType(RubyString.class, RubyString.class));
                methodHandle2 = lookup.findVirtual(RubyString.class, "modify19", MethodType.methodType(Void.TYPE));
                methodHandle = lookup.findVirtual(RubyString.class, "substr19", MethodType.methodType(IRubyObject.class, Ruby.class, Integer.TYPE, Integer.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException2) {
                throw new ExceptionInInitializerError(reflectiveOperationException2);
            }
        }
        CAT_WITH_CODE_RANGE = methodHandle3;
        MODIFY_AND_CLEAR_CODE_RANGE = methodHandle2;
        SUBSTR_ENC = methodHandle;
    }

    public static class GenericReadable {
        @JRubyMethod(name={"readchar"})
        public static IRubyObject readchar(ThreadContext threadContext, IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "getc");
            if (iRubyObject2.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject2;
        }

        @JRubyMethod(name={"readbyte"})
        public static IRubyObject readbyte(ThreadContext threadContext, IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "getbyte");
            if (iRubyObject2.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject2;
        }

        @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
        public static IRubyObject readline(ThreadContext threadContext, IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "gets");
            if (iRubyObject2.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject2;
        }

        @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
        public static IRubyObject readline(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, "gets", iRubyObject2);
            if (iRubyObject3.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject3;
        }

        @JRubyMethod(name={"sysread", "readpartial"})
        public static IRubyObject sysread(ThreadContext threadContext, IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "read");
            if (iRubyObject2.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject2;
        }

        @JRubyMethod(name={"sysread", "readpartial"})
        public static IRubyObject sysread(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            IRubyObject iRubyObject3 = Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"read", (IRubyObject)iRubyObject2);
            if (iRubyObject3.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject3;
        }

        @JRubyMethod(name={"sysread", "readpartial"})
        public static IRubyObject sysread(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            IRubyObject iRubyObject4 = Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"read", (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3);
            if (iRubyObject4.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject4;
        }

        @JRubyMethod(name={"read_nonblock"}, required=1, optional=2)
        public static IRubyObject read_nonblock(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject2;
            int n = Arity.checkArgumentCount((ThreadContext)threadContext, (IRubyObject[])iRubyObjectArray, (int)1, (int)3);
            Ruby ruby = threadContext.runtime;
            boolean bl = true;
            IRubyObject iRubyObject3 = ArgsUtil.getOptionsArg((Ruby)ruby, (IRubyObject[])iRubyObjectArray);
            if (iRubyObject3 != threadContext.nil) {
                iRubyObjectArray = ArraySupport.newCopy((IRubyObject[])iRubyObjectArray, (int)(n - 1));
                bl = Helpers.extractExceptionOnlyArg((ThreadContext)threadContext, (RubyHash)((RubyHash)iRubyObject3));
            }
            if ((iRubyObject2 = iRubyObject.callMethod(threadContext, "read", iRubyObjectArray)) == threadContext.nil) {
                if (!bl) {
                    return threadContext.nil;
                }
                throw ruby.newEOFError();
            }
            return iRubyObject2;
        }
    }

    public static class GenericWritable {
        @JRubyMethod(name={"<<"})
        public static IRubyObject append(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            iRubyObject.callMethod(threadContext, "write", iRubyObject2);
            return iRubyObject;
        }

        @JRubyMethod(name={"print"}, rest=true, writes={FrameField.LASTLINE})
        public static IRubyObject print(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return RubyIO.print((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject[])iRubyObjectArray);
        }

        @JRubyMethod(name={"printf"}, required=1, rest=true)
        public static IRubyObject printf(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            iRubyObject.callMethod(threadContext, "write", RubyKernel.sprintf((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject[])iRubyObjectArray));
            return threadContext.nil;
        }

        @JRubyMethod(name={"puts"}, rest=true)
        public static IRubyObject puts(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            Ruby ruby = threadContext.runtime;
            if (iRubyObjectArray.length == 0) {
                RubyIO.write((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)NEWLINE));
                return ruby.getNil();
            }
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                GenericWritable.putsArg(threadContext, iRubyObject, iRubyObjectArray[i], ruby);
            }
            return threadContext.nil;
        }

        @JRubyMethod(name={"puts"})
        public static IRubyObject puts(ThreadContext threadContext, IRubyObject iRubyObject) {
            RubyIO.write((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)RubyString.newStringShared((Ruby)threadContext.runtime, (ByteList)NEWLINE));
            return threadContext.nil;
        }

        @JRubyMethod(name={"puts"})
        public static IRubyObject puts(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            GenericWritable.putsArg(threadContext, iRubyObject, iRubyObject2, threadContext.runtime);
            return threadContext.nil;
        }

        @JRubyMethod(name={"puts"})
        public static IRubyObject puts(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            Ruby ruby = threadContext.runtime;
            GenericWritable.putsArg(threadContext, iRubyObject, iRubyObject2, ruby);
            GenericWritable.putsArg(threadContext, iRubyObject, iRubyObject3, ruby);
            return threadContext.nil;
        }

        @JRubyMethod(name={"puts"})
        public static IRubyObject puts(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            Ruby ruby = threadContext.runtime;
            GenericWritable.putsArg(threadContext, iRubyObject, iRubyObject2, ruby);
            GenericWritable.putsArg(threadContext, iRubyObject, iRubyObject3, ruby);
            GenericWritable.putsArg(threadContext, iRubyObject, iRubyObject4, ruby);
            return threadContext.nil;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static void putsArg(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Ruby ruby) {
            RubyString rubyString = null;
            if (!iRubyObject2.isNil()) {
                IRubyObject iRubyObject3 = iRubyObject2.checkArrayType();
                if (!iRubyObject3.isNil()) {
                    RubyArray rubyArray = (RubyArray)iRubyObject3;
                    if (!ruby.isInspecting((Object)rubyArray)) {
                        GenericWritable.inspectPuts(threadContext, iRubyObject, (RubyArray<IRubyObject>)rubyArray);
                        return;
                    }
                    rubyString = ruby.newString("[...]");
                } else {
                    rubyString = iRubyObject2 instanceof RubyString ? (RubyString)iRubyObject2 : iRubyObject2.asString();
                }
            }
            if (rubyString != null) {
                RubyIO.write((ThreadContext)threadContext, (IRubyObject)iRubyObject, rubyString);
            }
            if (rubyString == null || !rubyString.getByteList().endsWith(NEWLINE)) {
                RubyIO.write((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)NEWLINE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IRubyObject inspectPuts(ThreadContext threadContext, IRubyObject iRubyObject, RubyArray<IRubyObject> rubyArray) {
            Ruby ruby = threadContext.runtime;
            try {
                ruby.registerInspecting(rubyArray);
                IRubyObject iRubyObject2 = GenericWritable.puts(threadContext, iRubyObject, rubyArray.toJavaArray());
                return iRubyObject2;
            }
            finally {
                ruby.unregisterInspecting(rubyArray);
            }
        }

        @JRubyMethod(name={"syswrite"})
        public static IRubyObject syswrite(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RubyIO.write((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2);
        }

        @JRubyMethod(name={"write_nonblock"}, required=1, optional=1)
        public static IRubyObject syswrite_nonblock(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            Arity.checkArgumentCount((ThreadContext)threadContext, (IRubyObject[])iRubyObjectArray, (int)1, (int)2);
            Ruby ruby = threadContext.runtime;
            ArgsUtil.getOptionsArg((Ruby)ruby, (IRubyObject[])iRubyObjectArray);
            return GenericWritable.syswrite(threadContext, iRubyObject, iRubyObjectArray[0]);
        }
    }

    static class StringIOData {
        RubyString string;
        Encoding enc;
        int pos;
        int lineno;
        int flags;
        volatile Object owner;

        StringIOData() {
        }
    }
}

