/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.concurrent;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.concurrent.EmptyFuture;
import org.jitsi.utils.concurrent.FixedDelayJob;
import org.jitsi.utils.concurrent.FixedRateJob;
import org.jitsi.utils.concurrent.Job;
import org.jitsi.utils.concurrent.JobsTimeline;
import org.jitsi.utils.concurrent.RecurringJob;
import org.jitsi.utils.time.FakeClock;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00150\u0014\"\u0004\b\u0000\u0010\u00162\u0014\u0010\u0017\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00190\u0018H\u0016J@\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00150\u0014\"\u0004\b\u0000\u0010\u00162\u0014\u0010\u0017\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00190\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J)\u0010\u001a\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0014\u0010\u0017\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001bJ9\u0010\u001a\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0014\u0010\u0017\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00190\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\nH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\"\u001a\u00020\u0010J\u000e\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%J$\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J2\u0010&\u001a\b\u0012\u0004\u0012\u0002H)0'\"\u0004\b\u0000\u0010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0\u00192\u0006\u0010(\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010+\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010.\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010/\u001a\u000200H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u0014\u00102\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u00103\u001a\u00020\u0012H\u0016J)\u00102\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\u0006\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u0002H\u0016H\u0016\u00a2\u0006\u0002\u00105J\"\u00102\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jitsi/utils/concurrent/FakeScheduledExecutorService;", "Ljava/util/concurrent/ScheduledExecutorService;", "clock", "Lorg/jitsi/utils/time/FakeClock;", "(Lorg/jitsi/utils/time/FakeClock;)V", "getClock", "()Lorg/jitsi/utils/time/FakeClock;", "jobs", "Lorg/jitsi/utils/concurrent/JobsTimeline;", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "execute", "", "command", "Ljava/lang/Runnable;", "invokeAll", "", "Ljava/util/concurrent/Future;", "T", "tasks", "", "Ljava/util/concurrent/Callable;", "invokeAny", "(Ljava/util/Collection;)Ljava/lang/Object;", "(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isShutdown", "isTerminated", "numPendingJobs", "", "run", "runOne", "runUntil", "endTime", "Ljava/time/Instant;", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "delay", "V", "callable", "scheduleAtFixedRate", "initialDelay", "period", "scheduleWithFixedDelay", "shutdown", "", "shutdownNow", "submit", "task", "result", "(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;", "jitsi-utils"})
@SourceDebugExtension(value={"SMAP\nFakeScheduledExecutorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeScheduledExecutorService.kt\norg/jitsi/utils/concurrent/FakeScheduledExecutorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n766#2:235\n857#2,2:236\n*S KotlinDebug\n*F\n+ 1 FakeScheduledExecutorService.kt\norg/jitsi/utils/concurrent/FakeScheduledExecutorService\n*L\n77#1:235\n77#1:236,2\n*E\n"})
public final class FakeScheduledExecutorService
implements ScheduledExecutorService {
    @NotNull
    private final FakeClock clock;
    @NotNull
    private JobsTimeline jobs;

    public FakeScheduledExecutorService(@NotNull FakeClock clock) {
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.clock = clock;
        this.jobs = new JobsTimeline();
    }

    public /* synthetic */ FakeScheduledExecutorService(FakeClock fakeClock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            fakeClock = new FakeClock(false, null, 3, null);
        }
        this(fakeClock);
    }

    @NotNull
    public final FakeClock getClock() {
        return this.clock;
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        Instant nextRunTime = this.clock.instant().plus(Duration.ofMillis(unit.toMillis(initialDelay)));
        Intrinsics.checkNotNull(nextRunTime);
        Duration duration = Duration.ofMillis(unit.toMillis(period));
        Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
        FixedRateJob job = new FixedRateJob(command, nextRunTime, duration);
        this.jobs.add(job);
        return new EmptyFuture(new Function0<Unit>(job){
            final /* synthetic */ FixedRateJob $job;
            {
                this.$job = $job;
                super(0);
            }

            public final void invoke() {
                this.$job.setCancelled(true);
            }
        });
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        Instant nextRunTime = this.clock.instant().plus(Duration.ofNanos(unit.toNanos(delay)));
        Intrinsics.checkNotNull(nextRunTime);
        Job job = new Job(command, nextRunTime);
        this.jobs.add(job);
        return new EmptyFuture(new Function0<Unit>(job){
            final /* synthetic */ Job $job;
            {
                this.$job = $job;
                super(0);
            }

            public final void invoke() {
                this.$job.setCancelled(true);
            }
        });
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        Instant nextRunTime = this.clock.instant().plus(Duration.ofMillis(unit.toMillis(initialDelay)));
        Intrinsics.checkNotNull(nextRunTime);
        Duration duration = Duration.ofMillis(unit.toMillis(delay));
        Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
        FixedDelayJob job = new FixedDelayJob(command, nextRunTime, duration);
        this.jobs.add(job);
        return new EmptyFuture(new Function0<Unit>(job){
            final /* synthetic */ FixedDelayJob $job;
            {
                this.$job = $job;
                super(0);
            }

            public final void invoke() {
                this.$job.setCancelled(true);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final int numPendingJobs() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.jobs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Job it = (Job)element$iv$iv;
            boolean bl = false;
            if (!(!it.getCancelled())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size();
    }

    public final void runOne() {
        while (!((Collection)this.jobs).isEmpty() && ((Job)this.jobs.get(0)).getCancelled()) {
            this.jobs.remove(0);
        }
        if (!((Collection)this.jobs).isEmpty()) {
            Object e = this.jobs.remove(0);
            Intrinsics.checkNotNullExpressionValue(e, "removeAt(...)");
            Job nextJob = (Job)e;
            if (this.clock.instant().compareTo(nextJob.getNextRunTime()) < 0) {
                this.clock.setTime(nextJob.getNextRunTime());
            }
            nextJob.run();
            if (nextJob instanceof RecurringJob) {
                ((RecurringJob)nextJob).updateNextRuntime(this.clock.instant());
                this.jobs.add(nextJob);
            }
        }
    }

    public final void runUntil(@NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter(endTime, "endTime");
        while (!((Collection)this.jobs).isEmpty() && this.clock.instant().compareTo(endTime) <= 0 && ((Job)CollectionsKt.first(this.jobs)).getNextRunTime().compareTo(endTime) <= 0) {
            this.runOne();
        }
    }

    public final void run() {
        Instant now = this.clock.instant();
        if (!((Collection)this.jobs).isEmpty()) {
            Object e = this.jobs.remove(0);
            Intrinsics.checkNotNullExpressionValue(e, "removeAt(...)");
            Job job = (Job)e;
            if (!job.getCancelled()) {
                if (job.ready(now)) {
                    job.run();
                    if (job instanceof RecurringJob) {
                        ((RecurringJob)job).updateNextRuntime(now);
                        this.jobs.add(job);
                    }
                    this.run();
                } else {
                    this.jobs.add(0, job);
                }
            }
        }
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter(command, "command");
        this.schedule(command, 0L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public Void shutdown() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean isShutdown() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean isTerminated() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean awaitTermination(long timeout2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        Intrinsics.checkNotNullParameter(task, "task");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        Intrinsics.checkNotNullParameter(task, "task");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter(task, "task");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) {
        Intrinsics.checkNotNullParameter(tasks, "tasks");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(tasks, "tasks");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) {
        Intrinsics.checkNotNullParameter(tasks, "tasks");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(tasks, "tasks");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(callable, "callable");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public FakeScheduledExecutorService() {
        this(null, 1, null);
    }
}

