/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CleaningWeakReferenceMap;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muc.AutoJoinFailedCallback;
import org.jivesoftware.smackx.muc.AutoJoinSuccessCallback;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MucMessageInterceptor;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.util.cache.ExpirationCache;

public final class MultiUserChatManager
extends Manager {
    private static final String DISCO_NODE = "http://jabber.org/protocol/muc#rooms";
    private static final Logger LOGGER = Logger.getLogger(MultiUserChatManager.class.getName());
    private static final Map<XMPPConnection, MultiUserChatManager> INSTANCES;
    private static final StanzaFilter INVITATION_FILTER;
    private static final ExpirationCache<DomainBareJid, DiscoverInfo> KNOWN_MUC_SERVICES;
    private static final Set<MucMessageInterceptor> DEFAULT_MESSAGE_INTERCEPTORS;
    private final Set<InvitationListener> invitationsListeners = new CopyOnWriteArraySet<InvitationListener>();
    private final Set<EntityBareJid> joinedRooms = new CopyOnWriteArraySet<EntityBareJid>();
    private final Map<EntityBareJid, WeakReference<MultiUserChat>> multiUserChats = new CleaningWeakReferenceMap<EntityBareJid, MultiUserChat>();
    private boolean autoJoinOnReconnect;
    private AutoJoinFailedCallback autoJoinFailedCallback;
    private AutoJoinSuccessCallback autoJoinSuccessCallback;
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public static synchronized MultiUserChatManager getInstanceFor(XMPPConnection connection) {
        MultiUserChatManager multiUserChatManager = INSTANCES.get(connection);
        if (multiUserChatManager == null) {
            multiUserChatManager = new MultiUserChatManager(connection);
            INSTANCES.put(connection, multiUserChatManager);
        }
        return multiUserChatManager;
    }

    private MultiUserChatManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        StanzaListener invitationPacketListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Message message = (Message)packet;
                MUCUser mucUser = MUCUser.from(message);
                if (mucUser.getInvite() != null) {
                    EntityBareJid mucJid = message.getFrom().asEntityBareJidIfPossible();
                    if (mucJid == null) {
                        LOGGER.warning("Invite to non bare JID: '" + message.toXML() + "'");
                        return;
                    }
                    MultiUserChat muc = MultiUserChatManager.this.getMultiUserChat(mucJid);
                    XMPPConnection connection = MultiUserChatManager.this.connection();
                    MUCUser.Invite invite = mucUser.getInvite();
                    EntityJid from = invite.getFrom();
                    String reason = invite.getReason();
                    String password = mucUser.getPassword();
                    for (InvitationListener listener : MultiUserChatManager.this.invitationsListeners) {
                        listener.invitationReceived(connection, muc, from, reason, password, message, invite);
                    }
                }
            }
        };
        connection.addAsyncStanzaListener(invitationPacketListener, INVITATION_FILTER);
        connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (resumed) {
                    return;
                }
                if (!MultiUserChatManager.this.autoJoinOnReconnect) {
                    return;
                }
                final Set<EntityBareJid> mucs = MultiUserChatManager.this.getJoinedRooms();
                if (mucs.isEmpty()) {
                    return;
                }
                Async.go(new Runnable(){

                    @Override
                    public void run() {
                        AutoJoinFailedCallback failedCallback = MultiUserChatManager.this.autoJoinFailedCallback;
                        AutoJoinSuccessCallback successCallback = MultiUserChatManager.this.autoJoinSuccessCallback;
                        for (EntityBareJid mucJid : mucs) {
                            MultiUserChat muc = MultiUserChatManager.this.getMultiUserChat(mucJid);
                            if (!muc.isJoined()) {
                                return;
                            }
                            Resourcepart nickname = muc.getNickname();
                            if (nickname == null) {
                                return;
                            }
                            try {
                                muc.leave();
                            }
                            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | MultiUserChatException.MucNotJoinedException e) {
                                if (failedCallback != null) {
                                    failedCallback.autoJoinFailed(muc, e);
                                } else {
                                    LOGGER.log(Level.WARNING, "Could not leave room", e);
                                }
                                return;
                            }
                            try {
                                muc.join(nickname);
                                if (successCallback == null) continue;
                                successCallback.autoJoinSuccess(muc, nickname);
                            }
                            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | MultiUserChatException.NotAMucServiceException e) {
                                if (failedCallback != null) {
                                    failedCallback.autoJoinFailed(muc, e);
                                } else {
                                    LOGGER.log(Level.WARNING, "Could not leave room", e);
                                }
                                return;
                            }
                        }
                    }
                });
            }
        });
    }

    public synchronized MultiUserChat getMultiUserChat(EntityBareJid jid) {
        WeakReference<MultiUserChat> weakRefMultiUserChat = this.multiUserChats.get(jid);
        if (weakRefMultiUserChat == null) {
            return this.createNewMucAndAddToMap(jid);
        }
        MultiUserChat multiUserChat = (MultiUserChat)weakRefMultiUserChat.get();
        if (multiUserChat == null) {
            return this.createNewMucAndAddToMap(jid);
        }
        return multiUserChat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addDefaultMessageInterceptor(MucMessageInterceptor messageInterceptor) {
        Set<MucMessageInterceptor> set = DEFAULT_MESSAGE_INTERCEPTORS;
        synchronized (set) {
            return DEFAULT_MESSAGE_INTERCEPTORS.add(messageInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeDefaultMessageInterceptor(MucMessageInterceptor messageInterceptor) {
        Set<MucMessageInterceptor> set = DEFAULT_MESSAGE_INTERCEPTORS;
        synchronized (set) {
            return DEFAULT_MESSAGE_INTERCEPTORS.remove(messageInterceptor);
        }
    }

    private MultiUserChat createNewMucAndAddToMap(EntityBareJid jid) {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection(), jid, this);
        this.multiUserChats.put(jid, new WeakReference<MultiUserChat>(multiUserChat));
        return multiUserChat;
    }

    public boolean isServiceEnabled(Jid user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serviceDiscoveryManager.supportsFeature(user, "http://jabber.org/protocol/muc");
    }

    public Set<EntityBareJid> getJoinedRooms() {
        return Collections.unmodifiableSet(this.joinedRooms);
    }

    public List<EntityBareJid> getJoinedRooms(EntityFullJid user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems result = this.serviceDiscoveryManager.discoverItems(user, DISCO_NODE);
        List<DiscoverItems.Item> items = result.getItems();
        ArrayList<EntityBareJid> answer = new ArrayList<EntityBareJid>(items.size());
        for (DiscoverItems.Item item : items) {
            EntityBareJid muc = item.getEntityID().asEntityBareJidIfPossible();
            if (muc == null) {
                LOGGER.warning("Not a bare JID: " + item.getEntityID());
                continue;
            }
            answer.add(muc);
        }
        return answer;
    }

    public RoomInfo getRoomInfo(EntityBareJid room) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo info2 = this.serviceDiscoveryManager.discoverInfo(room);
        return new RoomInfo(info2);
    }

    public List<DomainBareJid> getMucServiceDomains() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serviceDiscoveryManager.findServices("http://jabber.org/protocol/muc", false, false);
    }

    @Deprecated
    public List<DomainBareJid> getXMPPServiceDomains() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getMucServiceDomains();
    }

    public boolean providesMucService(DomainBareJid domainBareJid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getMucServiceDiscoInfo(domainBareJid) != null;
    }

    DiscoverInfo getMucServiceDiscoInfo(DomainBareJid mucServiceAddress) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo discoInfo = KNOWN_MUC_SERVICES.get(mucServiceAddress);
        if (discoInfo != null) {
            return discoInfo;
        }
        discoInfo = this.serviceDiscoveryManager.discoverInfo(mucServiceAddress);
        if (!discoInfo.containsFeature("http://jabber.org/protocol/muc")) {
            return null;
        }
        KNOWN_MUC_SERVICES.put(mucServiceAddress, discoInfo);
        return discoInfo;
    }

    public Map<EntityBareJid, HostedRoom> getRoomsHostedBy(DomainBareJid serviceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        if (!this.providesMucService(serviceName)) {
            throw new MultiUserChatException.NotAMucServiceException(serviceName);
        }
        DiscoverItems discoverItems = this.serviceDiscoveryManager.discoverItems(serviceName);
        List<DiscoverItems.Item> items = discoverItems.getItems();
        HashMap<EntityBareJid, HostedRoom> answer = new HashMap<EntityBareJid, HostedRoom>(items.size());
        for (DiscoverItems.Item item : items) {
            HostedRoom hostedRoom = new HostedRoom(item);
            HostedRoom previousRoom = answer.put(hostedRoom.getJid(), hostedRoom);
            assert (previousRoom == null);
        }
        return answer;
    }

    public void decline(EntityBareJid room, EntityBareJid inviter, String reason) throws SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        MessageBuilder messageBuilder = (MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to(room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline(reason, inviter);
        mucUser.setDecline(decline);
        messageBuilder.addExtension(mucUser);
        connection.sendStanza(messageBuilder.build());
    }

    public void addInvitationListener(InvitationListener listener) {
        this.invitationsListeners.add(listener);
    }

    public void removeInvitationListener(InvitationListener listener) {
        this.invitationsListeners.remove(listener);
    }

    public void setAutoJoinOnReconnect(boolean autoJoin) {
        this.autoJoinOnReconnect = autoJoin;
    }

    public void setAutoJoinFailedCallback(AutoJoinFailedCallback failedCallback) {
        this.autoJoinFailedCallback = failedCallback;
        if (failedCallback != null) {
            this.setAutoJoinOnReconnect(true);
        }
    }

    public void setAutoJoinSuccessCallback(AutoJoinSuccessCallback successCallback) {
        this.autoJoinSuccessCallback = successCallback;
        if (successCallback != null) {
            this.setAutoJoinOnReconnect(true);
        }
    }

    void addJoinedRoom(EntityBareJid room) {
        this.joinedRooms.add(room);
    }

    void removeJoinedRoom(EntityBareJid room) {
        this.joinedRooms.remove(room);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CopyOnWriteArrayList<MucMessageInterceptor> getMessageInterceptors() {
        Set<MucMessageInterceptor> set = DEFAULT_MESSAGE_INTERCEPTORS;
        synchronized (set) {
            return new CopyOnWriteArrayList<MucMessageInterceptor>(DEFAULT_MESSAGE_INTERCEPTORS);
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection).addFeature("http://jabber.org/protocol/muc");
                final WeakReference<XMPPConnection> weakRefConnection = new WeakReference<XMPPConnection>(connection);
                ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(MultiUserChatManager.DISCO_NODE, new AbstractNodeInformationProvider(){

                    @Override
                    public List<DiscoverItems.Item> getNodeItems() {
                        XMPPConnection connection = (XMPPConnection)weakRefConnection.get();
                        if (connection == null) {
                            return Collections.emptyList();
                        }
                        Set<EntityBareJid> joinedRooms = MultiUserChatManager.getInstanceFor(connection).getJoinedRooms();
                        ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                        for (EntityBareJid room : joinedRooms) {
                            answer.add(new DiscoverItems.Item(room));
                        }
                        return answer;
                    }
                });
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, MultiUserChatManager>();
        INVITATION_FILTER = new AndFilter(StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter(new MUCUser()), new NotFilter(MessageTypeFilter.ERROR));
        KNOWN_MUC_SERVICES = new ExpirationCache(100, 86400000L);
        DEFAULT_MESSAGE_INTERCEPTORS = new HashSet<MucMessageInterceptor>();
    }
}

