/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.gradle.internal.serialize.ExceptionReplacingObjectInputStream;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.serialization.DeserializeMap;

class PayloadSerializerObjectInputStream
extends ExceptionReplacingObjectInputStream {
    private final Map<Short, ClassLoaderDetails> classLoaderDetails;
    private final DeserializeMap map;

    public PayloadSerializerObjectInputStream(InputStream inputStream, ClassLoader classLoader, Map<Short, ClassLoaderDetails> classLoaderDetails, DeserializeMap map) throws IOException {
        super(inputStream, classLoader);
        this.classLoaderDetails = classLoaderDetails;
        this.map = map;
    }

    protected ExceptionReplacingObjectInputStream createNewInstance(InputStream inputStream) throws IOException {
        return new PayloadSerializerObjectInputStream(inputStream, this.getClassLoader(), this.classLoaderDetails, this.map);
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        Class<?> aClass = this.readClass();
        ObjectStreamClass descriptor = ObjectStreamClass.lookupAny(aClass);
        if (descriptor == null) {
            throw new ClassNotFoundException(aClass.getName());
        }
        return descriptor;
    }

    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return desc.forClass();
    }

    private Class<?> readClass() throws IOException, ClassNotFoundException {
        short id = this.readShort();
        String className = this.readUTF();
        if (id == 0) {
            return super.lookupClass(className);
        }
        ClassLoaderDetails classLoader = this.classLoaderDetails.get(id);
        return this.map.resolveClass(classLoader, className);
    }

    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        int count = this.readInt();
        Class[] actualInterfaces = new Class[count];
        for (int i = 0; i < count; ++i) {
            actualInterfaces[i] = this.readClass();
        }
        Class<?> proxyClass = Proxy.getProxyClass(actualInterfaces[0].getClassLoader(), actualInterfaces);
        return proxyClass;
    }

    protected Class<?> lookupClass(String type) throws ClassNotFoundException {
        try {
            return super.lookupClass(type);
        }
        catch (ClassNotFoundException e) {
            for (ClassLoaderDetails details : this.classLoaderDetails.values()) {
                try {
                    return this.map.resolveClass(details, type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw e;
        }
    }
}

