/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.api;

import java.io.File;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugins.ide.internal.generator.generator.Generator;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class GeneratorTask<T>
extends ConventionTask {
    private File inputFile;
    private File outputFile;
    protected final MutableActionSet<T> beforeConfigured = new MutableActionSet();
    protected final MutableActionSet<T> afterConfigured = new MutableActionSet();
    protected Generator<T> generator;
    protected T domainObject;

    public GeneratorTask() {
        if (!this.getIncremental()) {
            this.getOutputs().upToDateWhen(Specs.satisfyNone());
        }
    }

    @Internal
    protected boolean getIncremental() {
        return false;
    }

    @TaskAction
    void generate() {
        File inputFile = this.getInputFileIfExists();
        if (inputFile != null) {
            try {
                this.domainObject = this.generator.read(inputFile);
            }
            catch (RuntimeException e) {
                throw new GradleException(String.format("Cannot parse file '%s'.\n       Perhaps this file was tinkered with? In that case try delete this file and then retry.", inputFile), (Throwable)e);
            }
        } else {
            this.domainObject = this.generator.defaultInstance();
        }
        this.beforeConfigured.execute(this.domainObject);
        this.generator.configure(this.domainObject);
        this.afterConfigured.execute(this.domainObject);
        this.generator.write(this.domainObject, this.getOutputFile());
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Internal(value="Covered by inputFileIfExists")
    public File getInputFile() {
        return this.inputFile != null ? this.inputFile : this.getOutputFile();
    }

    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    protected File getInputFileIfExists() {
        File inputFile = this.getInputFile();
        if (inputFile != null && inputFile.exists()) {
            return inputFile;
        }
        return null;
    }

    public void setInputFile(@Nullable File inputFile) {
        this.inputFile = inputFile;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }
}

