# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class TelegrafsService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """TelegrafsService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def delete_telegrafs_id(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_telegrafs_id_prepare(telegraf_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_telegrafs_id_async(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a Telegraf configuration.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_telegrafs_id_prepare(telegraf_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_telegrafs_id_prepare(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_telegrafs_id', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_telegrafs_id_labels_id(self, telegraf_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_labels_id(telegraf_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_labels_id_with_http_info(telegraf_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_labels_id_with_http_info(telegraf_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_labels_id_with_http_info(self, telegraf_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_labels_id_with_http_info(telegraf_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_telegrafs_id_labels_id_prepare(telegraf_id, label_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_telegrafs_id_labels_id_async(self, telegraf_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a Telegraf config.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_telegrafs_id_labels_id_prepare(telegraf_id, label_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_telegrafs_id_labels_id_prepare(self, telegraf_id, label_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'label_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_telegrafs_id_labels_id', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_telegrafs_id_labels_id`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_telegrafs_id_members_id(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_members_id(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_members_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_members_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_members_id_with_http_info(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_members_id_with_http_info(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_telegrafs_id_members_id_prepare(user_id, telegraf_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_telegrafs_id_members_id_async(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a Telegraf config.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_telegrafs_id_members_id_prepare(user_id, telegraf_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_telegrafs_id_members_id_prepare(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'telegraf_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_telegrafs_id_members_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_telegrafs_id_members_id`")  # noqa: E501
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id_members_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_telegrafs_id_owners_id(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_owners_id(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_owners_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_owners_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_owners_id_with_http_info(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_owners_id_with_http_info(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_telegrafs_id_owners_id_prepare(user_id, telegraf_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_telegrafs_id_owners_id_async(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a Telegraf config.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_telegrafs_id_owners_id_prepare(user_id, telegraf_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_telegrafs_id_owners_id_prepare(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'telegraf_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_telegrafs_id_owners_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_telegrafs_id_owners_id`")  # noqa: E501
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id_owners_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_telegrafs(self, **kwargs):  # noqa: E501,D401,D403
        """List all Telegraf configurations.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: The organization ID the Telegraf config belongs to.
        :return: Telegrafs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_telegrafs_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List all Telegraf configurations.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: The organization ID the Telegraf config belongs to.
        :return: Telegrafs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Telegrafs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_telegrafs_async(self, **kwargs):  # noqa: E501,D401,D403
        """List all Telegraf configurations.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: The organization ID the Telegraf config belongs to.
        :return: Telegrafs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Telegrafs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_telegrafs_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'org_id']  # noqa: E501
        self._check_operation_params('get_telegrafs', all_params, local_var_params)

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_telegrafs_id(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str accept:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str accept:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_id_prepare(telegraf_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='str',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_telegrafs_id_async(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a Telegraf configuration.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str accept:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_id_prepare(telegraf_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='str',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_telegrafs_id_prepare(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span', 'accept']  # noqa: E501
        self._check_operation_params('get_telegrafs_id', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/toml', 'application/json', 'application/octet-stream'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_telegrafs_id_labels(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_labels(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_labels_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_labels_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_labels_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_labels_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_id_labels_prepare(telegraf_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_telegrafs_id_labels_async(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a Telegraf config.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_id_labels_prepare(telegraf_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_telegrafs_id_labels_prepare(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_telegrafs_id_labels', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id_labels`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_telegrafs_id_members(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_members(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_members_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_members_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_members_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_members_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_id_members_prepare(telegraf_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_telegrafs_id_members_async(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a Telegraf config.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_id_members_prepare(telegraf_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_telegrafs_id_members_prepare(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_telegrafs_id_members', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id_members`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_telegrafs_id_owners(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_owners(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_owners_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_owners_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_owners_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_owners_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_id_owners_prepare(telegraf_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_telegrafs_id_owners_async(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a Telegraf configuration.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_telegrafs_id_owners_prepare(telegraf_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_telegrafs_id_owners_prepare(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_telegrafs_id_owners', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id_owners`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_telegrafs(self, telegraf_plugin_request, **kwargs):  # noqa: E501,D401,D403
        """Create a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs(telegraf_plugin_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TelegrafPluginRequest telegraf_plugin_request: Telegraf configuration to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_with_http_info(telegraf_plugin_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_with_http_info(telegraf_plugin_request, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_with_http_info(self, telegraf_plugin_request, **kwargs):  # noqa: E501,D401,D403
        """Create a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_with_http_info(telegraf_plugin_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TelegrafPluginRequest telegraf_plugin_request: Telegraf configuration to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_telegrafs_prepare(telegraf_plugin_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Telegraf',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_telegrafs_async(self, telegraf_plugin_request, **kwargs):  # noqa: E501,D401,D403
        """Create a Telegraf configuration.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param TelegrafPluginRequest telegraf_plugin_request: Telegraf configuration to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_telegrafs_prepare(telegraf_plugin_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Telegraf',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_telegrafs_prepare(self, telegraf_plugin_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_plugin_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_telegrafs', all_params, local_var_params)
        # verify the required parameter 'telegraf_plugin_request' is set
        if ('telegraf_plugin_request' not in local_var_params or
                local_var_params['telegraf_plugin_request'] is None):
            raise ValueError("Missing the required parameter `telegraf_plugin_request` when calling `post_telegrafs`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'telegraf_plugin_request' in local_var_params:
            body_params = local_var_params['telegraf_plugin_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_telegrafs_id_labels(self, telegraf_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_labels(telegraf_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_id_labels_with_http_info(telegraf_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_id_labels_with_http_info(telegraf_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_id_labels_with_http_info(self, telegraf_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_labels_with_http_info(telegraf_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_telegrafs_id_labels_prepare(telegraf_id, label_mapping, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_telegrafs_id_labels_async(self, telegraf_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a Telegraf config.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_telegrafs_id_labels_prepare(telegraf_id, label_mapping, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_telegrafs_id_labels_prepare(self, telegraf_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_telegrafs_id_labels', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `post_telegrafs_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_telegrafs_id_labels`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_telegrafs_id_members(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_members(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_id_members_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_id_members_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_id_members_with_http_info(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_members_with_http_info(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_telegrafs_id_members_prepare(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_telegrafs_id_members_async(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a Telegraf config.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_telegrafs_id_members_prepare(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_telegrafs_id_members_prepare(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_telegrafs_id_members', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `post_telegrafs_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_telegrafs_id_members`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_telegrafs_id_owners(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_owners(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_id_owners_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_id_owners_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_id_owners_with_http_info(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_owners_with_http_info(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_telegrafs_id_owners_prepare(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_telegrafs_id_owners_async(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a Telegraf configuration.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf configuration ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_telegrafs_id_owners_prepare(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_telegrafs_id_owners_prepare(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_telegrafs_id_owners', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `post_telegrafs_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_telegrafs_id_owners`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def put_telegrafs_id(self, telegraf_id, telegraf_plugin_request, **kwargs):  # noqa: E501,D401,D403
        """Update a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_telegrafs_id(telegraf_id, telegraf_plugin_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param TelegrafPluginRequest telegraf_plugin_request: Telegraf configuration update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_telegrafs_id_with_http_info(telegraf_id, telegraf_plugin_request, **kwargs)  # noqa: E501
        else:
            (data) = self.put_telegrafs_id_with_http_info(telegraf_id, telegraf_plugin_request, **kwargs)  # noqa: E501
            return data

    def put_telegrafs_id_with_http_info(self, telegraf_id, telegraf_plugin_request, **kwargs):  # noqa: E501,D401,D403
        """Update a Telegraf configuration.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_telegrafs_id_with_http_info(telegraf_id, telegraf_plugin_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param TelegrafPluginRequest telegraf_plugin_request: Telegraf configuration update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_telegrafs_id_prepare(telegraf_id, telegraf_plugin_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Telegraf',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def put_telegrafs_id_async(self, telegraf_id, telegraf_plugin_request, **kwargs):  # noqa: E501,D401,D403
        """Update a Telegraf configuration.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param TelegrafPluginRequest telegraf_plugin_request: Telegraf configuration update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Telegraf
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_telegrafs_id_prepare(telegraf_id, telegraf_plugin_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Telegraf',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _put_telegrafs_id_prepare(self, telegraf_id, telegraf_plugin_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['telegraf_id', 'telegraf_plugin_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('put_telegrafs_id', all_params, local_var_params)
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `put_telegrafs_id`")  # noqa: E501
        # verify the required parameter 'telegraf_plugin_request' is set
        if ('telegraf_plugin_request' not in local_var_params or
                local_var_params['telegraf_plugin_request'] is None):
            raise ValueError("Missing the required parameter `telegraf_plugin_request` when calling `put_telegrafs_id`")  # noqa: E501

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'telegraf_plugin_request' in local_var_params:
            body_params = local_var_params['telegraf_plugin_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
