/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { ContactEntry, OperationFail, OperationOk } from "@gnu-taler/taler-util";
import { ErrorAlertView } from "../../components/CurrentAlerts.js";
import { ErrorAlert } from "../../context/alert.js";
import { TextFieldHandler } from "../../mui/handlers.js";
import { StateViewMap, compose } from "../../utils/index.js";
import { useComponentState } from "./state.js";
import { ConfirmAddContactView, VerifyContactView } from "./views.js";
import { useBackendContext } from "../../context/backend.js";

export interface Props {
  contact?: ContactEntry;
  onBack: () => Promise<void>;
  noDebounce?: boolean;
}

export type State =
  | State.LoadingUriError
  | State.Confirm
  | State.Verify;

export namespace State {
  export interface LoadingUriError {
    status: "error";
    error: ErrorAlert;
  }

  export interface BaseInfo {
    error: undefined;
  }
  export interface Confirm extends BaseInfo {
    status: "confirm";
    contact: ContactEntry;
    onCancel: () => Promise<void>;
    onConfirm: () => Promise<void>;
    error: undefined;
  }
  export interface Verify extends BaseInfo {
    status: "verify";
    error: undefined;

    onCancel: () => Promise<void>;
    onAccept: () => Promise<void>;

    alias: TextFieldHandler,
    aliasType: TextFieldHandler,
    mailboxUri: TextFieldHandler,
    result: OperationOk<"ok">
    | OperationFail<"already-added">
  }
}
const viewMapping: StateViewMap<State> = {
  error: ErrorAlertView,
  confirm: ConfirmAddContactView,
  verify: VerifyContactView,
};

export const AddContact = compose(
  "AddContact",
  (p: Props) => useComponentState(p),
  viewMapping,
);
