package App::InteractivePerlTutorial::Chapter::Control::Elsif;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'The elsif clause';

1;
__DATA__

=encoding utf-8

=head1 The elsif clause

If you want to check a number of conditional expressions, one after another, and you only care about the first expression that is true, you can use the C<elsif> clause. When one of the conditional expressions is true, the corresponding block is executed and the rest of the expressions are skipped.

  if ( ! defined $x) {
    print "The value is undef.\n";
  } elsif ($x =~ /^-?\d+\.?$/) {
    print "The value is an integer.\n";
  } elsif ($x =~ /^-?\d*\.\d+$/) {
    print "The value is a _simple_ floating-point number.\n";
  } elsif ($x eq '') {
    print "The value is the empty string.\n";
  } else {
    print "The value is the string '$x'.\n";
  }


=cut
