/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.iterator;

import com.sun.media.jai.iterator.RookIterFallback;
import com.sun.media.jai.iterator.WrapperRI;
import com.sun.media.jai.iterator.WrapperWRI;
import com.sun.media.jai.iterator.WritableRookIterFallback;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import javax.media.jai.iterator.RookIter;
import javax.media.jai.iterator.WritableRookIter;

public class RookIterFactory {
    private RookIterFactory() {
    }

    public static RookIter create(RenderedImage renderedImage, Rectangle rectangle) {
        SampleModel sampleModel;
        if (rectangle == null) {
            rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        }
        if ((sampleModel = renderedImage.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sampleModel.getDataType()) {
                default: 
            }
        }
        return new RookIterFallback(renderedImage, rectangle);
    }

    public static RookIter create(Raster raster, Rectangle rectangle) {
        WrapperRI wrapperRI = new WrapperRI(raster);
        return RookIterFactory.create(wrapperRI, rectangle);
    }

    public static WritableRookIter createWritable(WritableRenderedImage writableRenderedImage, Rectangle rectangle) {
        SampleModel sampleModel;
        if (rectangle == null) {
            rectangle = new Rectangle(writableRenderedImage.getMinX(), writableRenderedImage.getMinY(), writableRenderedImage.getWidth(), writableRenderedImage.getHeight());
        }
        if ((sampleModel = writableRenderedImage.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sampleModel.getDataType()) {
                default: 
            }
        }
        return new WritableRookIterFallback(writableRenderedImage, rectangle);
    }

    public static WritableRookIter createWritable(WritableRaster writableRaster, Rectangle rectangle) {
        WrapperWRI wrapperWRI = new WrapperWRI(writableRaster);
        return RookIterFactory.createWritable(wrapperWRI, rectangle);
    }
}

