/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.document;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.TextPosition;

public class CharSegment
extends TextSegment {
    boolean overprint = false;

    public CharSegment(float x1, float x2, float y1, float y2, String text, String fontName, float fontSize) {
        super(x1, x2, y1, y2, text, fontName, fontSize);
    }

    public CharSegment(float x1, float x2, float y1, float y2, String text, PDFont font, float fontSize) {
        super(x1, x2, y1, y2, text, CharSegment.findFontName(font), fontSize);
    }

    public CharSegment(float x1, float x2, float y1, float y2) {
        super(x1, x2, y1, y2);
    }

    public CharSegment(TextPosition tPos) {
        super(tPos.getX(), tPos.getX() + tPos.getWidth(), tPos.getY(), tPos.getY() + tPos.getFontSize() * tPos.getYScale(), tPos.getCharacter(), CharSegment.findFontName(tPos.getFont()), tPos.getFontSize() * tPos.getYScale());
        String fontName = tPos.getFont().getBaseFont();
    }

    public CharSegment(TextPosition tPos, GenericSegment pageDim) {
        super(tPos.getX(), tPos.getX() + tPos.getWidth(), pageDim.getY2() - tPos.getY(), pageDim.getY2() - tPos.getY() + tPos.getFontSize() * tPos.getYScale(), tPos.getCharacter(), tPos.getFont().getBaseFont(), tPos.getFontSize() * tPos.getYScale());
        String fontName = tPos.getFont().getBaseFont();
    }

    protected static String findFontName(PDFont font) {
        if (font.getBaseFont().matches("^[A-Z]{6}\\+.+")) {
            return font.getBaseFont().substring(7);
        }
        return font.getBaseFont();
    }

    public boolean isOverprint() {
        return this.overprint;
    }

    public void setOverprint(boolean overprint) {
        this.overprint = overprint;
    }
}

