/*
 Copyright 2015 Alexander Borisov

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Author: lex.borisov@gmail.com (Alexander Borisov)
*/

#include "myhtml/utils/resources.h"
#include "tag.h"

static const myhtml_tag_context_t myhtml_tag_base_list[MyHTML_TAG_LAST_ENTRY] = 
{
	{MyHTML_TAG__UNDEF, "-undef", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG__TEXT, "-text", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG__COMMENT, "_comment", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG__DOCTYPE, "!doctype", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_A, "a", 1, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ABBR, "abbr", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ACRONYM, "acronym", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ADDRESS, "address", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ANNOTATION_XML, "annotation-xml", 14, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_APPLET, "applet", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_AREA, "area", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ARTICLE, "article", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ASIDE, "aside", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_AUDIO, "audio", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_B, "b", 1, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BASE, "base", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BASEFONT, "basefont", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BDI, "bdi", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BDO, "bdo", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BGSOUND, "bgsound", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BIG, "big", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BLINK, "blink", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BLOCKQUOTE, "blockquote", 10, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BODY, "body", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BR, "br", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_BUTTON, "button", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_CANVAS, "canvas", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_CAPTION, "caption", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_CENTER, "center", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_CITE, "cite", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_CODE, "code", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_COL, "col", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_COLGROUP, "colgroup", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_COMMAND, "command", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_COMMENT, "comment", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DATALIST, "datalist", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DD, "dd", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DEL, "del", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DETAILS, "details", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DFN, "dfn", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DIALOG, "dialog", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DIR, "dir", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DIV, "div", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DL, "dl", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DT, "dt", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_EM, "em", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_EMBED, "embed", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FIELDSET, "fieldset", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FIGCAPTION, "figcaption", 10, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FIGURE, "figure", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FONT, "font", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FOOTER, "footer", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FORM, "form", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FRAME, "frame", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FRAMESET, "frameset", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_H1, "h1", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_H2, "h2", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_H3, "h3", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_H4, "h4", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_H5, "h5", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_H6, "h6", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_HEAD, "head", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_HEADER, "header", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_HGROUP, "hgroup", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_HR, "hr", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_HTML, "html", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON|MyHTML_TAG_CATEGORIES_SCOPE_TABLE, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_I, "i", 1, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_IFRAME, "iframe", 6, MyHTML_TOKENIZER_STATE_RAWTEXT, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_IMAGE, "image", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_IMG, "img", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_INPUT, "input", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_INS, "ins", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ISINDEX, "isindex", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_KBD, "kbd", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_KEYGEN, "keygen", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_LABEL, "label", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_LEGEND, "legend", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_LI, "li", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_LINK, "link", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_LISTING, "listing", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MAIN, "main", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MAP, "map", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MARK, "mark", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MARQUEE, "marquee", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MENU, "menu", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MENUITEM, "menuitem", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_META, "meta", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_METER, "meter", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MTEXT, "mtext", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_NAV, "nav", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_NOBR, "nobr", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_NOEMBED, "noembed", 7, MyHTML_TOKENIZER_STATE_RAWTEXT, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_NOFRAMES, "noframes", 8, MyHTML_TOKENIZER_STATE_RAWTEXT, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_NOSCRIPT, "noscript", 8, MyHTML_TOKENIZER_STATE_RAWTEXT, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_OBJECT, "object", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_OL, "ol", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_OPTGROUP, "optgroup", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY|MyHTML_TAG_CATEGORIES_SCOPE_SELECT, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_OPTION, "option", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY|MyHTML_TAG_CATEGORIES_SCOPE_SELECT, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_OUTPUT, "output", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_P, "p", 1, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_PARAM, "param", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_PLAINTEXT, "plaintext", 9, MyHTML_TOKENIZER_STATE_PLAINTEXT, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_PRE, "pre", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_PROGRESS, "progress", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_Q, "q", 1, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_RB, "rb", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_RP, "rp", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_RT, "rt", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_RTC, "rtc", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_RUBY, "ruby", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_S, "s", 1, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SAMP, "samp", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SCRIPT, "script", 6, MyHTML_TOKENIZER_STATE_SCRIPT_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SECTION, "section", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SELECT, "select", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SMALL, "small", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SOURCE, "source", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SPAN, "span", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_STRIKE, "strike", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_STRONG, "strong", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_STYLE, "style", 5, MyHTML_TOKENIZER_STATE_RAWTEXT, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SUB, "sub", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SUMMARY, "summary", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SUP, "sup", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SVG, "svg", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TABLE, "table", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON|MyHTML_TAG_CATEGORIES_SCOPE_TABLE, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TBODY, "tbody", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TD, "td", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TEMPLATE, "template", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON|MyHTML_TAG_CATEGORIES_SCOPE_TABLE, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TEXTAREA, "textarea", 8, MyHTML_TOKENIZER_STATE_RCDATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TFOOT, "tfoot", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TH, "th", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_THEAD, "thead", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TIME, "time", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TITLE, "title", 5, MyHTML_TOKENIZER_STATE_RCDATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TR, "tr", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TRACK, "track", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TT, "tt", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_U, "u", 1, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_FORMATTING, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_UL, "ul", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_VAR, "var", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_VIDEO, "video", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_WBR, "wbr", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_XMP, "xmp", 3, MyHTML_TOKENIZER_STATE_RAWTEXT, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ALTGLYPH, "altGlyph", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ALTGLYPHDEF, "altGlyphDef", 11, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ALTGLYPHITEM, "altGlyphItem", 12, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ANIMATE, "animate", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ANIMATECOLOR, "animateColor", 12, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ANIMATEMOTION, "animateMotion", 13, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ANIMATETRANSFORM, "animateTransform", 16, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_CIRCLE, "circle", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_CLIPPATH, "clipPath", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_COLOR_PROFILE, "color-profile", 13, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_CURSOR, "cursor", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DEFS, "defs", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_DESC, "desc", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_ELLIPSE, "ellipse", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEBLEND, "feBlend", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FECOLORMATRIX, "feColorMatrix", 13, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FECOMPONENTTRANSFER, "feComponentTransfer", 19, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FECOMPOSITE, "feComposite", 11, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FECONVOLVEMATRIX, "feConvolveMatrix", 16, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEDIFFUSELIGHTING, "feDiffuseLighting", 17, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEDISPLACEMENTMAP, "feDisplacementMap", 17, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEDISTANTLIGHT, "feDistantLight", 14, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEDROPSHADOW, "feDropShadow", 12, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEFLOOD, "feFlood", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEFUNCA, "feFuncA", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEFUNCB, "feFuncB", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEFUNCG, "feFuncG", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEFUNCR, "feFuncR", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEGAUSSIANBLUR, "feGaussianBlur", 14, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEIMAGE, "feImage", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEMERGE, "feMerge", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEMERGENODE, "feMergeNode", 11, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEMORPHOLOGY, "feMorphology", 12, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEOFFSET, "feOffset", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FEPOINTLIGHT, "fePointLight", 12, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FESPECULARLIGHTING, "feSpecularLighting", 18, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FESPOTLIGHT, "feSpotLight", 11, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FETILE, "feTile", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FETURBULENCE, "feTurbulence", 12, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FILTER, "filter", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FONT_FACE, "font-face", 9, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FONT_FACE_FORMAT, "font-face-format", 16, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FONT_FACE_NAME, "font-face-name", 14, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FONT_FACE_SRC, "font-face-src", 13, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FONT_FACE_URI, "font-face-uri", 13, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_FOREIGNOBJECT, "foreignObject", 13, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_G, "g", 1, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_GLYPH, "glyph", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_GLYPHREF, "glyphRef", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_HKERN, "hkern", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_LINE, "line", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_LINEARGRADIENT, "linearGradient", 14, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MARKER, "marker", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MASK, "mask", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_METADATA, "metadata", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MISSING_GLYPH, "missing-glyph", 13, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MPATH, "mpath", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_PATH, "path", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_PATTERN, "pattern", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_POLYGON, "polygon", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_POLYLINE, "polyline", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_RADIALGRADIENT, "radialGradient", 14, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_RECT, "rect", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SET, "set", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_STOP, "stop", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SWITCH, "switch", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_SYMBOL, "symbol", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TEXT, "text", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TEXTPATH, "textPath", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TREF, "tref", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_TSPAN, "tspan", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_USE, "use", 3, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_VIEW, "view", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_VKERN, "vkern", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MATH, "math", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MACTION, "maction", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MALIGNGROUP, "maligngroup", 11, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MALIGNMARK, "malignmark", 10, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MENCLOSE, "menclose", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MERROR, "merror", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MFENCED, "mfenced", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MFRAC, "mfrac", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MGLYPH, "mglyph", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MI, "mi", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MLABELEDTR, "mlabeledtr", 10, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MLONGDIV, "mlongdiv", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MMULTISCRIPTS, "mmultiscripts", 13, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MN, "mn", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MO, "mo", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MOVER, "mover", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MPADDED, "mpadded", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MPHANTOM, "mphantom", 8, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MROOT, "mroot", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MROW, "mrow", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MS, "ms", 2, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSCARRIES, "mscarries", 9, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSCARRY, "mscarry", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSGROUP, "msgroup", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSLINE, "msline", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSPACE, "mspace", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSQRT, "msqrt", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSROW, "msrow", 5, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSTACK, "mstack", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSTYLE, "mstyle", 6, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSUB, "msub", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSUP, "msup", 4, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG_MSUBSUP, "msubsup", 7, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	},
	{MyHTML_TAG__END_OF_FILE, "-end-of-file", 12, MyHTML_TOKENIZER_STATE_DATA, 
		{
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY, MyHTML_TAG_CATEGORIES_ORDINARY, 
			MyHTML_TAG_CATEGORIES_ORDINARY
		}
	}
};


static const myhtml_tag_static_list_t myhtml_tag_static_list_index[] = 
{
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_USE], 0, 6},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_H5], 480, 8},
	{&myhtml_tag_base_list[MyHTML_TAG_I], 481, 9},
	{&myhtml_tag_base_list[MyHTML_TAG_DIALOG], 0, 10},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_BODY], 0, 12},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_ANIMATECOLOR], 0, 14},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_BUTTON], 0, 16},
	{&myhtml_tag_base_list[MyHTML_TAG_DEFS], 0, 17},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_PATTERN], 482, 21},
	{&myhtml_tag_base_list[MyHTML_TAG_FIGURE], 483, 22},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_B], 484, 25},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_OL], 0, 27},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_DETAILS], 485, 29},
	{&myhtml_tag_base_list[MyHTML_TAG_FEBLEND], 486, 30},
	{&myhtml_tag_base_list[MyHTML_TAG_MN], 0, 31},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_ELLIPSE], 0, 37},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FEFUNCB], 0, 39},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FEDROPSHADOW], 0, 41},
	{&myhtml_tag_base_list[MyHTML_TAG_THEAD], 0, 42},
	{&myhtml_tag_base_list[MyHTML_TAG_FETURBULENCE], 0, 43},
	{&myhtml_tag_base_list[MyHTML_TAG_LINE], 0, 44},
	{&myhtml_tag_base_list[MyHTML_TAG_MSTACK], 0, 45},
	{&myhtml_tag_base_list[MyHTML_TAG_DL], 0, 46},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_SCRIPT], 487, 48},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FONT_FACE_NAME], 0, 50},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_PLAINTEXT], 0, 53},
	{&myhtml_tag_base_list[MyHTML_TAG_NOSCRIPT], 0, 54},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_PROGRESS], 0, 56},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FOREIGNOBJECT], 0, 58},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MAIN], 0, 61},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_BDO], 0, 63},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_ISINDEX], 0, 65},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_INPUT], 0, 68},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_CAPTION], 0, 70},
	{&myhtml_tag_base_list[MyHTML_TAG_H3], 0, 71},
	{&myhtml_tag_base_list[MyHTML_TAG_G], 0, 72},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_LINEARGRADIENT], 0, 79},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_ANIMATETRANSFORM], 0, 82},
	{&myhtml_tag_base_list[MyHTML_TAG_ARTICLE], 488, 83},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_XMP], 0, 85},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_TT], 0, 89},
	{&myhtml_tag_base_list[MyHTML_TAG_SVG], 489, 90},
	{&myhtml_tag_base_list[MyHTML_TAG_P], 490, 91},
	{&myhtml_tag_base_list[MyHTML_TAG_RUBY], 0, 92},
	{&myhtml_tag_base_list[MyHTML_TAG_FECOLORMATRIX], 0, 93},
	{&myhtml_tag_base_list[MyHTML_TAG_TSPAN], 491, 94},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MMULTISCRIPTS], 0, 96},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MSUB], 0, 98},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_ALTGLYPHDEF], 0, 102},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_RT], 492, 104},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_BIG], 494, 106},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FONT_FACE_FORMAT], 0, 108},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FECOMPONENTTRANSFER], 0, 114},
	{&myhtml_tag_base_list[MyHTML_TAG_FIGCAPTION], 0, 115},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_STYLE], 0, 117},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_CIRCLE], 0, 120},
	{&myhtml_tag_base_list[MyHTML_TAG_VAR], 0, 121},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_VIEW], 0, 126},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_ASIDE], 0, 128},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_PATH], 0, 130},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_NOFRAMES], 0, 132},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_H1], 0, 134},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_LEGEND], 0, 136},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_OBJECT], 495, 138},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MFENCED], 496, 140},
	{&myhtml_tag_base_list[MyHTML_TAG_META], 0, 141},
	{&myhtml_tag_base_list[MyHTML_TAG_NAV], 0, 142},
	{&myhtml_tag_base_list[MyHTML_TAG_TABLE], 497, 143},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_RP], 0, 150},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MROW], 0, 153},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MPATH], 0, 159},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MS], 0, 163},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_ABBR], 0, 165},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_LI], 0, 168},
	{&myhtml_tag_base_list[MyHTML_TAG_SUMMARY], 498, 169},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_TEXT], 0, 177},
	{&myhtml_tag_base_list[MyHTML_TAG_CENTER], 499, 178},
	{&myhtml_tag_base_list[MyHTML_TAG_TH], 500, 179},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_AUDIO], 0, 188},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MARK], 502, 190},
	{&myhtml_tag_base_list[MyHTML_TAG_MSROW], 0, 191},
	{&myhtml_tag_base_list[MyHTML_TAG_DIR], 0, 192},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MSGROUP], 503, 195},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_HKERN], 504, 200},
	{&myhtml_tag_base_list[MyHTML_TAG_FEPOINTLIGHT], 0, 201},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_EMBED], 0, 206},
	{&myhtml_tag_base_list[MyHTML_TAG_RECT], 505, 207},
	{&myhtml_tag_base_list[MyHTML_TAG_PARAM], 507, 208},
	{&myhtml_tag_base_list[MyHTML_TAG_DT], 508, 209},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FEDISPLACEMENTMAP], 0, 214},
	{&myhtml_tag_base_list[MyHTML_TAG_BDI], 0, 215},
	{&myhtml_tag_base_list[MyHTML_TAG_H6], 0, 216},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_BLINK], 0, 220},
	{&myhtml_tag_base_list[MyHTML_TAG_MAP], 509, 221},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_GLYPHREF], 0, 224},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_ALTGLYPH], 0, 233},
	{&myhtml_tag_base_list[MyHTML_TAG_TEXTPATH], 510, 234},
	{&myhtml_tag_base_list[MyHTML_TAG__TEXT], 0, 235},
	{&myhtml_tag_base_list[MyHTML_TAG_VKERN], 511, 236},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG__UNDEF], 0, 238},
	{&myhtml_tag_base_list[MyHTML_TAG_MENU], 0, 239},
	{&myhtml_tag_base_list[MyHTML_TAG_CITE], 513, 240},
	{&myhtml_tag_base_list[MyHTML_TAG_LINK], 0, 241},
	{&myhtml_tag_base_list[MyHTML_TAG_HR], 0, 242},
	{&myhtml_tag_base_list[MyHTML_TAG_RADIALGRADIENT], 0, 243},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_HEADER], 0, 245},
	{&myhtml_tag_base_list[MyHTML_TAG_ACRONYM], 0, 246},
	{&myhtml_tag_base_list[MyHTML_TAG_TBODY], 0, 247},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MO], 0, 249},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MSCARRIES], 0, 251},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FEFUNCG], 0, 256},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FRAME], 0, 258},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_SET], 0, 264},
	{&myhtml_tag_base_list[MyHTML_TAG_FEIMAGE], 514, 265},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_SAMP], 515, 268},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_TRACK], 0, 270},
	{&myhtml_tag_base_list[MyHTML_TAG_LISTING], 0, 271},
	{&myhtml_tag_base_list[MyHTML_TAG_FONT_FACE], 0, 272},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_AREA], 0, 275},
	{&myhtml_tag_base_list[MyHTML_TAG_SYMBOL], 0, 276},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_U], 0, 278},
	{&myhtml_tag_base_list[MyHTML_TAG_H4], 516, 279},
	{&myhtml_tag_base_list[MyHTML_TAG_ANIMATEMOTION], 0, 280},
	{&myhtml_tag_base_list[MyHTML_TAG_SUB], 518, 281},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FEFUNCA], 0, 283},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_S], 519, 293},
	{&myhtml_tag_base_list[MyHTML_TAG_FIELDSET], 520, 294},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_INS], 0, 301},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_OPTGROUP], 0, 304},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_SPAN], 0, 306},
	{&myhtml_tag_base_list[MyHTML_TAG_BLOCKQUOTE], 0, 307},
	{&myhtml_tag_base_list[MyHTML_TAG_DEL], 522, 308},
	{&myhtml_tag_base_list[MyHTML_TAG_A], 0, 309},
	{&myhtml_tag_base_list[MyHTML_TAG_SMALL], 0, 310},
	{&myhtml_tag_base_list[MyHTML_TAG_BR], 523, 311},
	{&myhtml_tag_base_list[MyHTML_TAG_MARKER], 524, 312},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FOOTER], 525, 314},
	{&myhtml_tag_base_list[MyHTML_TAG_BASE], 0, 315},
	{&myhtml_tag_base_list[MyHTML_TAG_Q], 526, 316},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MATH], 0, 319},
	{&myhtml_tag_base_list[MyHTML_TAG__DOCTYPE], 0, 320},
	{&myhtml_tag_base_list[MyHTML_TAG_SUP], 527, 321},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_DESC], 0, 323},
	{&myhtml_tag_base_list[MyHTML_TAG_TEMPLATE], 0, 324},
	{&myhtml_tag_base_list[MyHTML_TAG_COMMAND], 0, 325},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_RTC], 0, 329},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_IMAGE], 0, 336},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_METER], 528, 340},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_H2], 0, 342},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FESPOTLIGHT], 0, 344},
	{&myhtml_tag_base_list[MyHTML_TAG_NOBR], 0, 345},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_VIDEO], 0, 347},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_IMG], 0, 353},
	{&myhtml_tag_base_list[MyHTML_TAG_DATALIST], 0, 354},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MSCARRY], 0, 356},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_NOEMBED], 0, 361},
	{&myhtml_tag_base_list[MyHTML_TAG_DD], 529, 362},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_UL], 0, 365},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MI], 0, 378},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_HTML], 0, 382},
	{&myhtml_tag_base_list[MyHTML_TAG_FESPECULARLIGHTING], 0, 383},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FONT], 530, 387},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_SWITCH], 0, 390},
	{&myhtml_tag_base_list[MyHTML_TAG_MLONGDIV], 0, 391},
	{&myhtml_tag_base_list[MyHTML_TAG_GLYPH], 0, 392},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FEDISTANTLIGHT], 0, 394},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_COMMENT], 0, 396},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_TIME], 0, 402},
	{&myhtml_tag_base_list[MyHTML_TAG_IFRAME], 0, 403},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FORM], 0, 405},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_PRE], 531, 407},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FECONVOLVEMATRIX], 0, 409},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_FEGAUSSIANBLUR], 0, 412},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_BASEFONT], 532, 414},
	{&myhtml_tag_base_list[MyHTML_TAG_SECTION], 533, 415},
	{&myhtml_tag_base_list[MyHTML_TAG_MENCLOSE], 0, 416},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_ALTGLYPHITEM], 0, 421},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MARQUEE], 0, 424},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_DFN], 0, 429},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MSLINE], 534, 432},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_DIV], 536, 434},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_TEXTAREA], 0, 444},
	{&myhtml_tag_base_list[MyHTML_TAG_POLYLINE], 0, 445},
	{&myhtml_tag_base_list[MyHTML_TAG_FEFUNCR], 0, 446},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_APPLET], 537, 453},
	{&myhtml_tag_base_list[MyHTML_TAG_MSUP], 0, 454},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_CLIPPATH], 0, 460},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_COL], 538, 463},
	{&myhtml_tag_base_list[MyHTML_TAG_EM], 0, 464},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MTEXT], 539, 472},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_MGLYPH], 0, 478},
	{NULL, 0},
	{&myhtml_tag_base_list[MyHTML_TAG_KBD], 0, 480},
	{&myhtml_tag_base_list[MyHTML_TAG_ADDRESS], 0, 481},
	{&myhtml_tag_base_list[MyHTML_TAG_POLYGON], 0, 482},
	{&myhtml_tag_base_list[MyHTML_TAG_FETILE], 0, 483},
	{&myhtml_tag_base_list[MyHTML_TAG__COMMENT], 0, 484},
	{&myhtml_tag_base_list[MyHTML_TAG_FONT_FACE_SRC], 0, 485},
	{&myhtml_tag_base_list[MyHTML_TAG_FEFLOOD], 0, 486},
	{&myhtml_tag_base_list[MyHTML_TAG_SELECT], 0, 487},
	{&myhtml_tag_base_list[MyHTML_TAG_ANIMATE], 0, 488},
	{&myhtml_tag_base_list[MyHTML_TAG_COLGROUP], 0, 489},
	{&myhtml_tag_base_list[MyHTML_TAG_ANNOTATION_XML], 0, 490},
	{&myhtml_tag_base_list[MyHTML_TAG_FEMORPHOLOGY], 0, 491},
	{&myhtml_tag_base_list[MyHTML_TAG_TR], 493, 492},
	{&myhtml_tag_base_list[MyHTML_TAG_BGSOUND], 0, 493},
	{&myhtml_tag_base_list[MyHTML_TAG_MACTION], 0, 494},
	{&myhtml_tag_base_list[MyHTML_TAG_OUTPUT], 0, 495},
	{&myhtml_tag_base_list[MyHTML_TAG_MPADDED], 0, 496},
	{&myhtml_tag_base_list[MyHTML_TAG_TITLE], 0, 497},
	{&myhtml_tag_base_list[MyHTML_TAG_MALIGNGROUP], 0, 498},
	{&myhtml_tag_base_list[MyHTML_TAG_CURSOR], 0, 499},
	{&myhtml_tag_base_list[MyHTML_TAG_STRONG], 501, 500},
	{&myhtml_tag_base_list[MyHTML_TAG_COLOR_PROFILE], 0, 501},
	{&myhtml_tag_base_list[MyHTML_TAG_MASK], 0, 502},
	{&myhtml_tag_base_list[MyHTML_TAG_MSUBSUP], 0, 503},
	{&myhtml_tag_base_list[MyHTML_TAG_MLABELEDTR], 0, 504},
	{&myhtml_tag_base_list[MyHTML_TAG_MENUITEM], 506, 505},
	{&myhtml_tag_base_list[MyHTML_TAG_MPHANTOM], 0, 506},
	{&myhtml_tag_base_list[MyHTML_TAG_KEYGEN], 0, 507},
	{&myhtml_tag_base_list[MyHTML_TAG_TD], 0, 508},
	{&myhtml_tag_base_list[MyHTML_TAG_TFOOT], 0, 509},
	{&myhtml_tag_base_list[MyHTML_TAG_MALIGNMARK], 0, 510},
	{&myhtml_tag_base_list[MyHTML_TAG_STRIKE], 512, 511},
	{&myhtml_tag_base_list[MyHTML_TAG_SOURCE], 0, 512},
	{&myhtml_tag_base_list[MyHTML_TAG_CODE], 0, 513},
	{&myhtml_tag_base_list[MyHTML_TAG_FEMERGE], 0, 514},
	{&myhtml_tag_base_list[MyHTML_TAG_STOP], 0, 515},
	{&myhtml_tag_base_list[MyHTML_TAG_FECOMPOSITE], 517, 516},
	{&myhtml_tag_base_list[MyHTML_TAG_FEMERGENODE], 0, 517},
	{&myhtml_tag_base_list[MyHTML_TAG_METADATA], 0, 518},
	{&myhtml_tag_base_list[MyHTML_TAG_CANVAS], 0, 519},
	{&myhtml_tag_base_list[MyHTML_TAG_FRAMESET], 521, 520},
	{&myhtml_tag_base_list[MyHTML_TAG_FEOFFSET], 0, 521},
	{&myhtml_tag_base_list[MyHTML_TAG_MFRAC], 0, 522},
	{&myhtml_tag_base_list[MyHTML_TAG_RB], 0, 523},
	{&myhtml_tag_base_list[MyHTML_TAG_MERROR], 0, 524},
	{&myhtml_tag_base_list[MyHTML_TAG_FILTER], 0, 525},
	{&myhtml_tag_base_list[MyHTML_TAG_MISSING_GLYPH], 0, 526},
	{&myhtml_tag_base_list[MyHTML_TAG_FONT_FACE_URI], 0, 527},
	{&myhtml_tag_base_list[MyHTML_TAG_MOVER], 0, 528},
	{&myhtml_tag_base_list[MyHTML_TAG_LABEL], 0, 529},
	{&myhtml_tag_base_list[MyHTML_TAG_TREF], 0, 530},
	{&myhtml_tag_base_list[MyHTML_TAG_HEAD], 0, 531},
	{&myhtml_tag_base_list[MyHTML_TAG__END_OF_FILE], 0, 532},
	{&myhtml_tag_base_list[MyHTML_TAG_FEDIFFUSELIGHTING], 0, 533},
	{&myhtml_tag_base_list[MyHTML_TAG_MSPACE], 535, 534},
	{&myhtml_tag_base_list[MyHTML_TAG_MSTYLE], 0, 535},
	{&myhtml_tag_base_list[MyHTML_TAG_HGROUP], 0, 536},
	{&myhtml_tag_base_list[MyHTML_TAG_OPTION], 0, 537},
	{&myhtml_tag_base_list[MyHTML_TAG_WBR], 0, 538},
	{&myhtml_tag_base_list[MyHTML_TAG_MROOT], 540, 539},
	{&myhtml_tag_base_list[MyHTML_TAG_MSQRT], 0, 540},

};


const myhtml_tag_context_t * myhtml_tag_static_search(const char* name, size_t length)
{
    size_t idx = ((myhtml_string_chars_lowercase_map[ (const unsigned char)name[0] ] *
                   myhtml_string_chars_lowercase_map[ (const unsigned char)name[(length - 1)] ] *
                   length)
                  % MyHTML_BASE_STATIC_SIZE) + 1;

    while (myhtml_tag_static_list_index[idx].ctx)
    {
        if(myhtml_tag_static_list_index[idx].ctx->name_length == length) {
            if(myhtml_strncasecmp(myhtml_tag_static_list_index[idx].ctx->name, name, length) == 0)
                return myhtml_tag_static_list_index[idx].ctx;

            if(myhtml_tag_static_list_index[idx].next)
                idx = myhtml_tag_static_list_index[idx].next;
            else
                return NULL;
        }
        else if(myhtml_tag_static_list_index[idx].ctx->name_length > length) {
            return NULL;
        }
        else {
            idx = myhtml_tag_static_list_index[idx].next;
        }
    }

    return NULL;
}

const myhtml_tag_context_t * myhtml_tag_static_get_by_id(size_t idx)
{
    return &myhtml_tag_base_list[idx];
}



