/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* integer.c
**
**/

#define BASE 10

#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "pfile.h"
#include "range.h"

static void *
String2Int (char *value, int *copy)
{
  char *scanto = NULL;

  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  if (!strcmp (value, "INDEF") || !strcmp (value, "INDEFI"))
    {
      *copy = INDEFI;
      return copy;
    }

  *copy = strtol (value, &scanto, BASE);

  if (scanto == NULL || (*scanto != '\0' && *scanto != '.'))
    {
      parerr = PARCANTCONVERT;
      return NULL;
    }

  return copy;
}


static void *
Real2Int (real * value, int *copy)
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  *copy = *value;
  return copy;
}


static void *
Bool2Int (bool * value, int *copy)
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  *copy = *value == 1;
  return copy;
}


static int
Comp (void *pvalue1, void *pvalue2, int type)
{
  int *value1 = (int *) pvalue1;
  int *value2 = (int *) pvalue2;

  if (*value1 == INDEFI || *value2 == INDEFI)
    return 1;

  switch (type)
    {
    case PRange_EQ:
      return *value1 == *value2;
    case PRange_NE:
      return *value1 != *value2;
    case PRange_GT:
      return *value1 > *value2;
    case PRange_GE:
      return *value1 >= *value2;
    case PRange_LT:
      return *value1 < *value2;
    case PRange_LE:
      return *value1 <= *value2;
    default:
      return 0;
    }
}

static Converter Converters[] = {
  {StringType, IntegerType, (ConverterType) String2Int},
  {RealType, IntegerType, (ConverterType) Real2Int},
  {BooleanType, IntegerType, (ConverterType) Bool2Int},
  {0, 0, 0}
};


vtype integerRec = {
  "i",
  Converters,

  VXSize,
  VXAcce,
  Comp
};
