package UAV::Pilot::Exception;
use v5.14;
use Moose;
use namespace::autoclean;

with 'Throwable';

has 'error' => (
    is  => 'rw',
    isa => 'Str',
);

sub to_string
{
    my ($self) = @_;
    return $self->error;
}

no Moose;
__PACKAGE__->meta->make_immutable;


package UAV::Pilot::NumberOutOfRangeException;
use v5.14;
use Moose;
use namespace::autoclean;
extends 'UAV::Pilot::Exception';

no Moose;
__PACKAGE__->meta->make_immutable;


package UAV::Pilot::IOException;
use v5.14;
use Moose;
use namespace::autoclean;
extends 'UAV::Pilot::Exception';

no Moose;
__PACKAGE__->meta->make_immutable;


package UAV::Pilot::FileNotFoundException;
use v5.14;
use Moose;
use namespace::autoclean;
extends 'UAV::Pilot::IOException';

has 'file' => (
    is  => 'ro',
    isa => 'Str',
);

no Moose;
__PACKAGE__->meta->make_immutable;


package UAV::Pilot::NavPacketException::BadHeader;
use v5.14;
use Moose;
use namespace::autoclean;
extends 'UAV::Pilot::Exception';

has 'got_header' => (
    is  => 'ro',
    isa => 'Int',
);

no Moose;
__PACKAGE__->meta->make_immutable;


package UAV::Pilot::VideoException;
use v5.14;
use Moose;
use namespace::autoclean;
extends 'UAV::Pilot::Exception';

no Moose;
__PACKAGE__->meta->make_immutable;


package UAV::Pilot::ArdupilotPacketException::BadHeader;
use v5.14;
use Moose;
use namespace::autoclean;
extends 'UAV::Pilot::Exception';

has 'got_header' => (
    is  => 'ro',
    isa => 'Int',
);

no Moose;
__PACKAGE__->meta->make_immutable;


package UAV::Pilot::ArdupilotPacketException::BadChecksum;
use v5.14;
use Moose;
use namespace::autoclean;
extends 'UAV::Pilot::Exception';

has 'got_checksum1' => (
    is  => 'ro',
    isa => 'Int',
);
has 'got_checksum2' => (
    is  => 'ro',
    isa => 'Int',
);
has 'expected_checksum1' => (
    is  => 'ro',
    isa => 'Int',
);
has 'expected_checksum2' => (
    is  => 'ro',
    isa => 'Int',
);

no Moose;
__PACKAGE__->meta->make_immutable;


1;
__END__


=head1 NAME

  UAV::Pilot::Exceptions

=head1 DESCRIPTION

Exceptions that could be thrown by C<UAV::Pilot> modules.  All inherit from 
C<UAV::Pilot::Exception>, which does the role C<Throwable>.

=head1 EXCEPTIONS

=head2 UAV::Pilot::NumberOutOfRangeException

=head2 UAV::Pilot::IOException

=head2 UAV::Pilot::NavPacketException::BadHeader

=head2 UAV::Pilot::VideoException

=head2 UAV::Pilot::ArdupilotPacketException::BadHeader

=head2 UAV::Pilot::ArdupilotPacketException::BadChecksum

=cut
