/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.ConcatenationIterator;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.FilteredIterator;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaCollectionValuedMap<K, V>
extends CollectionValuedMap<K, V> {
    private static final long serialVersionUID = 1L;
    private CollectionValuedMap<K, V> originalMap;
    private Map<K, Collection<V>> deltaMap;
    private static Object removedValue = new Object();

    @Override
    public Collection<V> get(Object key) {
        Collection<V> deltaResult = this.deltaMap.get(key);
        if (deltaResult == null) {
            return this.originalMap.get(key);
        }
        if (deltaResult == removedValue) {
            return this.cf.newEmptyCollection();
        }
        return deltaResult;
    }

    @Override
    public Collection<V> put(K key, Collection<V> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(K key, V value) {
        Collection<Object> deltaC = this.deltaMap.get(key);
        if (deltaC == null) {
            deltaC = this.cf.newCollection();
            Object originalC = this.originalMap.get(key);
            if (originalC != null) {
                deltaC.addAll((Collection<V>)originalC);
            }
            this.deltaMap.put(key, deltaC);
        }
        deltaC.add(value);
    }

    @Override
    public void addAll(Map<K, V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.add(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> remove(Object key) {
        Object result = this.get(key);
        this.deltaMap.put(ErasureUtils.uncheckedCast(key), ErasureUtils.uncheckedCast(removedValue));
        return result;
    }

    @Override
    public void removeMapping(K key, V value) {
        Object originalC;
        Collection<Object> deltaC = this.deltaMap.get(key);
        if (deltaC == null && (originalC = this.originalMap.get(key)) != null && originalC.contains(value)) {
            deltaC = this.cf.newCollection();
            deltaC.addAll((Collection<V>)originalC);
            this.deltaMap.put(key, deltaC);
        }
        if (deltaC != null) {
            deltaC.remove(value);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Collection<V> value = this.deltaMap.get(key);
        if (value == null) {
            return this.originalMap.containsKey(key);
        }
        return value != removedValue;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        for (K key : this.originalMap.keySet()) {
            this.deltaMap.put(key, ErasureUtils.uncheckedCast(removedValue));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public Collection<Collection<V>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return new AbstractSet<Map.Entry<K, Collection<V>>>(){

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                Filter filter1 = new Filter<Map.Entry<K, Collection<V>>>(){
                    private static final long serialVersionUID = -3257173354412718639L;

                    @Override
                    public boolean accept(Map.Entry<K, Collection<V>> e) {
                        Object key = e.getKey();
                        return !DeltaCollectionValuedMap.this.deltaMap.containsKey(key);
                    }
                };
                FilteredIterator iter1 = new FilteredIterator(DeltaCollectionValuedMap.this.originalMap.entrySet().iterator(), filter1);
                Filter filter2 = new Filter<Map.Entry<K, Collection<V>>>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public boolean accept(Map.Entry<K, Collection<V>> e) {
                        return e.getValue() != removedValue;
                    }
                };
                FilteredIterator iter2 = new FilteredIterator(DeltaCollectionValuedMap.this.deltaMap.entrySet().iterator(), filter2);
                return new ConcatenationIterator(iter1, iter2);
            }

            @Override
            public int size() {
                int size = 0;
                for (Map.Entry entry : this) {
                    ErasureUtils.noop(entry);
                    ++size;
                }
                return size;
            }
        };
    }

    public DeltaCollectionValuedMap(CollectionValuedMap<K, V> originalMap) {
        this.originalMap = originalMap;
        this.cf = originalMap.cf;
        this.mf = originalMap.mf;
        this.deltaMap = this.mf.newMap();
    }
}

