package Business::EDI::CodeList::SettlementMeansCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {4471;}
my $usage       = 'B';

# 4471  Settlement means code                                   [B]
# Desc: Code specifying the means of settlement.
# Repr: an..3

my %code_hash = (
'1' => [ 'Bill back',
    'Refers to a charge or allowance for the buyer and the buyer will bill back the seller.' ],
'2' => [ 'Off invoice',
    'The allowance or charge is being deducted from the invoice.' ],
'3' => [ 'Vendor check to customer',
    'An allowance will be given to a customer from the supplier in the form of a check.' ],
'4' => [ 'Credit customer account',
    'An allowance will be processed for the customer by giving a credit to their account.' ],
'5' => [ 'Charge to be paid by vendor',
    'A charge whose payment will be made by the vendor.' ],
'6' => [ 'Charge to be paid by customer',
    'A charge whose payment will be made by the customer.' ],
'7' => [ 'Optional',
    'The settlement of charges is not obligatory.' ],
'8' => [ 'Off gross quantity invoiced',
    'Allowance as relates to the gross quantity invoiced.' ],
'9' => [ 'Electric cost recovery factor',
    'An allowance as it relates to the electric cost recovery factor.' ],
'10' => [ 'Gas cost recovery factor',
    'An allowance as it relates to the gas cost recovery factor.' ],
'11' => [ 'Prior credit balance',
    'A settlement was made using a previous credit balance.' ],
'12' => [ 'Non-dutiable',
    'Reference to an allowance or charge as being free for Customs duty computation purposes.' ],
'13' => [ 'All charges borne by payee',
    'All charges are to be borne by the funds receiver.' ],
'14' => [ 'Each pay own cost',
    'Each party are to be responsible for its own charges.' ],
'15' => [ 'All charges borne by payer',
    'All charges are to be borne by the funds sender.' ],
'16' => [ 'All bank charges to be borne by applicant',
    'All bank charges associated with a documentary credit are to be borne by the applicant.' ],
'17' => [ 'All bank charges except confirmation commission to be borne',
    'by applicant All bank charges associated with a documentary credit except confirmation commission are to borne by the applicant.' ],
'18' => [ 'All bank charges to be borne by beneficiary',
    'All bank charges associated with a documentary credit are to be borne by the beneficiary.' ],
'19' => [ 'Total payment borne by project',
    'The total payment is borne by the project.' ],
'20' => [ 'Amendment charges to be borne by applicant',
    'Documentary credit amendment charges are to be borne by the applicant.' ],
'21' => [ 'Amendment charges to be borne by beneficiary',
    'Documentary credit amendment charges are to be borne by the beneficiary.' ],
'22' => [ 'Discount charges to be borne by applicant',
    'Documentary credit discount charges are to be borne by the applicant.' ],
'23' => [ 'Discount charges to be borne by beneficiary',
    'Documentary credit discount charges are to be borne by the beneficiary.' ],
'24' => [ 'All bank charges other than those of the issuing bank to be',
    'borne by beneficiary All bank charges associated with a documentary credit other than those of the issuing bank are to be borne by the beneficiary.' ],
'25' => [ 'Amendment charges other than those of the issuing bank to',
    'be borne by beneficiary All charges associated with the amendment other than those of the issuing bank are to be borne by the beneficiary.' ],
'26' => [ 'All charges to be paid by the principal of the collection',
    'All charges are to be paid by the principal of the collection.' ],
'27' => [ 'All charges to be paid by the drawee of the collection',
    'All charges are to be paid by the drawee of the collection.' ],
'28' => [ 'All charges to be borne by the drawee except those levied',
    'by the remitting bank, to be paid by principal All charges are to be borne by the drawee except those levied by the remitting bank, which are to be paid by the principal.' ],
'29' => [ 'All bank charges are to be paid by the principal of the',
    'documentary credit collection All bank charges are to be paid by the principal of the documentary credit collection.' ],
'30' => [ 'All bank charges to be borne by receiving bank',
    'All bank charges are to be borne by the receiving bank.' ],
'31' => [ 'All bank charges to be borne by sending bank',
    'All bank charges are to be borne by the sending bank.' ],
'32' => [ 'Charges levied by a third bank',
    'Charges levied by a third bank.' ],
'33' => [ 'Information charges levied by a third bank',
    'Charges levied by a third bank for providing information.' ],
'34' => [ 'Total payment borne by patient',
    'The total payment is borne by the patient.' ],
'35' => [ 'Part payment borne by patient',
    'The part payment is borne by the patient.' ],
'36' => [ 'No charge to patient',
    'No charges to be paid by the patient.' ],
'37' => [ 'Divided according to national health service rules',
    'Charge is divided between parties according to national health service rules.' ],
'38' => [ 'Item accruals',
    'Expenses related to an item for which invoices have not been received yet at the end of the current acounting period.' ],
'39' => [ 'Vendor accruals',
    'Expenses related to a vendor for which invoices have not been received yet at the end of the current accounting period.' ],
'ZZZ' => [ 'Mutually defined',
    'A code reserved for special trading partner requirements when pre-defined codes do not exist.' ],
);
sub get_codes { return \%code_hash; }

1;
