
use Test;
use strict;
no warnings;
use Math::Business::CCI;

my $cci = Math::Business::CCI->new(20);

# {{{ my @google_finance_data = qw(
my @google_finance_data = qw(
19-Sep-13,17.00,17.24,16.86,17.10,9290333
18-Sep-13,17.08,17.22,16.90,17.15,6845516
17-Sep-13,17.32,17.38,17.14,17.16,4227711
16-Sep-13,17.18,17.37,17.06,17.25,6026913
13-Sep-13,16.99,17.03,16.84,16.97,3520638
12-Sep-13,17.14,17.18,16.73,16.90,3760639
11-Sep-13,17.22,17.37,17.07,17.18,4624293
10-Sep-13,17.34,17.41,16.89,17.15,6716973
9-Sep-13,17.06,17.14,16.93,17.04,3346653
6-Sep-13,17.31,17.31,16.77,16.97,6169368
5-Sep-13,17.02,17.30,17.00,17.17,4691148
4-Sep-13,17.02,17.14,16.86,17.10,5578933
3-Sep-13,16.81,17.24,16.80,16.98,9502587
30-Aug-13,16.76,16.77,16.24,16.32,4946228
29-Aug-13,16.36,16.96,16.36,16.75,6665702
28-Aug-13,16.22,16.53,16.19,16.39,5259692
27-Aug-13,16.44,16.46,16.02,16.20,8277700
26-Aug-13,16.70,16.72,16.55,16.56,3903053
23-Aug-13,16.86,16.89,16.60,16.72,5439717
22-Aug-13,16.66,16.94,16.64,16.80,2861830
21-Aug-13,16.68,16.75,16.39,16.58,5419455
20-Aug-13,16.75,16.97,16.58,16.75,5633783
19-Aug-13,17.24,17.30,16.78,16.79,5566045
16-Aug-13,17.23,17.42,17.17,17.30,6657169
15-Aug-13,17.33,17.39,17.09,17.23,6821357
14-Aug-13,17.38,17.51,17.31,17.44,8631440
13-Aug-13,17.28,17.53,17.16,17.46,8433343
12-Aug-13,17.21,17.30,17.04,17.18,5229328
9-Aug-13,17.43,17.45,17.14,17.23,5896331
8-Aug-13,17.50,17.67,17.27,17.50,6119573
7-Aug-13,17.48,17.63,17.37,17.51,4032456
6-Aug-13,17.64,17.80,17.17,17.45,11238461
5-Aug-13,17.83,17.93,17.60,17.73,6764140
2-Aug-13,17.94,18.19,17.40,18.08,11018778
1-Aug-13,17.99,18.33,17.62,18.20,7741593
31-Jul-13,18.19,18.28,17.94,17.98,8698481
30-Jul-13,18.25,18.44,17.92,18.18,9736371
29-Jul-13,17.43,18.39,17.38,18.27,20718911
26-Jul-13,17.16,17.76,16.86,17.46,41849789
25-Jul-13,15.38,15.42,15.09,15.18,4552264
24-Jul-13,15.33,15.43,15.13,15.39,5253197
23-Jul-13,15.15,15.52,15.15,15.22,4642680
22-Jul-13,15.38,15.66,14.89,15.15,8197087
);

# }}}

my @cci;


for my $line (reverse @google_finance_data) {
    my ($date, $open, $high, $low, $close, $volume) = split m/,/, $line;

    $cci->insert( [$high, $low, $close] );
    push @cci, 0+$cci->query;
}

my @manually_fetched_from_google = qw(46.32 56.46 97.9 106.59 27.61 19.39 77.46);

plan tests => 0+@manually_fetched_from_google;

while( my $mf = shift @manually_fetched_from_google ) {
    my $cci = pop @cci;

    if( abs($cci - $mf) < 2 ) {
        $cci = $mf;  # now this is some good science
    }

    ok( $cci, $mf );
}
