#! /usr/bin/env false

use v6.d;

use App::GTD;

unit module App::GTD::Bin::Trash;

#| Remove an item completely. This will reorder IDs!
multi sub MAIN (
	'trash',

	#| The ID of the item to operate on.
	Int:D $id!,
) is export {
	gtd-config-load;

	my @records = gtd-records-read;

	@records[$id - 1] = Str;

	gtd-records-write(@records);
}

=begin pod

=NAME    App::GTD::Bin::Trash
=AUTHOR  Patrick Spek <p.spek@tyil.work>
=VERSION 0.1.0

=head1 Synopsis

=head1 Description

=head1 Examples

=head1 See also

=end pod

# vim: ft=perl6 noet
