#!/usr/bin/perl

use strict;
use warnings;
#use utf8;
use lib 't/lib';

use Encode;
use English qw(-no_match_vars);
use Test::Deep;
use Test::Exception;
use Test::MockModule;
use Test::More;
use UNIVERSAL::require;

use FusionInventory::Agent::Inventory;
use FusionInventory::Test::Utils;
use FusionInventory::Agent::Tools::Win32::Constants;

BEGIN {
    # use mock modules for non-available ones
    push @INC, 't/lib/fake/windows' if $OSNAME ne 'MSWin32';
}

use Config;
# check thread support availability
if (!$Config{usethreads} || $Config{usethreads} ne 'define') {
    plan skip_all => 'thread support required';
}

Test::NoWarnings->use();

FusionInventory::Agent::Task::Inventory::Win32::Softwares->require();

my %softwares_tests = (
    'mssql' => [
        {
            'ARCH' => 'i586',
            'COMMENTS' => 'Mozilla Firefox 57.0.2 (fr)',
            'FROM' => 'registry',
            'GUID' => 'Mozilla Firefox 57.0.2 (fr)',
            'HELPLINK' => 'https://support.mozilla.org',
            'INSTALLDATE' => undef,
            'NAME' => 'Mozilla Firefox 57.0.2 (fr)',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Mozilla',
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => '\\',
            'URL_INFO_ABOUT' => 'https://www.mozilla.org',
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => '57.0.2',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => 'Microsoft SQL Server 2008',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => 'Microsoft SQL Server 2008',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft',
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => '14.72.6100.34',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => 'Microsoft SQL Server 2017',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => 'Microsoft SQL Server 2017',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft',
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => '17.77.6700.34',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => 'FusionInventory-Agent',
            'HELPLINK' => 'https://github.com/fusioninventory/fusioninventory-agent',
            'INSTALLDATE' => undef,
            'NAME' => 'FusionInventory Agent 2.4.x-build-26 (x64 edition)',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'FusionInventory Team',
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => 'C:\\Program Files\\FusionInventory-Agent\\Uninstall.exe',
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => '2.4.x-build-26',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => 'Microsoft SQL Server 2005',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => 'Microsoft SQL Server 2005 Standard Edition',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft',
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => '10.53.6000.34',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => 'Git_is1',
            'HELPLINK' => 'https://github.com/git-for-windows/git/wiki/Contact',
            'INSTALLDATE' => '02/05/2017',
            'NAME' => 'Git version 2.12.2.2',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'The Git Development Community',
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => '\\',
            'URL_INFO_ABOUT' => 'https://git-for-windows.github.io/',
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => '2.12.2.2',
            'VERSION_MAJOR' => 2,
            'VERSION_MINOR' => 0
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => 'Strawberry Perl (64-bit) version 5.24.0.1',
            'FROM' => 'registry',
            'GUID' => '{532C05E1-7376-1014-987E-E28031843670}',
            'HELPLINK' => undef,
            'INSTALLDATE' => '22/06/2017',
            'NAME' => 'Strawberry Perl (64-bit)',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'strawberryperl.com project',
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => 'http://strawberryperl.com/',
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => '5.24.1',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        }
    ],
    'mssql_engine' => [
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => 'SQL Server 2011 Database Engine Services',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => 'SQL Server 2011 Express Edition Database Engine Services',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft',
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => '11.0.2100.60',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => 'SQL Server 2017 Database Engine Services',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => 'SQL Server Database Engine Services',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft',
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => '17.77.6700.34',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        }
    ],
    'xp' => [
        {
            'INSTALLDATE' => '09/07/2008',
            'RELEASE_TYPE' => 'Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com?kbid=951978',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB951978)',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB951978'
        },
        {
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'PUBLISHER' => 'LogMeIn Inc.',
            'NO_REMOVE' => 1,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '15/10/2010',
            'UNINSTALL_STRING' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => '{5B21BB9A-E23E-472b-AD2A-FB9B06A4727C}',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Network Console',
            'URL_INFO_ABOUT' => 'http://www.logmein.com',
            'VERSION' => '9.00.175'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=958644',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '31/10/2008',
            'COMMENTS' => undef,
            'GUID' => 'KB958644',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Windows XP (KB958644)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '10/04/2008',
            'UNINSTALL_STRING' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => '{0A869A65-8C94-4F7C-A5C7-972D3C8CED9E}',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'MSXML 6.0 Parser (KB933579)',
            'VERSION' => '6.10.1200.0'
        },
        {
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB971657)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB971657',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=971657'
        },
        {
            'COMMENTS' => undef,
            'GUID' => '{90140000-0018-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB2646524',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2646524)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2646524',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '17/01/2012',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'GUID' => 'KB2641690',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB2641690)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2641690',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '15/11/2011'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB952954',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB952954)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=952954',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008'
        },
        {
            'GUID' => 'KB951072-v2',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '2',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB951072-v2)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=951072',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '09/07/2008',
            'RELEASE_TYPE' => 'Update'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2506223',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/04/2011',
            'GUID' => 'KB2506223',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Windows XP (KB2506223)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2503658',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/04/2011',
            'COMMENTS' => undef,
            'GUID' => 'KB2503658',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2503658)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'INSTALLDATE' => '15/02/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=978251',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB978251)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB978251',
            'COMMENTS' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2647516',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '21/02/2012',
            'RELEASE_TYPE' => 'Security Update',
            'COMMENTS' => undef,
            'GUID' => 'KB2647516-IE8',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2647516)',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'VERSION' => '3.0.6920.0',
            'USERNAME' => undef,
            'NAME' => 'Windows Presentation Foundation',
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => '{BAF78226-3200-4DB4-BE33-4D922A799840}',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '10/04/2008',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=974455',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '09/11/2009',
            'RELEASE_TYPE' => 'Security Update',
            'GUID' => 'KB974455-IE8',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB974455)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB974571)',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB974571',
            'INSTALLDATE' => '09/11/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=974571',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '05/04/2006',
            'UNINSTALL_STRING' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => '{350C97B0-3D7C-4EE8-BAA9-00BCB3D54227}',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'WebFldrs XP',
            'URL_INFO_ABOUT' => undef,
            'VERSION' => '9.50.7523'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2360937',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '18/10/2010',
            'RELEASE_TYPE' => 'Security Update',
            'GUID' => 'KB2360937',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2360937)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'INSTALLDATE' => '17/01/2012',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2584146',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2584146)',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2584146'
        },
        {
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Oracle',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '20/02/2012',
            'UNINSTALL_STRING' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => '{26A24AE4-039D-4CA4-87B4-2F83216031FF}',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Java(TM) 6 Update 31',
            'URL_INFO_ABOUT' => 'http://java.com',
            'VERSION' => '6.0.310'
        },
        {
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office Groove MUI (English) 2010',
            'VERSION' => '14.0.6029.1000',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => '{90140000-00BA-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '04/10/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://www.ossec.net/main/support/',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'COMMENTS' => undef,
            'GUID' => 'OSSEC',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '2.5.1',
            'URL_INFO_ABOUT' => 'http://www.ossec.net',
            'NAME' => 'OSSEC HIDS 2.5.1',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'NAME' => 'Update for Microsoft Office 2010 (KB2553270) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553270',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => '{90140000-001F-0C0A-0000-0000000FF1CE}_Office14.PROPLUS_{995A7832-B512-46D5-87C9-2D71FB541435}',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'HELPLINK' => 'http://support.microsoft.com/kb/2553270',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'HELPLINK' => 'http://support.microsoft.com/kb/2553310',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2553310) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553310',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => '{90140000-006E-0409-0000-0000000FF1CE}_Office14.PROPLUS_{73E67A3A-8D61-44EF-90C2-1697C3DBE668}',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/05/2009',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=923561',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB923561)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB923561'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=950762',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008',
            'COMMENTS' => undef,
            'GUID' => 'KB950762',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB950762)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'GUID' => 'Revo Uninstaller',
            'COMMENTS' => 'Thank you for choosing Revo Uninstaller!',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1.93',
            'URL_INFO_ABOUT' => 'http://www.revouninstaller.com',
            'NAME' => 'Revo Uninstaller 1.93',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'VS Revo Group',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://www.revouninstaller.com',
            'UNINSTALL_STRING' => 'C:\\Program Files\\VS Revo Group\\Revo Uninstaller\\uninst.exe',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB978706)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB978706',
            'INSTALLDATE' => '15/02/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=978706',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=970430',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/12/2009',
            'GUID' => 'KB970430',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB970430)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'VERSION' => '1.6.30',
            'URL_INFO_ABOUT' => 'http://www.microsoft.com',
            'NAME' => 'User Profile Hive Cleanup Service',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => 'Installer for User Profile Hive Cleanup Service',
            'GUID' => '{FF77941A-2BFA-4A18-BE2E-69B9498E4D55}',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '23/08/2007',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef
        },
        {
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Media Player (KB973540)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB973540_WM9',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com/?kbid=973540',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Hotfix for Windows XP (KB952287)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB952287',
            'INSTALLDATE' => '09/07/2008',
            'RELEASE_TYPE' => 'Hotfix',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=952287',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Update for Windows XP (KB955839)',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB955839',
            'COMMENTS' => undef,
            'INSTALLDATE' => '15/01/2009',
            'RELEASE_TYPE' => 'Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=955839',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=961501',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2009',
            'COMMENTS' => undef,
            'GUID' => 'KB961501',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB961501)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=956844',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '09/11/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB956844',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB956844)',
            'USERNAME' => undef
        },
        {
            'NAME' => 'Security Update for Windows XP (KB978542)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB978542',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '17/05/2010',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=978542',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2597091) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2597091',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{4D98EEEA-A31B-42FA-991A-F989594F4DA5}',
            'COMMENTS' => undef,
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2597091',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft'
        },
        {
            'GUID' => 'KB931906',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for CAPICOM (KB931906)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION' => '2.1.0.2',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=931906',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => 'MsiExec.exe /X{0EFDF2F9-836D-4EB7-A32D-038BD3F1FB2A}',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '17/01/2012',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2603381',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2603381)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB2603381',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => 'rundll32.exe setupapi.dll,InstallHinfSection DefaultUninstall 132 C:\\WINDOWS\\INF\\PCHealth.inf',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'PCHealth',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'PCHealth',
            'COMMENTS' => undef
        },
        {
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2510531)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB2510531-IE8',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '18/04/2011',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2510531'
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2675157-IE8',
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2675157)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2675157',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '17/04/2012',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '15/02/2010',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=978037',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB978037)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB978037'
        },
        {
            'GUID' => 'KB2378111_WM9',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Media Player (KB2378111)',
            'USERNAME' => undef,
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/?kbid=2378111',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '18/10/2010'
        },
        {
            'UNINSTALL_STRING' => 'C:\\WINDOWS\\system32\\MacroMed\\Flash\\genuinst.exe C:\\WINDOWS\\system32\\MacroMed\\Flash\\KB923789.inf',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=923789',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB923789)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB923789',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\Setup.exe /repair /x86 /parameterfolder Extended',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'Microsoft .NET Framework 4 Extended',
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft .NET Framework 4 Extended',
            'URL_INFO_ABOUT' => 'http://go.microsoft.com/fwlink/?LinkId=164164',
            'VERSION' => '4.0.30319'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com/?kbid=917734',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '16/06/2006',
            'RELEASE_TYPE' => undef,
            'GUID' => 'KB917734_WMP10',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Media Player 10 (KB917734)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '28/03/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=971029',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB971029)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB971029',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{DC6A88F2-14D6-468F-9E68-CBF7779FEE00}',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{DC6A88F2-14D6-468F-9E68-CBF7779FEE00}',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 1,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-001F-0C0A-0000-0000000FF1CE}_Office14.PROPLUS_{DEA87BE2-FFCC-4F33-9946-FCBE55A1E998}',
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION' => undef,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2362765',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '22/11/2010',
            'GUID' => 'KB2362765-IE8',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Update for Windows Internet Explorer 8 (KB2362765)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Identity Finder',
            'USERNAME' => undef,
            'VERSION' => '4.6.1.0',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{19DD1E9D-51E7-4A63-83F0-BAB7D6FBFC55}',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '11/11/2010',
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => 'Identity Finder, LLC',
            'NO_REMOVE' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => 'C:\\Program Files\\Ghostgum\\gsview\\uninstgs.exe \\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'COMMENTS' => undef,
            'GUID' => 'GSview 4.8',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'GSview 4.8',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '20080414.031525',
            'NAME' => 'Windows XP Service Pack 3',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'Windows XP Service Pack',
            'INSTALLDATE' => '09/07/2008',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=936929',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2447568',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '28/03/2011',
            'GUID' => 'KB2447568-IE8',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Update for Windows Internet Explorer 8 (KB2447568)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'HELPLINK' => 'http://support.microsoft.com/kb/2553091',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{07CA44F3-F5B3-4D12-8C91-EDC5FE91D45C}',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'NAME' => 'Security Update for Microsoft Office 2010 (KB2553091)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553091'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2596964',
            'NAME' => 'Update for Microsoft Office 2010 (KB2596964) 32-Bit Edition',
            'USERNAME' => undef,
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{ED31DE9A-3E13-4E2C-9106-E0D8AFFB9FA6}',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2596964',
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '15/02/2010',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=978262',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB978262)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB978262',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'COMMENTS' => undef,
            'GUID' => '{90140000-001A-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef
        },
        {
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '03/01/2012',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Microsoft .NET Framework 3.5 SP1',
            'USERNAME' => undef,
            'VERSION' => '3.5.30729',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB980218',
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB980218)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'HELPLINK' => 'http://support.microsoft.com?kbid=980218',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/06/2010',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Proxy Networks, Inc.',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '09/07/2009',
            'RELEASE_TYPE' => undef,
            'COMMENTS' => undef,
            'GUID' => '{A17F60BF-18E7-49ED-8AA2-8AC82B7F3993}',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '6.10.1374',
            'NAME' => 'PROXY Pro Host',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://www.proxynetworks.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'GUID' => 'PDFTK Builder_is1',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'PDFTK Builder 2.3',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'INSTALLDATE' => '15/01/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com?kbid=960714',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB960714)',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB960714',
            'COMMENTS' => undef
        },
        {
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0115-0409-0000-0000000FF1CE}_Office14.PROPLUS_{4560037C-E356-444A-A015-D21F487D809E}',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2393802',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2393802)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2393802',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '14/02/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2478960)',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2478960',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/02/2011',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2478960',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=941569',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '01/01/2008',
            'RELEASE_TYPE' => 'Security Update',
            'GUID' => 'KB941569',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB941569)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '2',
            'USERNAME' => undef,
            'NAME' => 'Hotfix for Windows XP (KB976098-v2)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB976098-v2',
            'INSTALLDATE' => '01/02/2010',
            'RELEASE_TYPE' => 'Hotfix',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=976098',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB958687)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB958687',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '15/01/2009',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=958687'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=951066',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB951066)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB951066',
            'COMMENTS' => undef
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://ocsinventory.sourceforge.net',
            'NAME' => 'OCS Inventory Agent 4.0.4.8',
            'USERNAME' => undef,
            'VERSION' => '4.0.4.8',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'OCS Inventory Agent',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => 'C:\\Program Files\\OCS Inventory Agent\\uninst.exe',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => 'OCS Inventory NG Team',
            'NO_REMOVE' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/02/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2483185',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2483185)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB2483185',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/04/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2485663',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2485663)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB2485663',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2657424',
            'UNINSTALL_STRING' => 'C:\\windows\\system32\\msiexec.exe /package {CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9} /uninstall {F6F5AC31-9833-3E77-AC8E-8E910CAB39AE} /qb+ REBOOTPROMPT=\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'COMMENTS' => undef,
            'GUID' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB2657424',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Microsoft .NET Framework 3.5 SP1 (KB2657424)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'INSTALLDATE' => '20/12/2011',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '14.0.6029.1000',
            'NAME' => 'Microsoft Office Proof (Spanish) 2010',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-001F-0C0A-0000-0000000FF1CE}',
            'COMMENTS' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=956744',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB956744)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB956744',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2633870',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2633870)',
            'VERSION' => '1',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2633870',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {8DDEFC7E-0C61-3D11-AFC6-5414F2DAFD01} /parameterfolder Client'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2598479',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '17/01/2012',
            'RELEASE_TYPE' => 'Security Update',
            'COMMENTS' => undef,
            'GUID' => 'KB2598479',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2598479)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Kay Bruns',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => 'C:\\WINDOWS\\SuRun.exe /UNINSTALL',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'SuRun',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1.2.0.8',
            'URL_INFO_ABOUT' => 'http://kay-bruns.de/surun',
            'NAME' => 'Super User Run (SuRun)',
            'USERNAME' => undef
        },
        {
            'URL_INFO_ABOUT' => 'http://www.adobe.com',
            'USERNAME' => undef,
            'NAME' => 'Adobe Shockwave Player 11',
            'VERSION' => '11',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'Adobe Shockwave Player',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => 'C:\\WINDOWS\\system32\\adobe\\SHOCKW~1\\UNWISE.EXE C:\\WINDOWS\\system32\\Adobe\\SHOCKW~1\\Install.log',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => 'Adobe Systems, Inc.',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://www.adobe.com/support/shockwave'
        },
        {
            'NAME' => 'GPL Ghostscript 8.54',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'GPL Ghostscript 8.54',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => 'C:\\gs\\uninstgs.exe \\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Update for Microsoft .NET Framework 4 Client Profile (KB2473228)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2473228',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Update',
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {FD988F49-E1C8-3C84-9683-0448B6BB8E20} /parameterfolder Client',
            'HELPLINK' => 'http://support.microsoft.com/kb/2473228',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '20/12/2010',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2443105',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2443105)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB2443105',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/11/2009',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com?kbid=971961',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB971961)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB971961',
            'COMMENTS' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB968389',
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Update for Windows XP (KB968389)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'HELPLINK' => 'http://support.microsoft.com?kbid=968389',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '03/09/2009',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'COMMENTS' => undef,
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2539636',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2539636)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2539636',
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {7E97AB83-C1FE-38DE-B848-877E0A4BD81E} /parameterfolder Client',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => undef
        },
        {
            'GUID' => 'KB923689',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB923689)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=923689',
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '13/12/2006',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'O&O Software GmbH',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '23/02/2011',
            'RELEASE_TYPE' => undef,
            'COMMENTS' => undef,
            'GUID' => '{754F24D0-D2FF-4801-B7ED-588D4E88415B}',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '2.0.386',
            'USERNAME' => undef,
            'NAME' => 'O&O DiskStat Workstation',
            'URL_INFO_ABOUT' => 'http://www.oo-software.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '16/08/2010',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=981852',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB981852)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB981852',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'GUID' => 'Microsoft .NET Framework 3.5 SP1',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Microsoft .NET Framework 3.5 SP1',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://go.microsoft.com/fwlink/?LinkId=120337',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => 'C:\\WINDOWS\\Microsoft.NET\\Framework\\v3.5\\Microsoft .NET Framework 3.5 SP1\\setup.exe',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2553248',
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553248',
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft Outlook 2010 (KB2553248) 32-Bit Edition',
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-001A-0409-0000-0000000FF1CE}_Office14.PROPLUS_{5EBDE1DE-3B28-4134-AB00-85CFF2B4F94D}'
        },
        {
            'VERSION' => undef,
            'NAME' => 'Update for Microsoft Outlook Social Connector 2010 (KB2553406) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553406',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{BC6DFBFD-16DD-47E1-A7EF-2C062930FA4F}',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'HELPLINK' => 'http://support.microsoft.com/kb/2553406',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'INSTALLDATE' => '01/11/2008',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=950582',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB950582)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB950582',
            'COMMENTS' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2009',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=969898',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB969898)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB969898',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2476490)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2476490',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '21/06/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2476490'
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2497640)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB2497640-IE8',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/04/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2497640'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2478971',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '14/02/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2478971',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2478971)',
            'USERNAME' => undef
        },
        {
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{EFB525A0-E1C0-4E32-9968-FE401BC87363}',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2566458',
            'NAME' => 'Update for Microsoft Office 2010 (KB2566458)',
            'USERNAME' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2566458',
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\'
        },
        {
            'GUID' => 'KB2586448-IE8',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2586448)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2586448',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '18/10/2011',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'K-Lite Codec Pack 7.1.0 (Standard)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION' => '7.1.0',
            'FROM' => 'registry',
            'VERSION_MINOR' => 1,
            'VERSION_MAJOR' => 7,
            'GUID' => 'KLiteCodecPack_is1',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '23/11/2011',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB975560)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB975560',
            'INSTALLDATE' => '15/02/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=975560',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB975364-IE8',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Update for Windows Internet Explorer 8 (KB975364)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'HELPLINK' => 'http://support.microsoft.com?kbid=975364',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '10/11/2009',
            'RELEASE_TYPE' => 'Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Piriform',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'CCleaner (remove only)',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'CCleaner'
        },
        {
            'GUID' => '{90140000-0044-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Microsoft Office InfoPath MUI (English) 2010',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION' => '14.0.6029.1000',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '04/10/2011'
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0044-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'HELPLINK' => 'http://support.microsoft.com/kb/2553248',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft Outlook 2010 (KB2553248) 32-Bit Edition',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553248',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{38990592-F6A1-4A26-96C7-0600E36AE794}',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '15/11/2011',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2544893',
            'VERSION' => '2',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2544893-v2)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB2544893-v2',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2624667',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '20/12/2011',
            'RELEASE_TYPE' => 'Security Update',
            'GUID' => 'KB2624667',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2624667)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=973904',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '14/12/2009',
            'RELEASE_TYPE' => 'Security Update',
            'COMMENTS' => undef,
            'GUID' => 'KB973904',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB973904)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/?kbid=911565',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '05/04/2006',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB911565',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Media Player 10 (KB911565)',
            'USERNAME' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '09/11/2009',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://www.microsoft.com/ie',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'USERNAME' => undef,
            'NAME' => 'Windows Internet Explorer 8',
            'URL_INFO_ABOUT' => 'http://www.microsoft.com/ie',
            'VERSION' => '20090308.140743',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'ie8',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'HELPLINK' => 'http://support.microsoft.com/kb/982726',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{28857979-5507-4C10-A922-FF709A19D38C}',
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Definition update for Microsoft Office 2010 (KB982726) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/982726',
            'VERSION' => undef
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '05/04/2006',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=888656',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Windows Media Player 10 Hotfix - KB888656',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB888656',
            'COMMENTS' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '05/07/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2541763',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB2541763)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB2541763',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'GUID' => '{F72C6003-60EF-448D-AC89-0B69C97678DC}',
            'COMMENTS' => 'Symantec Backup Exec Remote Agent for Windows Systems 32-bit',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Symantec Backup Exec Remote Agent for Windows Systems',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://www.symantec.com',
            'VERSION' => '11.0.6235',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Symantec Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '10/12/2009'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=968537',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '09/07/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB968537',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB968537)'
        },
        {
            'VERSION_MINOR' => 1,
            'VERSION_MAJOR' => 4,
            'FROM' => 'registry',
            'GUID' => 'quicktime_lite_is1',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '4.1.0',
            'USERNAME' => undef,
            'NAME' => 'QT Lite 4.1.0',
            'URL_INFO_ABOUT' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef,
            'INSTALLDATE' => '23/11/2011',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB982381)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB982381-IE8',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/06/2010',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=982381',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2553310) 32-Bit Edition',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553310',
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{C8694FF0-8203-483B-A07A-2BC40433167D}',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2553310',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=953839',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB953839',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB953839)',
            'VERSION' => '1'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=960803',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/05/2009',
            'GUID' => 'KB960803',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB960803)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'INSTALLDATE' => '16/08/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2567680',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2567680)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2567680'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB977816',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Windows XP (KB977816)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=977816',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '19/04/2010'
        },
        {
            'URL_INFO_ABOUT' => 'http://www.microsoft.com/genuine',
            'USERNAME' => undef,
            'NAME' => 'Windows Genuine Advantage Validation Tool (KB892130)',
            'VERSION' => '1.7.0069.2',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'WGA',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '12/04/2006',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=892130'
        },
        {
            'HELPLINK' => 'http://support.microsoft.com?kbid=2570947',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '20/09/2011',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB2570947',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB2570947)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB979309)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB979309',
            'INSTALLDATE' => '19/04/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=979309',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '17/01/2012',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'O&O Software GmbH',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'VERSION' => '6.0.440',
            'URL_INFO_ABOUT' => 'http://www.oo-software.com',
            'NAME' => 'O&O DiskImage Workstation',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => '{8B2E50B7-E372-4045-A5FC-3E6A30A6C871}',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'GUID' => 'KB974318',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Windows XP (KB974318)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=974318',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/12/2009'
        },
        {
            'GUID' => 'KB2555917',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2555917)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2555917',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '19/07/2011'
        },
        {
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB975467)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB975467',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/11/2009',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=975467',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2507618',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '18/04/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2507618',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2507618)'
        },
        {
            'GUID' => 'KB963027',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB963027)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com?kbid=963027',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '18/05/2009',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB981957)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB981957',
            'INSTALLDATE' => '18/10/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=981957',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => 'C:\\Program Files\\ICEOWS\\Setup.exe /uninstall',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'ICEOWS',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Iceows V4.20a',
            'USERNAME' => undef,
            'VERSION' => undef
        },
        {
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB960859)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB960859',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=960859'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=973687',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '14/12/2009',
            'COMMENTS' => undef,
            'GUID' => 'KB973687',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB973687)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=952004',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/05/2009',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB952004',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB952004)',
            'USERNAME' => undef,
            'VERSION' => '1'
        },
        {
            'RELEASE_TYPE' => 'Hotfix',
            'INSTALLDATE' => '05/04/2010',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=979306',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Hotfix for Windows XP (KB979306)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB979306'
        },
        {
            'HELPLINK' => 'http://support.microsoft.com?kbid=956802',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '15/01/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB956802',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB956802)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2553385',
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{28FAC187-7C0E-413A-B90A-76F19D0FBF30}',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553385',
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2553385) 32-Bit Edition',
            'VERSION' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '4.0.30319',
            'URL_INFO_ABOUT' => 'http://go.microsoft.com/fwlink/?LinkId=164164',
            'USERNAME' => undef,
            'NAME' => 'Microsoft .NET Framework 4 Client Profile',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'Microsoft .NET Framework 4 Client Profile',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\Setup.exe /repair /x86 /parameterfolder Client',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'VERSION' => undef,
            'NAME' => 'Security Update for Microsoft SharePoint Workspace 2010 (KB2566445)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2566445',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{337A3FB9-281D-4EC8-9CC1-7F6DDAC2359F}',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'HELPLINK' => 'http://support.microsoft.com/kb/2566445',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '19/04/2010',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=979683',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB979683)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB979683',
            'COMMENTS' => undef
        },
        {
            'GUID' => 'KB954155_WM9',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Media Player (KB954155)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/?kbid=954155',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '09/11/2009',
            'RELEASE_TYPE' => undef
        },
        {
            'HELPLINK' => 'http://support.microsoft.com/kb/958484',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Hotfix',
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => 'C:\\windows\\system32\\msiexec.exe /package {CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9} /uninstall {A7EEA2F2-BFCD-4A54-A575-7B81A786E658} /qb+ REBOOTPROMPT=\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB958484',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Hotfix for Microsoft .NET Framework 3.5 SP1 (KB958484)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1'
        },
        {
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => 'Symantec Backup Exec Remote Agent for Windows Systems 32-bit',
            'GUID' => 'Remote Agent for Windows Servers',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '11.0.6235',
            'URL_INFO_ABOUT' => 'http://www.symantec.com',
            'NAME' => 'Symantec Backup Exec Remote Agent for Windows Systems',
            'USERNAME' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Symantec Corporation',
            'INSTALLDATE' => '10/12/2009',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef
        },
        {
            'NAME' => 'Security Update for Windows XP (KB2419632)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2419632',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '17/01/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2419632',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2585542',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '17/01/2012',
            'COMMENTS' => undef,
            'GUID' => 'KB2585542',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2585542)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB977165)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB977165',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '15/02/2010',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=977165',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '27/09/2011',
            'RELEASE_TYPE' => 'Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2616676',
            'VERSION' => '2',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Update for Windows XP (KB2616676-v2)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB2616676-v2',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB974392)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB974392',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/12/2009',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=974392',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/?kbid=936782',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '23/09/2007',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB936782_WMP10',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Media Player 10 (KB936782)',
            'VERSION' => undef
        },
        {
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-001F-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '14.0.6029.1000',
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Microsoft Office Proof (English) 2010',
            'USERNAME' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '20/12/2011',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Adobe Flash Player 11 Plugin',
            'URL_INFO_ABOUT' => 'http://www.adobe.com',
            'VERSION' => '11.1.102.62',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{35E1B1BF-D8E5-4B7F-9FD6-87D2E5694015}',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '20/02/2012',
            'UNINSTALL_STRING' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Adobe Systems Incorporated',
            'NO_REMOVE' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2553185',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553185',
            'NAME' => 'Security Update for Microsoft PowerPoint 2010 (KB2553185) 32-Bit Edition',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{61461470-8168-4F4B-97B7-617AF354F028}',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '17/04/2012',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2653956',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2653956)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB2653956',
            'COMMENTS' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=982665',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '16/08/2010',
            'RELEASE_TYPE' => 'Security Update',
            'GUID' => 'KB982665',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB982665)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB2360131-IE8',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2360131)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2360131',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '18/10/2010',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef,
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'Windows Media Format Runtime',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Windows Media Format Runtime',
            'URL_INFO_ABOUT' => undef
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=980302',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '05/04/2010',
            'GUID' => 'KB980302-IE8',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Update for Windows Internet Explorer 8 (KB980302)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '14.0.6029.1000',
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Microsoft Office Outlook MUI (English) 2010',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-001A-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'INSTALLDATE' => '17/04/2012',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2479943',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/03/2011',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2479943',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2479943)',
            'VERSION' => '1'
        },
        {
            'INSTALLDATE' => '23/08/2007',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/923723',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '20050502.101010',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Step By Step Interactive Training (KB923723)',
            'URL_INFO_ABOUT' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB923723',
            'COMMENTS' => undef
        },
        {
            'INSTALLDATE' => '14/06/2010',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/?kbid=978695',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Media Player (KB978695)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB978695_WM9',
            'COMMENTS' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB932471.T301_380ToU433_380',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Hotfix for Microsoft .NET Framework 3.0 (KB932471)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Hotfix',
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => 'C:\\WINDOWS\\system32\\msiexec.exe /promptrestart /uninstall {ECD292A0-0347-4244-8C24-5DBCE990FB40} /package {BAF78226-3200-4DB4-BE33-4D922A799840}'
        },
        {
            'GUID' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB963707',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Update for Microsoft .NET Framework 3.5 SP1 (KB963707)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/963707',
            'UNINSTALL_STRING' => 'C:\\WINDOWS\\system32\\msiexec.exe /package {CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9} /uninstall {B2AE9C82-DC7B-3641-BFC8-87275C4F3607} /qb+ REBOOTPROMPT=\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => undef
        },
        {
            'INSTALLDATE' => '02/04/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=960225',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB960225)',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB960225'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB951748',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB951748)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=951748',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '09/07/2008',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2485376',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2485376)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2485376',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '14/02/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'HELPLINK' => 'http://support.microsoft.com?kbid=2160329',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '16/08/2010',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB2160329',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2160329)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '16/08/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2536276',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2536276-v2)',
            'USERNAME' => undef,
            'VERSION' => '2',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB2536276-v2',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2479628',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2479628)',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2479628',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '14/02/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'INSTALLDATE' => '20/12/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2296199',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2296199)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2296199',
            'COMMENTS' => undef
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB975561',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB975561)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=975561',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '15/03/2010',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'NAME' => 'Windows Media Player 10',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'Windows Media Player',
            'COMMENTS' => undef,
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2530548)',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB2530548-IE8',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '21/06/2011',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2530548',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '08/07/2008',
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'PUBLISHER' => 'Adobe Systems Inc.',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Adobe AIR',
            'USERNAME' => undef,
            'VERSION' => '1.0.8.4990',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => '{00203668-8170-44A0-BE44-B632FA4D780F}',
            'COMMENTS' => undef
        },
        {
            'GUID' => '{90140000-001B-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '14.0.6029.1000',
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office Word MUI (English) 2010',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '04/10/2011',
            'RELEASE_TYPE' => undef
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Media Player (KB911564)',
            'USERNAME' => undef,
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB911564',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '05/04/2006',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/?kbid=911564'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/?kbid=968816',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '09/11/2009',
            'RELEASE_TYPE' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB968816_WM9',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Media Player (KB968816)',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB925398_WMP64',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Media Player 6.4 (KB925398)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'HELPLINK' => 'http://support.microsoft.com/?kbid=925398',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '13/12/2006',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => undef
        },
        {
            'UNINSTALL_STRING' => 'C:\\Program Files\\Network Console\\NetworkConsole.exe uninstall /I{5B21BB9A-E23E-472b-AD2A-FB9B06A4727C}',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'LogMeIn Inc.',
            'HELPLINK' => 'http://www.logmein.com',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => '9.00.175',
            'USERNAME' => undef,
            'NAME' => 'Network Console',
            'URL_INFO_ABOUT' => 'http://www.logmein.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'Network Console',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'COMMENTS' => undef,
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2656368',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2656368)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2656368',
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {9EC88EA8-4ABE-393C-87BD-90EABB1C4C9B} /parameterfolder Client',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB981322)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB981322',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '20/09/2010',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=981322',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB982132',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB982132)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'HELPLINK' => 'http://support.microsoft.com?kbid=982132',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '18/10/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef,
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'M979906',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft .NET Framework 1.1 Security Update (KB979906)'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '31/10/2008',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=957095',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB957095)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB957095',
            'COMMENTS' => undef
        },
        {
            'INSTALLDATE' => '05/04/2006',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1.5.2316.0',
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Windows Journal Viewer',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => 'A viewer for Windows Journal documents.',
            'GUID' => '{43DCF766-6838-4F9A-8C91-D92DA586DFA8}'
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2511455',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2511455)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2511455',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '18/04/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'GUID' => '{AC76BA86-7AD7-1033-7B44-AA1000000001}',
            'COMMENTS' => '   ',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '10.1.2',
            'URL_INFO_ABOUT' => 'http://www.adobe.com',
            'USERNAME' => undef,
            'NAME' => 'Adobe Reader X (10.1.2)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Adobe Systems Incorporated',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '09/02/2012',
            'RELEASE_TYPE' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '03/09/2009',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=973507',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB973507)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB973507',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB953838',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB953838)',
            'VERSION' => '1',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com?kbid=953838',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '10.1.2.3.0',
            'URL_INFO_ABOUT' => 'http://www.oracle.com',
            'NAME' => 'Oracle Calendar',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => ' ',
            'GUID' => '{4DA016C7-9AC2-4BA7-AD31-3EBA29BC21B1}',
            'INSTALLDATE' => '24/10/2006',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Oracle'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-00BA-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'VERSION' => undef
        },
        {
            'USERNAME' => undef,
            'NAME' => 'NLSDownlevelMapping',
            'URL_INFO_ABOUT' => undef,
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'NLSDownlevelMapping',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT
        },
        {
            'INSTALLDATE' => '04/10/2011',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '14.0.6029.1000',
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Microsoft Office Shared Setup Metadata MUI (English) 2010',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-0115-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2592799',
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB2592799)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2592799',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/10/2011',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2553267',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2553267) 32-Bit Edition',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553267',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{18B3CF2A-73F7-4716-B1AE-86D68726D408}'
        },
        {
            'GUID' => '{90140000-001F-040C-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '14.0.6029.1000',
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Microsoft Office Proof (French) 2010',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '20/12/2011',
            'RELEASE_TYPE' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2487367',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => 'c:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\setup.exe /uninstallpatch {42A3562E-8B4E-39A4-B82D-CC12F82889E3} /parameterfolder Extended',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2487367',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Extended (KB2487367)'
        },
        {
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {DB31DEDD-BF95-31E7-A9B7-5480561CEFF3} /parameterfolder Client',
            'HELPLINK' => 'http://support.microsoft.com/kb/2572078',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2572078)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2572078',
            'COMMENTS' => undef
        },
        {
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{7AC49FC8-F8D2-4DD8-9086-09E52385A21F}',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2553092)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553092',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'HELPLINK' => 'http://support.microsoft.com/kb/2553092',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '15/01/2009',
            'PUBLISHER' => 'Martin Prikryl',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://winscp.net/forum/',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NAME' => 'WinSCP 4.0.7',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://winscp.net/',
            'VERSION' => '4.0.7',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'winscp3_is1',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-00A1-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => 'Symantec Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '25/01/2012',
            'UNINSTALL_STRING' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => '{FA689023-0B72-4771-98A6-A1C927E58207}',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Symantec Endpoint Protection',
            'USERNAME' => undef,
            'VERSION' => '12.1.1000.157'
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'WgaNotify',
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Windows Genuine Advantage Notifications (KB905474)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://www.microsoft.com/genuine',
            'VERSION' => '1.5.0554.0',
            'HELPLINK' => 'http://support.microsoft.com?kbid=905474',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '16/06/2006',
            'UNINSTALL_STRING' => undef
        },
        {
            'INSTALLDATE' => '09/07/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=970238',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB970238)',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB970238',
            'COMMENTS' => undef
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB980182-IE8',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Update for Windows Internet Explorer 8 (KB980182)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=980182',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '05/04/2010',
            'RELEASE_TYPE' => 'Update'
        },
        {
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2518870)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2518870',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {2CE2EB39-45C8-32D4-8A99-5529C38F1B99} /parameterfolder Client',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com/kb/2518870',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'HighMAT Extension to Microsoft Windows XP CD Writing Wizard',
            'USERNAME' => undef,
            'VERSION' => '1.1.1905.1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => '{FCE65C4E-B0E8-4FBD-AD16-EDCBE6CD591F}',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '05/04/2006',
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2508272',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2508272)',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2508272',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '18/04/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB2641653',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2641653)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2641653',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '16/03/2012'
        },
        {
            'URL_INFO_ABOUT' => 'http://www.oo-software.com',
            'USERNAME' => undef,
            'NAME' => 'O&O Event Viewer',
            'VERSION' => '1.0.270',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => '{ED088F40-C86D-4548-9EAB-54CF3FEA3579}',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '23/02/2011',
            'PUBLISHER' => 'O&O Software GmbH',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '04/10/2011',
            'GUID' => '{90140000-0010-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Microsoft Software Update for Web Folders  (English) 14',
            'USERNAME' => undef,
            'VERSION' => '14.0.6029.1000',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0117-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION' => undef
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB982214)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB982214',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '16/08/2010',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=982214'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '15/11/2011',
            'COMMENTS' => undef,
            'GUID' => '{90140000-00A1-0409-0000-0000000FF1CE}',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Microsoft Office OneNote MUI (English) 2010',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION' => '14.0.6029.1000',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'GUID' => '{5D6991B6-0406-4518-9A6E-3DBBF760BB1B}',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1.2.1.0',
            'NAME' => 'PDFCREATOR1.2.1XP',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '12/07/2011',
            'RELEASE_TYPE' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2660465',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '21/02/2012',
            'RELEASE_TYPE' => 'Security Update',
            'COMMENTS' => undef,
            'GUID' => 'KB2660465',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2660465)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB971633)',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB971633',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '03/09/2009',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=971633',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB978601',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB978601)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=978601',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '19/04/2010'
        },
        {
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '20/12/2010',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2467659',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB2467659)',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB2467659',
            'COMMENTS' => undef
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2570222',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '16/08/2011',
            'COMMENTS' => undef,
            'GUID' => 'KB2570222',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2570222)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'COMMENTS' => undef,
            'GUID' => '{90140000-0016-0409-0000-0000000FF1CE}',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office Excel MUI (English) 2010',
            'VERSION' => '14.0.6029.1000',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '04/10/2011'
        },
        {
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Media Player (KB952069)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB952069_WM9',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '15/01/2009',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com/?kbid=952069',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB954459',
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB954459)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'HELPLINK' => 'http://support.microsoft.com?kbid=954459',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '15/01/2009',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2436673',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '20/12/2010',
            'COMMENTS' => undef,
            'GUID' => 'KB2436673',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Windows XP (KB2436673)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2553065',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2553065)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553065',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{A8686D24-1E89-43A1-973E-05A258D2B3F8}',
            'COMMENTS' => undef
        },
        {
            'INSTALLDATE' => '19/07/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2507938',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2507938)',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2507938',
            'COMMENTS' => undef
        },
        {
            'INSTALLDATE' => '18/04/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2509553',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2509553)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2509553'
        },
        {
            'INSTALLDATE' => '18/05/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=961373',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB961373)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB961373',
            'COMMENTS' => undef
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Hotfix for Windows Media Format SDK (KB902344)',
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB902344',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '05/04/2006',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=902344',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-001F-040C-0000-0000000FF1CE}_Office14.PROPLUS_{46298F6A-1E7E-4D4A-B5F5-106A4F0E48C6}',
            'COMMENTS' => undef,
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft'
        },
        {
            'INSTALLDATE' => '20/12/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2440591',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2440591)',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2440591'
        },
        {
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '09/02/2012',
            'PUBLISHER' => 'ScriptLogic Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'URL_INFO_ABOUT' => 'http://www.scriptlogic.com',
            'NAME' => 'Privilege Authority Client',
            'USERNAME' => undef,
            'VERSION' => '2.7.1.80',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => '{41BDFA12-0E3D-4AA4-ACBC-CF64E1AE18FF}',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'COMMENTS' => 'Mozilla Firefox 10.0.2 (x86 en-US)',
            'GUID' => 'Mozilla Firefox 10.0.2 (x86 en-US)',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Mozilla Firefox 10.0.2 (x86 en-US)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://www.mozilla.com/en-US/',
            'VERSION' => '10.0.2',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Mozilla',
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => 'C:\\Program Files\\Mozilla Firefox\\uninstall\\helper.exe',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef
        },
        {
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '10/04/2008',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=test',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'XML Paper Specification Shared Components Pack 1.0',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'XpsEPSC',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '20/09/2010',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2141007',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB2141007)',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2141007'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '31/10/2008',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=956391',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB956391)',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB956391'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '31/10/2008',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=938464',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB938464)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB938464',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB981997',
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB981997)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'HELPLINK' => 'http://support.microsoft.com?kbid=981997',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '16/08/2010',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-001B-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'HELPLINK' => 'http://support.microsoft.com/kb/2553270',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2553270) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553270',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => '{90140000-001F-040C-0000-0000000FF1CE}_Office14.PROPLUS_{15058154-469F-4794-ACD5-94F8420F9B80}',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'GUID' => 'KB975558_WM8',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Media Player (KB975558)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/?kbid=975558',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '20/09/2010',
            'RELEASE_TYPE' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553181',
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2553181) 32-Bit Edition',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{48E1B6C2-7299-4F3F-AA63-42F0ACE55AA4}',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2553181',
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Hotfix for Windows XP (KB2443685)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2443685',
            'RELEASE_TYPE' => 'Hotfix',
            'INSTALLDATE' => '28/03/2011',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2443685',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'GUID' => 'KB2296011',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Windows XP (KB2296011)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2296011',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/10/2010'
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-002C-0409-0000-0000000FF1CE}_Office14.PROPLUS_{7CA93DF4-8902-449E-A42E-4C5923CFBDE3}'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://go.microsoft.com/fwlink/?LinkID=163792',
            'NAME' => 'Windows Management Framework Core',
            'USERNAME' => undef,
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB968930',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => 'Software Update',
            'INSTALLDATE' => '01/02/2010',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://go.microsoft.com/fwlink/?LinkID=163790',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB971486)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB971486',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/11/2009',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=971486',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2423089',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '20/12/2010',
            'RELEASE_TYPE' => 'Security Update',
            'GUID' => 'KB2423089',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2423089)',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2508429',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/04/2011',
            'GUID' => 'KB2508429',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2508429)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2079403',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '16/08/2010',
            'RELEASE_TYPE' => 'Security Update',
            'COMMENTS' => undef,
            'GUID' => 'KB2079403',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2079403)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '09/08/2011',
            'RELEASE_TYPE' => 'Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2264107',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB2264107)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB2264107',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'COMMENTS' => undef,
            'GUID' => '{90140000-0016-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef
        },
        {
            'HELPLINK' => 'http://support.microsoft.com/kb/2468871',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Update',
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {5E9CF3A4-ADB3-3080-A8BF-976A28340758} /parameterfolder Client',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2468871',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Update for Microsoft .NET Framework 4 Client Profile (KB2468871)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com'
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '03/09/2009',
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Security Update for CAPICOM (KB931906)',
            'USERNAME' => undef,
            'VERSION' => '2.1.0.2',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => '{0EFDF2F9-836D-4EB7-A32D-038BD3F1FB2A}',
            'COMMENTS' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/11/2009',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=975025',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB975025)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB975025',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '31/10/2008',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=954211',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB954211)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB954211',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '09/08/2011',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2492386',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB2492386)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2492386',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB971513',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft Windows (KB971513)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com/kb/971513',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '09/11/2009',
            'RELEASE_TYPE' => '%HOTFIX%'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '20050502.101010',
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Security Update for Step By Step Interactive Training (KB898458)',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB898458',
            'INSTALLDATE' => '05/04/2006',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/898458',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB982802)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB982802',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '20/09/2010',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=982802',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'NAME' => 'Security Update for Microsoft Office 2010 (KB2598039) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2598039',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{01F2485C-FAEE-47E7-986E-B4F2FFC22D57}',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2598039',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'Microsoft'
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2620712',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2620712)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2620712',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '20/12/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB959426)',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB959426',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/05/2009',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=959426',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'O&O Software GmbH',
            'INSTALLDATE' => '30/04/2011',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{C6DC78B1-C060-4621-8140-226380141AA1}',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '11.5.4065',
            'URL_INFO_ABOUT' => 'http://www.oo-software.com',
            'USERNAME' => undef,
            'NAME' => 'O&O Defrag Workstation'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '02/04/2009',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=958690',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB958690)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB958690'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB946648',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB946648)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=946648',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008'
        },
        {
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2553439',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'NAME' => 'Update for Microsoft Excel 2010 (KB2553439) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553439',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{3D1F379C-AA64-4823-90A4-A8DDD4B48C21}',
            'COMMENTS' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Extended (KB2416472)',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2416472',
            'COMMENTS' => undef,
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => 'c:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\setup.exe /uninstallpatch {7A2C18A1-D2A2-3177-82F1-5FE9CC08ECB0} /parameterfolder Extended',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2416472',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB978338)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB978338',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '19/04/2010',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=978338'
        },
        {
            'GUID' => 'FF&TB 1.5 + Plugins1',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'NAME' => 'FF&TB 1.5 + Plugins1',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => 'C:\\DOCUME~1\\ALLUSE~1\\APPLIC~1\\Symantec\\Ghost\\AUTOIN~1\\INSTAL~1\\~0000.exe cfg=\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2259922',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '20/09/2010',
            'RELEASE_TYPE' => 'Security Update',
            'GUID' => 'KB2259922',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2259922)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=971468',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '15/02/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB971468',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB971468)'
        },
        {
            'NAME' => 'Security Update for Windows XP (KB961371-v2)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '2',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB961371-v2',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '03/09/2009',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=961371',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-001F-0409-0000-0000000FF1CE}_Office14.PROPLUS_{99ACCA38-6DD3-48A8-96AE-A283C9759279}',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'VERSION' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\'
        },
        {
            'GUID' => '{98166E4E-CB20-4039-AD27-DF0BFA772352}',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://www.oo-software.com',
            'NAME' => 'O&O DriveLED Workstation',
            'USERNAME' => undef,
            'VERSION' => '4.1.119',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'O&O Software GmbH',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '23/02/2011'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'IDNMitigationAPIs',
            'URL_INFO_ABOUT' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'IDNMitigationAPIs',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Proxy Networks, Inc.',
            'INSTALLDATE' => '11/12/2009',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{1AE60321-BFC1-43F3-95D6-B03C420AF04D}',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '7.0.1515',
            'URL_INFO_ABOUT' => 'http://www.proxynetworks.com',
            'USERNAME' => undef,
            'NAME' => 'PROXY Pro Master'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '17/01/2012',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2631813',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2631813)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2631813'
        },
        {
            'UNINSTALL_STRING' => 'C:\\gs\\uninstgs.exe \\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'VERSION' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'GPL Ghostscript Fonts',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'GPL Ghostscript Fonts',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '16/08/2010',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2115168',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2115168)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB2115168',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2503665',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '21/06/2011',
            'COMMENTS' => undef,
            'GUID' => 'KB2503665',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2503665)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'NAME' => 'Microsoft Office Professional Plus 2010',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION' => '14.0.6029.1000',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'Office14.PROPLUS',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 0,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=972270',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '18/01/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB972270',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB972270)',
            'USERNAME' => undef
        },
        {
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2589320',
            'NAME' => 'Security Update for Microsoft Office 2010 (KB2589320) 32-Bit Edition',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{DCE6D0BF-93E4-46C5-9A7C-F1EFF9707C02}',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2589320'
        },
        {
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2446708)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2446708',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {3E0806DB-3085-378A-840A-F0D3AE3609D1} /parameterfolder Client',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2446708'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2544893',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '21/06/2011',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2544893',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2544893)',
            'USERNAME' => undef,
            'VERSION' => '1'
        },
        {
            'GUID' => 'KB979687',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB979687)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=979687',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '18/10/2010',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB950759',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB950759)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com?kbid=950759',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2621440)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB2621440',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '16/03/2012',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2621440'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '03/01/2012',
            'COMMENTS' => undef,
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Microsoft .NET Framework 4 Extended',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://go.microsoft.com/fwlink/?LinkId=164164',
            'VERSION' => '4.0.30319',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1.1.4322',
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft .NET Framework 1.1',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{CB2F7EDD-9D1F-43C1-90FC-4F52EAE172A1}',
            'COMMENTS' => undef,
            'INSTALLDATE' => '17/04/2012',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com/kb/2656351',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => 'c:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\setup.exe /uninstallpatch {4952F442-5C1A-38EB-8C23-B18EFE77E20C} /parameterfolder Extended',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => undef,
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2656351',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Extended (KB2656351)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'HELPLINK' => 'http://support.microsoft.com?kbid=2229593',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '19/07/2010',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB2229593',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB2229593)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1'
        },
        {
            'GUID' => 'KB979482',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB979482)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=979482',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/06/2010'
        },
        {
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2121546)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB2121546',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '20/09/2010',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2121546',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=892130',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Windows Genuine Advantage Validation Tool (KB892130)',
            'URL_INFO_ABOUT' => 'http://www.microsoft.com/genuine',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB892130'
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '02/09/2010',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://www.StraightRunning.com/XmingNotes',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Colin Harrison',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Xming-fonts 7.5.0.25',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://www.StraightRunning.com/XmingNotes',
            'VERSION' => '7.5.0.25',
            'FROM' => 'registry',
            'VERSION_MINOR' => 5,
            'VERSION_MAJOR' => 7,
            'COMMENTS' => undef,
            'GUID' => 'Xming-fonts_is1'
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB2345886)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2345886',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '18/10/2010',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2345886'
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0015-0409-0000-0000000FF1CE}',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '14.0.6029.1000',
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office Access MUI (English) 2010',
            'URL_INFO_ABOUT' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '04/10/2011',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef
        },
        {
            'VERSION' => '4.0.2',
            'URL_INFO_ABOUT' => 'http://www.cit.cornell.edu/security/tools',
            'USERNAME' => undef,
            'NAME' => 'Spider4',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => 'This installer database contains the logic and data required to install Spider4.',
            'GUID' => '{FB9448E7-477B-4F92-81A0-90754E2A259B}',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '27/04/2010',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Cornell University',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef
        },
        {
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2483614)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB2483614',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '28/03/2011',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2483614'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '05/07/2010',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{A3051CD0-2F64-3813-A88D-B8DCCDE8F8C7}',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '3.2.30729',
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft .NET Framework 3.0 Service Pack 2'
        },
        {
            'INSTALLDATE' => '20/12/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2618451',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2618451)',
            'USERNAME' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2618451',
            'COMMENTS' => undef
        },
        {
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {4952F442-5C1A-38EB-8C23-B18EFE77E20C} /parameterfolder Client',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2656351',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2656351)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2656351',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '14.0.6029.1000',
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office Publisher MUI (English) 2010',
            'URL_INFO_ABOUT' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-0019-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'INSTALLDATE' => '04/10/2011',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB974455',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Windows XP (KB974455)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=974455',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/11/2009'
        },
        {
            'INSTALLDATE' => '22/11/2010',
            'RELEASE_TYPE' => 'Hotfix',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2158563',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Hotfix for Windows XP (KB2158563)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2158563'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=979559',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/06/2010',
            'COMMENTS' => undef,
            'GUID' => 'KB979559',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB979559)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'INSTALLDATE' => '04/10/2011',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '14.0.6029.1000',
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office PowerPoint MUI (English) 2010',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0018-0409-0000-0000000FF1CE}'
        },
        {
            'HELPLINK' => 'http://support.microsoft.com?kbid=980195',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/06/2010',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB980195',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB980195)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1'
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB956841)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB956841',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '31/10/2008',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=956841'
        },
        {
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '14/12/2009',
            'UNINSTALL_STRING' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => '{86493ADD-824D-4B8E-BD72-8C5DCDC52A71}',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'MSXML 4.0 SP2 (KB954430)',
            'URL_INFO_ABOUT' => undef,
            'VERSION' => '4.20.9870.0'
        },
        {
            'GUID' => '{90140000-0117-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '14.0.6029.1000',
            'NAME' => 'Microsoft Office Access Setup Metadata MUI (English) 2010',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '04/10/2011',
            'RELEASE_TYPE' => undef
        },
        {
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'Branding',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Branding',
            'URL_INFO_ABOUT' => undef,
            'VERSION' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2553406',
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{90140000-001A-0409-0000-0000000FF1CE}_Office14.PROPLUS_{1EEFF749-6F29-4F0B-AB08-4C6EA52AA110}',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553406',
            'NAME' => 'Update for Microsoft Outlook Social Connector 2010 (KB2553406) 32-Bit Edition',
            'USERNAME' => undef
        },
        {
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2536276)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB2536276',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '21/06/2011',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2536276',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Hotfix for Windows XP (KB970653-v3)',
            'USERNAME' => undef,
            'VERSION' => '3',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB970653-v3',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Hotfix',
            'INSTALLDATE' => '03/09/2009',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=970653'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB977914',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB977914)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=977914',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '15/02/2010',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Hummingbird Ltd.',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '23/08/2007',
            'UNINSTALL_STRING' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => 'Connectivity Secure Shell 2006 Setup for Windows Installer',
            'GUID' => '{82FA2169-16BD-404E-A743-FDDAC1DA81C1}',
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Hummingbird Connectivity Secure Shell 2006',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://www.hummingbird.com',
            'VERSION' => '11.0.6.0'
        },
        {
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0015-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Update for Windows XP (KB2607712)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB2607712',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '13/09/2011',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2607712',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB973869',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB973869)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'HELPLINK' => 'http://support.microsoft.com?kbid=973869',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Update for Windows XP (KB943729)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB943729',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '09/11/2009',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=943729'
        },
        {
            'GUID' => 'KB950760',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB950760)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=950760',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '10/04/2008',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '20/02/2012',
            'UNINSTALL_STRING' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'PUBLISHER' => 'Sun Microsystems, Inc.',
            'NO_REMOVE' => 1,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Java Auto Updater',
            'URL_INFO_ABOUT' => undef,
            'VERSION' => '2.0.7.1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => '{4A03706F-666A-4037-7777-5F2748764D10}',
            'COMMENTS' => undef
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=973815',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => 'Update',
            'COMMENTS' => undef,
            'GUID' => 'KB973815',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'NAME' => 'Update for Windows XP (KB973815)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB2279986',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2279986)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2279986',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/10/2010',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-006E-0409-0000-0000000FF1CE}_Office14.PROPLUS_{4560037C-E356-444A-A015-D21F487D809E}',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0
        },
        {
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2566454)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB2566454',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '16/08/2011',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2566454'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0019-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB912452',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Update for Windows Media Player 10 (KB912452)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com/?kbid=912452',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '05/04/2006'
        },
        {
            'RELEASE_TYPE' => '%HOTFIX%',
            'INSTALLDATE' => '18/10/2011',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2564958',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Microsoft Windows (KB2564958)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2564958'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=980436',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '16/08/2010',
            'COMMENTS' => undef,
            'GUID' => 'KB980436',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB980436)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553270',
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft Office 2010 (KB2553270) 32-Bit Edition',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => '{90140000-001F-0409-0000-0000000FF1CE}_Office14.PROPLUS_{17E7B9AB-2DD2-457D-8D8E-CD14ACA973FE}',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/2553270'
        },
        {
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'HELPLINK' => 'http://support.microsoft.com/kb/2460049',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{047B0968-E622-4FAA-9B4B-121FA109EDDE}',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'NAME' => 'Microsoft Office 2010 Service Pack 1 (SP1)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2460049',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '15/01/2009',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=955069',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB955069)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB955069',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com/kb/2597170',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Microsoft Visio Viewer 2010 (KB2597170) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2597170',
            'VERSION' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{011FE2F6-5427-4EC9-AE80-6B28E69781C1}',
            'COMMENTS' => undef
        },
        {
            'HELPLINK' => 'http://support.microsoft.com?kbid=958869',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '09/11/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB958869',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB958869)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '14.0.6029.1000',
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office Professional Plus 2010',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}',
            'INSTALLDATE' => '17/04/2012',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'GUID' => 'M2656370',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft .NET Framework 1.1 Security Update (KB2656370)',
            'URL_INFO_ABOUT' => undef,
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef
        },
        {
            'HELPLINK' => 'http://support.microsoft.com?kbid=976662',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '01/03/2010',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB976662-IE8',
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Windows Internet Explorer 8 (KB976662)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1'
        },
        {
            'COMMENTS' => undef,
            'GUID' => '{90140000-00A1-0409-0000-0000000FF1CE}_Office14.PROPLUS_{9865DC3A-2898-48D9-B96A-46397571C934}',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'NAME' => 'Update for Microsoft OneNote 2010 (KB2553290) 32-Bit Edition',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553290',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'HELPLINK' => 'http://support.microsoft.com/kb/2553290',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2183461-IE8',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2183461)',
            'VERSION' => '1',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2183461',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '16/08/2010',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'INSTALLDATE' => '18/04/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2506212',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2506212)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2506212',
            'COMMENTS' => undef
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'Xming_is1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => 7,
            'VERSION_MINOR' => 5,
            'URL_INFO_ABOUT' => 'http://www.StraightRunning.com/XmingNotes',
            'USERNAME' => undef,
            'NAME' => 'Xming 7.5.0.15',
            'VERSION' => '7.5.0.15',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Colin Harrison',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://www.StraightRunning.com/XmingNotes',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '23/02/2010'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Microsoft .NET Framework 2.0 Service Pack 2',
            'USERNAME' => undef,
            'VERSION' => '2.2.30729',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => '{C09FB3CD-3D0C-3F2D-899A-6A1D67F2073F}',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '17/04/2012',
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB958215)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB958215',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '15/01/2009',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com?kbid=958215',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB954600',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB954600)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=954600',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '15/01/2009',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'GUID' => 'KB2347290',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2347290)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2347290',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '20/09/2010'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB980232)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB980232',
            'INSTALLDATE' => '19/04/2010',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=980232',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB957097)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB957097',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '15/01/2009',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=957097',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => undef,
            'NAME' => 'Microsoft .NET Framework 1.1 Security Update (KB2656353)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'M2656353',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => undef
        },
        {
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'WIC',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '3.0.0.0',
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Windows Imaging Component',
            'USERNAME' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '10/04/2008',
            'RELEASE_TYPE' => 'HotFix',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'USERNAME' => undef,
            'NAME' => 'ie7',
            'URL_INFO_ABOUT' => undef,
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'ie7',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/12/2009',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=976325',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB976325)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB976325-IE8',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '15/11/2011',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'VERSION' => '14.0.6029.1000',
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'Microsoft Office Shared MUI (English) 2010',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => '{90140000-006E-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB969059)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB969059',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/11/2009',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=969059',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB974112',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB974112)',
            'VERSION' => '1',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=974112',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/11/2009',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2416400',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '20/12/2010',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB2416400-IE8',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2416400)',
            'USERNAME' => undef,
            'VERSION' => '1'
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2478663',
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2478663)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'HELPLINK' => 'http://support.microsoft.com/kb/2478663',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {728D9A6A-2206-31E8-9F65-C3EABEFCF53E} /parameterfolder Client'
        },
        {
            'UNINSTALL_STRING' => 'C:\\WINDOWS\\system32\\msiexec.exe /package {CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9} /uninstall  /qb+ REBOOTPROMPT=\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => 'Hotfix',
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com/kb/953595',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Hotfix for Microsoft .NET Framework 3.5 SP1 (KB953595)',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB953595',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'VERSION' => '3',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Hotfix for Windows XP (KB969084)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB969084',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '01/02/2010',
            'RELEASE_TYPE' => 'Hotfix',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=969084'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/06/2010',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=975562',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NAME' => 'Security Update for Windows XP (KB975562)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB975562',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'GUID' => 'KB2412687',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2412687)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2412687',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/04/2011'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB969897)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB969897',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2009',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => 'http://support.microsoft.com?kbid=969897',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB975713',
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB975713)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'HELPLINK' => 'http://support.microsoft.com?kbid=975713',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '15/02/2010',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2286198',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/08/2010',
            'COMMENTS' => undef,
            'GUID' => 'KB2286198',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2286198)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'HELPLINK' => 'http://support.microsoft.com?kbid=951376',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NAME' => 'Security Update for Windows XP (KB951376-v2)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '2',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB951376-v2',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => 'C:\\Program Files\\FusionInventory-Agent\\uninstFI.exe',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => 'FusionInventory Team',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://www.FusionInventory.org',
            'USERNAME' => undef,
            'NAME' => 'FusionInventory Agent',
            'VERSION' => '2.2.0-2',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'FusionInventory Agent',
            'COMMENTS' => undef
        },
        {
            'NAME' => 'Security Update for Windows XP (KB2387149)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB2387149',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/10/2010',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2387149',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'VERSION' => '1.2.1',
            'USERNAME' => undef,
            'NAME' => 'PDFCreator',
            'URL_INFO_ABOUT' => 'http://www.sf.net/projects/pdfcreator',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => 'PDFCreator - Opensource',
            'GUID' => '{0001B4FD-9EA3-4D90-A79E-FD14BA3AB01D}',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => 'C:\\Program Files\\PDFCreator\\unins000.exe',
            'INSTALLDATE' => '05/07/2011',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Frank Heindörfer, Philip Chinery',
            'HELPLINK' => 'http://www.sf.net/projects/pdfcreator',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '17/04/2012',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '4.0.30319',
            'USERNAME' => undef,
            'NAME' => 'Microsoft .NET Framework 4 Client Profile',
            'URL_INFO_ABOUT' => 'http://go.microsoft.com/fwlink/?LinkId=164164'
        },
        {
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB971557)',
            'USERNAME' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB971557',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=971557'
        },
        {
            'NO_REMOVE' => 0,
            'PUBLISHER' => 'Microsoft',
            'HELPLINK' => 'http://support.microsoft.com/kb/2553290',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'COMMENTS' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{BEBC2484-290C-46AD-9834-6DAD1FA80273}',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft OneNote 2010 (KB2553290) 32-Bit Edition',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553290',
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'GUID' => 'KB2633171',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Windows XP (KB2633171)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2633171',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '20/12/2011'
        },
        {
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => '{90140000-002C-0409-0000-0000000FF1CE}',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '14.0.6029.1000',
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft Office Proofing (English) 2010',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'HELPLINK' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '04/10/2011',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '19/04/2010',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=981332',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB981332)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB981332-IE8',
            'COMMENTS' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://www.opera.com/support',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Opera Software ASA',
            'INSTALLDATE' => undef,
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => '\\',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'Opera 11.52.1100',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '11.52.1100',
            'URL_INFO_ABOUT' => 'http://www.opera.com',
            'USERNAME' => undef,
            'NAME' => 'Opera 11.52'
        },
        {
            'GUID' => 'KB2567053',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2567053)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2567053',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '18/10/2011',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'GUID' => 'Microsoft .NET Framework 1.1  (1033)',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Microsoft .NET Framework 1.1',
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => 'msiexec.exe /X {CB2F7EDD-9D1F-43C1-90FC-4F52EAE172A1}',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB969947',
            'COMMENTS' => undef,
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB969947)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'HELPLINK' => 'http://support.microsoft.com?kbid=969947',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '14/12/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'GUID' => 'KB972260',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB972260)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=972260',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '23/11/2011',
            'GUID' => 'RealAlt_is1',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => 2,
            'VERSION_MINOR' => 0,
            'URL_INFO_ABOUT' => undef,
            'USERNAME' => undef,
            'NAME' => 'Real Alternative 2.0.2 Lite',
            'VERSION' => '2.0.2',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'INSTALLDATE' => '02/04/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=960715',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB960715)',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB960715'
        },
        {
            'URL_INFO_ABOUT' => 'http://www.hummingbird.com',
            'NAME' => 'Hummingbird Exceed 2006',
            'USERNAME' => undef,
            'VERSION' => '11.0.28.0',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => '{35DFFE62-9F48-4236-9249-9EAB5C7123C9}',
            'COMMENTS' => 'Exceed 2006 Setup for Windows Installer',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '23/08/2007',
            'PUBLISHER' => 'Hummingbird Ltd.',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef
        },
        {
            'PUBLISHER' => undef,
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => undef,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'COMMENTS' => undef,
            'GUID' => 'Shockwave',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Shockwave',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => undef,
            'VERSION' => undef,
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'URL_INFO_ABOUT' => 'http://www.mozilla.org/',
            'NAME' => 'Mozilla Thunderbird (2.0.0.23)',
            'USERNAME' => undef,
            'VERSION' => '2.0.0.23 (en-US)',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'Mozilla Thunderbird (2.0.0.23)',
            'COMMENTS' => 'Mozilla Thunderbird',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => 'C:\\Program Files\\Mozilla Thunderbird\\uninstall\\helper.exe',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => 'Mozilla',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef
        },
        {
            'GUID' => 'KB973354',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB973354)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=973354',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '03/09/2009'
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com/kb/2468871',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => 'c:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\setup.exe /uninstallpatch {5E9CF3A4-ADB3-3080-A8BF-976A28340758} /parameterfolder Extended',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => undef,
            'COMMENTS' => undef,
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2468871',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Microsoft .NET Framework 4 Extended (KB2468871)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB2535512',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2535512)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2535512',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '21/06/2011',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Windows Internet Explorer 8 (KB976749)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB976749-IE8',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '10/11/2009',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=976749',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=956803',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '31/10/2008',
            'GUID' => 'KB956803',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB956803)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=973346',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB973346)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB973346',
            'COMMENTS' => undef
        },
        {
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2618444-IE8',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2618444)',
            'USERNAME' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2618444',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'INSTALLDATE' => '20/12/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\'
        },
        {
            'COMMENTS' => undef,
            'GUID' => 'KB971961-IE8',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB971961)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=971961',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '10/11/2009',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '14/02/2011',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2476687',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2476687)',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB2476687',
            'COMMENTS' => undef
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=973525',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/11/2009',
            'GUID' => 'KB973525',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB973525)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=978207',
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '25/01/2010',
            'COMMENTS' => undef,
            'GUID' => 'KB978207-IE8',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB978207)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Hotfix for Windows XP (KB961118)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB961118',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Hotfix',
            'INSTALLDATE' => '18/05/2009',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=961118'
        },
        {
            'INSTALLDATE' => '04/10/2011',
            'RELEASE_TYPE' => 'Hotfix',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2570791',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Hotfix for Windows XP (KB2570791)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2570791'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '05/04/2006',
            'RELEASE_TYPE' => undef,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=895181',
            'VERSION' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Windows Media Hotfix - KB895181',
            'USERID' => undef,
            'ARCH' => 'i586',
            'GUID' => 'KB895181',
            'COMMENTS' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry'
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '18/05/2009',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=956572',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB956572)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB956572',
            'COMMENTS' => undef
        },
        {
            'HELPLINK' => 'http://support.microsoft.com?kbid=971737',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '14/12/2009',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB971737',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Update for Windows XP (KB971737)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1'
        },
        {
            'HELPLINK' => 'http://support.microsoft.com/kb/2553096',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'PUBLISHER' => 'Microsoft',
            'NO_REMOVE' => 0,
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{10802A6D-EDBF-4383-BCBD-9D5B32F56D35}',
            'COMMENTS' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Microsoft Office 2010 (KB2553096)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com/kb/2553096',
            'VERSION' => undef
        },
        {
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => '14/12/2009',
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => undef,
            'NAME' => 'MSXML 4.0 SP2 (KB973688)',
            'USERNAME' => undef,
            'VERSION' => '4.20.9876.0',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => '{F662A8E6-F4DC-41A2-901E-8C11F044BDEC}',
            'COMMENTS' => undef
        },
        {
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '20/12/2011',
            'UNINSTALL_STRING' => '\\',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2619339',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2619339)',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'GUID' => 'KB2619339',
            'COMMENTS' => undef
        },
        {
            'INSTALLDATE' => '14/02/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2482017',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2482017)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => undef,
            'GUID' => 'KB2482017-IE8'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '21/02/2012',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2661637',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'NAME' => 'Security Update for Windows XP (KB2661637)',
            'USERNAME' => undef,
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB2661637',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2544521)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB2544521-IE8',
            'COMMENTS' => undef,
            'INSTALLDATE' => '21/06/2011',
            'RELEASE_TYPE' => 'Security Update',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2544521',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => undef,
            'INSTALLDATE' => '29/11/2011',
            'RELEASE_TYPE' => undef,
            'GUID' => '{710f4c1c-cc18-4c49-8cbf-51240c89a1a2}',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '8.0.61001',
            'USERNAME' => undef,
            'NAME' => 'Microsoft Visual C++ 2005 Redistributable',
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'ARCH' => 'i586'
        },
        {
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '20/12/2011',
            'RELEASE_TYPE' => 'Security Update',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2639417',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'VERSION' => '1',
            'NAME' => 'Security Update for Windows XP (KB2639417)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'GUID' => 'KB2639417',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry'
        },
        {
            'GUID' => 'KB951698',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'NAME' => 'Security Update for Windows XP (KB951698)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'HELPLINK' => 'http://support.microsoft.com?kbid=951698',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008'
        },
        {
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'COMMENTS' => 'This is a placeholder for ARP comments for Spelling Dictionaries for Adobe Reader 9.0',
            'GUID' => '{AC76BA86-7AD7-5464-3428-900000000004}',
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '9.0.0',
            'USERNAME' => undef,
            'NAME' => 'Spelling Dictionaries Support For Adobe Reader 9',
            'URL_INFO_ABOUT' => 'http://www.adobe.com',
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Adobe Systems Incorporated',
            'INSTALLDATE' => '03/09/2009',
            'RELEASE_TYPE' => undef,
            'UNINSTALL_STRING' => undef
        },
        {
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB950974)',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'KB950974',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '09/07/2008',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => 1,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=950974'
        },
        {
            'NAME' => 'PuTTY version 0.58',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://www.chiark.greenend.org.uk/~sgtatham/putty/',
            'VERSION' => '0.58',
            'ARCH' => 'i586',
            'USERID' => undef,
            'GUID' => 'PuTTY_is1',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => undef,
            'INSTALLDATE' => undef,
            'PUBLISHER' => 'Simon Tatham',
            'NO_REMOVE' => undef,
            'HELPLINK' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION
        },
        {
            'GUID' => 'KB2524375',
            'COMMENTS' => undef,
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'FROM' => 'registry',
            'VERSION' => '1',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows XP (KB2524375)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERID' => undef,
            'ARCH' => 'i586',
            'NO_REMOVE' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'HELPLINK' => 'http://support.microsoft.com?kbid=2524375',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'INSTALLDATE' => '28/03/2011',
            'RELEASE_TYPE' => 'Security Update'
        },
        {
            'GUID' => 'KB955759',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'USERNAME' => undef,
            'NAME' => 'Update for Windows XP (KB955759)',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'ARCH' => 'i586',
            'USERID' => undef,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'HELPLINK' => 'http://support.microsoft.com?kbid=955759',
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'UNINSTALL_STRING' => '\\',
            'RELEASE_TYPE' => 'Update',
            'INSTALLDATE' => '14/12/2009'
        },
        {
            'ARCH' => 'i586',
            'USERID' => undef,
            'NAME' => 'Security Update for Windows XP (KB956390)',
            'USERNAME' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'VERSION' => '1',
            'FROM' => 'registry',
            'VERSION_MINOR' => undef,
            'VERSION_MAJOR' => undef,
            'GUID' => 'KB956390',
            'COMMENTS' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '31/10/2008',
            'UNINSTALL_STRING' => '\\',
            'HELPLINK' => 'http://support.microsoft.com?kbid=956390',
            'SYSTEM_CATEGORY' => CATEGORY_SYSTEM_COMPONENT,
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef
        },
        {
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=2559049',
            'PUBLISHER' => 'Microsoft Corporation',
            'NO_REMOVE' => undef,
            'RELEASE_TYPE' => 'Security Update',
            'INSTALLDATE' => '16/08/2011',
            'UNINSTALL_STRING' => '\\',
            'FROM' => 'registry',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'COMMENTS' => undef,
            'GUID' => 'KB2559049-IE8',
            'ARCH' => 'i586',
            'USERID' => undef,
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Security Update for Windows Internet Explorer 8 (KB2559049)',
            'VERSION' => '1'
        },
        {
            'USERID' => undef,
            'ARCH' => 'i586',
            'VERSION' => '5',
            'URL_INFO_ABOUT' => 'http://support.microsoft.com',
            'USERNAME' => undef,
            'NAME' => 'Hotfix for Windows XP (KB954550-v5)',
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef,
            'FROM' => 'registry',
            'GUID' => 'KB954550-v5',
            'COMMENTS' => undef,
            'INSTALLDATE' => '02/04/2009',
            'RELEASE_TYPE' => 'Hotfix',
            'UNINSTALL_STRING' => undef,
            'SYSTEM_CATEGORY' => CATEGORY_APPLICATION,
            'HELPLINK' => 'http://support.microsoft.com?kbid=954550',
            'NO_REMOVE' => 1,
            'PUBLISHER' => 'Microsoft Corporation'
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2162169',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2162169',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2478063',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2478063',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2533523',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2533523',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2544514',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2544514',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2572063',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2572063',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2599651',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2599651',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2600211',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2600211',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2600217',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2600217',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2604121',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2604121',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2639327',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2639327',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2160841',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2160841',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2162169',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2162169',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2446708v2',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2446708v2',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2478063',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2478063',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2514805',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2514805',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2533523',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2533523',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2544514',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2544514',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2572063',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2572063',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2599651',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2599651',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2600211',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2600211',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2600217',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2600217',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2604121',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2604121',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2639327',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2639327',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2656405',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2656405',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB2416473',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB2416473',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB2604111',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB2604111',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB350003',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB350003',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
        {
            'ARCH' => 'i586',
            'COMMENTS' => undef,
            'FROM' => 'registry',
            'GUID' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB960043',
            'HELPLINK' => undef,
            'INSTALLDATE' => undef,
            'NAME' => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB960043',
            'NO_REMOVE' => 1,
            'PUBLISHER' => undef,
            'RELEASE_TYPE' => undef,
            'SYSTEM_CATEGORY' => 'application',
            'UNINSTALL_STRING' => undef,
            'URL_INFO_ABOUT' => undef,
            'USERID' => undef,
            'USERNAME' => undef,
            'VERSION' => undef,
            'VERSION_MAJOR' => undef,
            'VERSION_MINOR' => undef
        },
    ]
);

my %hotfixes_tests = (
    xp => [
        {
            FROM         => 'WMI',
            NAME         => 'KB980195',
            COMMENTS     => 'Security Update for Windows XP (KB980195)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB980232',
            COMMENTS     => 'Security Update for Windows XP (KB980232)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB980436',
            COMMENTS     => 'Security Update for Windows XP (KB980436)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB981322',
            COMMENTS     => 'Security Update for Windows XP (KB981322)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB981349',
            COMMENTS     => 'Security Update for Windows XP (KB981349)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB981852',
            COMMENTS     => 'Security Update for Windows XP (KB981852)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB981997',
            COMMENTS     => 'Security Update for Windows XP (KB981997)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB982132',
            COMMENTS     => 'Security Update for Windows XP (KB982132)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB982214',
            COMMENTS     => 'Security Update for Windows XP (KB982214)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB982665',
            COMMENTS     => 'Security Update for Windows XP (KB982665)',
            ARCH         => 'i586',
            INSTALLDATE  => '15/01/2011',
            RELEASE_TYPE => 'Security Update',
            SYSTEM_CATEGORY => CATEGORY_SECURITY_UPDATE
        }
    ]
);

plan tests =>
    scalar (2 * keys %softwares_tests) +
    scalar (keys %hotfixes_tests)      +
    1;

my $inventory = FusionInventory::Agent::Inventory->new();

my $module = Test::MockModule->new(
    'FusionInventory::Agent::Task::Inventory::Win32::Softwares'
);
$module->mock(
    'encodeFromRegistry',
    sub {
        return undef unless $_[0];
        return encode("UTF-8", decode('cp1252', $_[0]));
    }
);

my $tools_module = Test::MockModule->new(
    'FusionInventory::Agent::Tools::Win32'
);

foreach my $test (keys %softwares_tests) {

    $tools_module->mock(
        '_getRegistryKey',
        mockGetRegistryKey($test)
    );

    my $softwares = FusionInventory::Agent::Task::Inventory::Win32::Softwares::_getSoftwaresList();

    cmp_deeply(
        [ sort { compare() } @$softwares ],
        [ sort { compare() } @{$softwares_tests{$test}} ],
        "$test: parsing"
    );
    lives_ok {
        $inventory->addEntry(section => 'SOFTWARES', entry => $_)
            foreach @$softwares;
    } "$test: registering";
}

foreach my $test (keys %hotfixes_tests) {
    $module->mock(
        'getWMIObjects',
        mockGetWMIObjects($test)
    );

    my $hotfixes = FusionInventory::Agent::Task::Inventory::Win32::Softwares::_getHotfixesList(is64bit => 0);
    cmp_deeply(
        $hotfixes,
        $hotfixes_tests{$test},
        "$test hotfixes list"
    );
}

sub compare {
    return
        $a->{NAME}      cmp $b->{NAME}     ||
        $a->{GUID}      cmp $b->{GUID}     ||
        $a->{PUBLISHER} cmp $b->{PUBLISHER};
}
