/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.ConfigRuntimeFactory;
import com.javonet.sdk.RuntimeFactory;
import com.javonet.sdk.tools.ActivationHelper;
import com.javonet.sdk.tools.BinariesUnloader;
import com.javonet.sdk.tools.SdkMessageHelper;
import com.javonet.utils.RuntimeLogger;
import com.javonet.utils.connectiondata.InMemoryConnectionData;
import com.javonet.utils.connectiondata.TcpConnectionData;
import com.javonet.utils.connectiondata.WsConnectionData;
import java.util.Objects;

public final class Javonet {
    public static RuntimeFactory inMemory() {
        return new RuntimeFactory(new InMemoryConnectionData());
    }

    public static RuntimeFactory tcp(TcpConnectionData connectionData) {
        return new RuntimeFactory(connectionData);
    }

    public static RuntimeFactory webSocket(WsConnectionData connectionData) {
        return new RuntimeFactory(connectionData);
    }

    public static ConfigRuntimeFactory withConfig(String path) {
        try {
            Javonet.extractNativeBinaries();
            return new ConfigRuntimeFactory(path);
        }
        catch (Exception e) {
            SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkException", e.getMessage());
            throw e;
        }
    }

    public static int activate(String licenseKey) {
        try {
            if (!Objects.equals(licenseKey, ActivationHelper.getTemporaryLicenseKey())) {
                ActivationHelper.setTemporaryLicenseKey(licenseKey);
                SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkMessage", "Activation");
            }
            ActivationHelper.setTemporaryLicenseKey(licenseKey);
            Javonet.extractNativeBinaries();
            return Transmitter.activate(licenseKey);
        }
        catch (Exception e) {
            SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkException", e.getMessage());
            throw e;
        }
    }

    public static void setConfigSource(String configSource) {
        try {
            Javonet.extractNativeBinaries();
            Transmitter.setConfigSource(configSource);
        }
        catch (Exception e) {
            SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkException", e.getMessage());
            throw e;
        }
    }

    public static void setJavonetWorkingDirectory(String path) {
        try {
            path = path.replace("\\", "/");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            ActivationHelper.setWorkingDirectory(path);
            BinariesUnloader.setWorkingDirectory(path);
            Javonet.extractNativeBinaries();
            Transmitter.setJavonetWorkingDirectory(path);
        }
        catch (Exception e) {
            SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkException", e.getMessage());
            throw e;
        }
    }

    public static String getRuntimeInfo() {
        return RuntimeLogger.getRuntimeInfo();
    }

    private static void extractNativeBinaries() {
        BinariesUnloader.extractBinariesFromJar("Native");
    }

    static {
        SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkMessage", "Javonet SDK initialized");
    }
}

