/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.generator.handler.shared;

import com.javonet.core.generator.handler.GeneratorHandler;
import com.javonet.core.generator.handler.Handlers;
import com.javonet.core.generator.handler.shared.IHandler;
import com.javonet.utils.Command;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;

public class SharedClassNameHandler
implements IHandler {
    @Override
    public Object generateCommand(Object analyzedObject, Command parentCommand, Handlers handlers) {
        return analyzedObject;
    }

    @Override
    public void generateCode(StringBuilder existingStringBuilder, Command commonCommand, Object usedObject, Handlers handlers) {
        String className = GeneratorHandler.getClassNameWithoutPackage(usedObject.toString());
        className = className.replaceAll("@", "");
        className = className.replaceAll("-", "_");
        className = this.replaceGroup("(?m)^(\\d+).*", className, 1, 1, "");
        StringBuilder sb = new StringBuilder(className);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        if (SourceVersion.isKeyword(sb.toString())) {
            sb.append(sb.charAt(sb.length() - 1));
        }
        if (!SourceVersion.isIdentifier(sb.toString())) {
            throw new IllegalArgumentException("Unable to generate correct class name for: " + usedObject.toString());
        }
        existingStringBuilder.append((CharSequence)sb);
    }

    private String replaceGroup(String regex, String source, int groupToReplace, int groupOccurrence, String replacement) {
        Matcher m = Pattern.compile(regex).matcher(source);
        for (int i = 0; i < groupOccurrence; ++i) {
            if (m.find()) continue;
            return source;
        }
        return new StringBuilder(source).replace(m.start(groupToReplace), m.end(groupToReplace), replacement).toString();
    }
}

