
use Getopt::Advance;
use Getopt::Advance::Exception;

sub guess-the-type($p) {
    my %table = %(
        Int     => 'i',
        Str     => 's',
        Array   => 'a',
        Hash    => 'h',
        Num     => 'f',
        Bool    => 'b',
        Any     => 'b',
        Positional  => 'a',
        Associative => 'h',
    );
    if %table{$p.type.^name}:exists {
        my $ft = %table{$p.type.^name};
        given $p.sigil {
            when '$' | '\\' {
                return $ft;
            }
            when '@' {
                if $ft eq 's' {
                    return 'a';
                }  
            }
            when '%' {
                if $ft eq 's' {
                    return 'h';
                }
            }
            default { return Any; }
        }
    } 
    return Any;
}

sub guess-the-name($p) {
    if $p.sigil eq '\\' {
        return $p.name;
    } else {
        if $p.name ~~ /^.<[*\.!]>?(.+)/ {
            return $/[0].Str;
        } else {
            return $p.name;
        }
    }
}

sub mixin-option($os, Sub $s) is export {
    my Int $noa-index = 0;
    my %pos;

    for $s.signature.params -> $param {
        say "PARAM = ", $param;
        if $param.named {
            if $param.slurpy {
                $os.push("{&guess-the-name($param)}=a");
            } else {
                my $type = &guess-the-type($param) ~ ($param.optional ?? "" !! "!");

                if $type.defined {
                    my $name = $param.named_names.sort(*.chars).join("|");

                    if $param.default {
                       $os.push("{$name}={$type}", $param.WHY.Str, value => $param.default.());
                    } else {
                       $os.push("{$name}={$type}", $param.WHY.Str);
                    }
                } else {
                    die "Not support parameter: {$param.gist}";
                }
            }
        } else {
            my @const = $param.constraint_list;

            if @const[0] ~~ Str || @const[0] ~~ Int {
                if $noa-index++ == 0 {
                    $os.insert-cmd(@const[0]);
                }
            } else {
                if $param.slurpy {
                    
                } else {
                    $os.insert-pos(&guess-the-name($param), $noa-index++);
                }
            }
        }
    }
    $os;
}

sub read("load",
$c,
:a(:$abc), #= abc option
*@args) {
}

my OptionSet $os .= new;

mixin-option($os, &read);

&getopt($os);

say $os;
